/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols;

import org.eclipse.core.databinding.observable.value.DateAndTimeObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.commands.ECPCommand;
import org.eclipse.emf.ecp.editor.Activator;
import org.eclipse.emf.ecp.editor.mecontrols.AbstractMEControl;
import org.eclipse.emf.ecp.editor.mecontrols.IValidatableControl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class MESWTDateAndTimeControl
extends AbstractMEControl
implements IValidatableControl {
    private static final int PRIORITY = 3;
    private EAttribute attribute;
    private ImageHyperlink dateDeleteButton;
    private Composite dateComposite;
    private DateTime dateWidget;
    private DateTime timeWidget;
    private Label labelWidgetImage;

    public int canRender(IItemPropertyDescriptor itemPropertyDescriptor, EObject modelElement) {
        return 3;
    }

    protected Control createControl(Composite parent, int style) {
        this.attribute = (EAttribute)this.getItemPropertyDescriptor().getFeature((Object)this.getModelElement());
        this.dateComposite = this.getToolkit().createComposite(parent);
        this.dateComposite.setBackgroundMode(2);
        GridLayoutFactory.fillDefaults().numColumns(4).spacing(2, 0).applyTo(this.dateComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.dateComposite);
        this.createDateAndTimeWidget();
        IObservableValue model = EMFEditObservables.observeValue((EditingDomain)this.getEditingDomain(), (EObject)this.getModelElement(), (EStructuralFeature)this.attribute);
        EMFDataBindingContext dbc = new EMFDataBindingContext();
        ISWTObservableValue dateObserver = SWTObservables.observeSelection((Control)this.dateWidget);
        ISWTObservableValue timeObserver = SWTObservables.observeSelection((Control)this.timeWidget);
        dbc.bindValue((IObservableValue)new DateAndTimeObservableValue((IObservableValue)dateObserver, (IObservableValue)timeObserver), model, null, null);
        return this.dateComposite;
    }

    private void createDateAndTimeWidget() {
        this.labelWidgetImage = this.getToolkit().createLabel(this.dateComposite, "     ");
        this.labelWidgetImage.setBackground(this.dateComposite.getBackground());
        this.dateWidget = new DateTime(this.dateComposite, 32);
        this.dateWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        this.timeWidget = new DateTime(this.dateComposite, 32896);
        this.timeWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        this.dateDeleteButton = new ImageHyperlink(this.dateComposite, 128);
        this.dateDeleteButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.dateDeleteButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                new ECPCommand(MESWTDateAndTimeControl.this.getModelElement()){

                    protected void doRun() {
                        MESWTDateAndTimeControl.this.getModelElement().eSet((EStructuralFeature)MESWTDateAndTimeControl.this.attribute, null);
                    }
                }.run(true);
            }
        });
    }

    public void handleValidation(Diagnostic diagnostic) {
        if (diagnostic.getSeverity() == 4 || diagnostic.getSeverity() == 2) {
            Image image = Activator.getImageDescriptor("icons/validation_error.png").createImage();
            this.labelWidgetImage.setImage(image);
            this.labelWidgetImage.setToolTipText(diagnostic.getMessage());
        }
    }

    public void resetValidation() {
        this.labelWidgetImage.setImage(null);
        this.labelWidgetImage.setToolTipText("");
    }
}

