/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.util;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.common.util.Activator;
import org.osgi.service.prefs.BackingStoreException;

public final class PreferenceHelper {
    private static final String PREFERENCE_NODE = "ecp";

    private PreferenceHelper() {
    }

    public static String getPreference(String key, String defaultValue) {
        String value = Platform.getPreferencesService().getRootNode().node("configuration").node(PREFERENCE_NODE).get(key, defaultValue);
        return value;
    }

    public static void setPreference(String key, String value) {
        if (key != null && value != null) {
            Platform.getPreferencesService().getRootNode().node("configuration").node(PREFERENCE_NODE).put(key, value);
            try {
                Platform.getPreferencesService().getRootNode().node("configuration").node(PREFERENCE_NODE).flush();
            }
            catch (BackingStoreException e) {
                Activator.getDefault().logException("Could not persist the preference change: {" + key + ", " + value + "}", (Exception)((Object)e));
            }
        }
    }
}

