/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.navigator.wizards;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.common.commands.ECPCommand;
import org.eclipse.emf.ecp.common.model.ECPWorkspaceManager;
import org.eclipse.emf.ecp.common.model.NoWorkspaceException;
import org.eclipse.emf.ecp.common.model.workSpaceModel.ECPProject;
import org.eclipse.emf.ecp.common.model.workSpaceModel.ECPWorkspace;
import org.eclipse.emf.ecp.common.utilities.ActionHelper;
import org.eclipse.emf.ecp.navigator.Activator;
import org.eclipse.emf.ecp.navigator.wizards.ModelTreePage;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.emfstore.common.CommonUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class NewModelElementWizard
extends Wizard
implements IWorkbenchWizard {
    private EClass newMEType;
    private boolean treePageCompleted;
    private EObject selectedEObject;

    public void addPages() {
        ModelTreePage treePage = new ModelTreePage("ModelTreePage", this.selectedEObject.eClass());
        this.addPage((IWizardPage)treePage);
    }

    public boolean performFinish() {
        if (this.selectedEObject != null && this.newMEType != null) {
            EPackage ePackage = this.newMEType.getEPackage();
            final EObject newMEInstance = ePackage.getEFactoryInstance().create(this.newMEType);
            ECPProject tryProject = null;
            try {
                tryProject = ECPWorkspaceManager.getInstance().getWorkSpace().getProject(this.selectedEObject);
            }
            catch (NoWorkspaceException e1) {
                Activator.getDefault().logException(e1.getMessage(), (Exception)((Object)e1));
                return false;
            }
            final ECPProject project = tryProject;
            if (project != null && this.selectedEObject.equals(project.getRootObject())) {
                new ECPCommand(this.selectedEObject){

                    protected void doRun() {
                        project.addModelElementToRoot(newMEInstance);
                    }
                }.run(true);
            } else {
                EReference possibleContainingReference = CommonUtil.getPossibleContainingReference((EObject)newMEInstance, (EObject)this.selectedEObject);
                if (possibleContainingReference != null && possibleContainingReference.isMany()) {
                    try {
                        ECPWorkspace workSpace = ECPWorkspaceManager.getInstance().getWorkSpace();
                        Command create = AddCommand.create((EditingDomain)workSpace.getProject(this.selectedEObject).getEditingDomain(), (Object)this.selectedEObject, (Object)possibleContainingReference, (Object)newMEInstance);
                        workSpace.getProject(this.selectedEObject).getEditingDomain().getCommandStack().execute(create);
                    }
                    catch (NoWorkspaceException e) {
                        Activator.getDefault().logException(e.getMessage(), (Exception)((Object)e));
                    }
                }
            }
            ActionHelper.openModelElement((EObject)newMEInstance, (String)((Object)((Object)this)).getClass().getName());
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object o;
        if (!selection.isEmpty() && (o = selection.getFirstElement()) instanceof EObject) {
            this.selectedEObject = (EObject)o;
        }
    }

    public boolean canFinish() {
        return this.treePageCompleted;
    }

    public void setNewMEType(EClass newMEType) {
        this.newMEType = newMEType;
    }

    public void setTreePageCompleted(boolean treePageCompleted) {
        this.treePageCompleted = treePageCompleted;
    }
}

