/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.common.model.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class FileUtil {
    private FileUtil() {
    }

    public static void deleteFolder(File folder) throws IOException {
        if (folder.exists()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    FileUtil.deleteFolder(child);
                } else if (!child.delete()) {
                    throw new IOException("Deletion of file: " + child.getAbsolutePath() + " failed.");
                }
                ++n2;
            }
            if (!folder.delete()) {
                throw new IOException("Deletion of folder: " + folder.getAbsolutePath() + " failed.");
            }
        }
    }

    public static void copyFile(File source, File destination) throws IOException {
        FileUtil.copyFile(new FileInputStream(source), destination);
    }

    public static void copyFile(InputStream source, File destination) throws IOException {
        int read;
        if (source == null || destination == null) {
            throw new IOException("Source or destination is null.");
        }
        if (destination.getParentFile() != null) {
            destination.getParentFile().mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(destination);
        byte[] buffer = new byte[4096];
        while ((read = source.read(buffer)) != -1) {
            outputStream.write(buffer, 0, read);
        }
        source.close();
        outputStream.close();
    }

    public static void copyDirectory(File source, File destination) throws IOException {
        destination.mkdirs();
        if (!source.exists()) {
            return;
        }
        File[] fileArray = source.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileUtil.copyDirectory(file, new File(String.valueOf(destination.getAbsolutePath()) + File.separatorChar + file.getName()));
            } else {
                FileUtil.copyFile(file, new File(String.valueOf(destination.getAbsolutePath()) + File.separatorChar + file.getName()));
            }
            ++n2;
        }
    }

    public static void zipFolder(File source, File destination) throws IOException {
        if (!source.isDirectory()) {
            throw new IOException("Source must be folder.");
        }
        if (destination.exists()) {
            throw new IOException("Destination already exists.");
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destination)));
        String path = source.getPath();
        path = String.valueOf(path) + (path.endsWith(File.separator) ? "" : Character.valueOf(File.separatorChar));
        FileUtil.zip(source, path, zipOutputStream, new byte[8192]);
        zipOutputStream.close();
    }

    private static void zip(File current, String rootPath, ZipOutputStream zipStream, byte[] buffer) throws IOException {
        if (current.isDirectory()) {
            File[] fileArray = current.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!".".equals(file.getName()) && !"..".equals(file.getName())) {
                    FileUtil.zip(file, rootPath, zipStream, buffer);
                }
                ++n2;
            }
        } else if (current.isFile()) {
            int read;
            zipStream.putNextEntry(new ZipEntry(current.getPath().replace(rootPath, "")));
            FileInputStream file = new FileInputStream(current);
            while ((read = file.read(buffer)) != -1) {
                zipStream.write(buffer, 0, read);
            }
            zipStream.closeEntry();
        } else {
            throw new IllegalStateException();
        }
    }
}

