/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.common.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EMFStorePropertyType implements Enumerator
{
    SHARED(0, "Shared", "Shared"),
    LOCAL(1, "Local", "Local");

    public static final int SHARED_VALUE = 0;
    public static final int LOCAL_VALUE = 1;
    private static final EMFStorePropertyType[] VALUES_ARRAY;
    public static final List<EMFStorePropertyType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EMFStorePropertyType[]{SHARED, LOCAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EMFStorePropertyType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EMFStorePropertyType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EMFStorePropertyType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EMFStorePropertyType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EMFStorePropertyType get(int value) {
        switch (value) {
            case 0: {
                return SHARED;
            }
            case 1: {
                return LOCAL;
            }
        }
        return null;
    }

    private EMFStorePropertyType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

