/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.controller;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevertCommitController
extends ServerCall<Void> {
    private final ProjectSpace projectSpace;
    private final PrimaryVersionSpec versionSpec;

    public RevertCommitController(ProjectSpace projectSpace, PrimaryVersionSpec versionSpec) {
        this.projectSpace = projectSpace;
        this.versionSpec = versionSpec;
    }

    @Override
    protected Void run() throws EmfStoreException {
        ProjectSpace revertSpace = WorkspaceManager.getInstance().getCurrentWorkspace().checkout(this.projectSpace.getUsersession(), this.projectSpace.getProjectInfo(), this.versionSpec);
        PrimaryVersionSpec sourceVersion = (PrimaryVersionSpec)ModelUtil.clone((EObject)this.versionSpec);
        sourceVersion.setIdentifier(sourceVersion.getIdentifier() - 1);
        List<ChangePackage> changes = revertSpace.getChanges((VersionSpec)sourceVersion, (VersionSpec)this.versionSpec);
        if (changes.size() != 1) {
            throw new EmfStoreException("Zero or more than 1 Change Package received for one revision!");
        }
        ChangePackage changePackage = changes.get(0);
        ChangePackage reversedChangePackage = changePackage.reverse();
        reversedChangePackage.apply(revertSpace.getProject(), true);
        return null;
    }
}

