/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.changeTracking;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.emfstore.client.model.changeTracking.notification.NotificationInfo;
import org.eclipse.emf.emfstore.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.impl.IdEObjectCollectionImpl;
import org.eclipse.emf.emfstore.common.model.impl.ProjectImpl;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.ContainmentType;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiAttributeMoveOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiAttributeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiAttributeSetOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceMoveOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceSetOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.OperationsFactory;
import org.eclipse.emf.emfstore.server.model.versioning.operations.ReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.SingleReferenceOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NotificationToOperationConverter {
    private IdEObjectCollectionImpl project;

    public NotificationToOperationConverter(IdEObjectCollectionImpl project) {
        this.project = project;
    }

    public AbstractOperation convert(NotificationInfo n) {
        if (n.isTouch() || n.isTransient() || !n.isValid()) {
            return null;
        }
        switch (n.getEventType()) {
            case 1: {
                if (n.isAttributeNotification()) {
                    return this.handleSetAttribute(n);
                }
                return this.handleSetReference(n);
            }
            case 3: {
                if (n.isAttributeNotification()) {
                    return this.handleMultiAttribute(n);
                }
                return this.handleMultiReference(n);
            }
            case 5: {
                if (n.isAttributeNotification()) {
                    return this.handleMultiAttribute(n);
                }
                return this.handleMultiReference(n);
            }
            case 4: {
                if (n.isAttributeNotification()) {
                    return this.handleMultiAttribute(n);
                }
                return this.handleMultiReference(n);
            }
            case 6: {
                if (n.isAttributeNotification()) {
                    return this.handleMultiAttribute(n);
                }
                return this.handleMultiReference(n);
            }
            case 7: {
                if (n.isAttributeNotification()) {
                    return this.handleAttributeMove(n);
                }
                return this.handleReferenceMove(n);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private AbstractOperation handleMultiAttribute(NotificationInfo n) {
        MultiAttributeOperation operation = OperationsFactory.eINSTANCE.createMultiAttributeOperation();
        NotificationToOperationConverter.setCommonValues(this.project, (AbstractOperation)operation, n.getNotifierModelElement());
        operation.setFeatureName(n.getAttribute().getName());
        operation.setAdd(n.isAddEvent() || n.isAddManyEvent());
        List<Object> list = null;
        switch (n.getEventType()) {
            case 3: {
                list = new ArrayList();
                operation.getIndexes().add((Object)n.getPosition());
                list.add(n.getNewValue());
                break;
            }
            case 5: {
                void var4_5;
                list = (List)n.getNewValue();
                boolean bl = false;
                while (var4_5 < list.size()) {
                    operation.getIndexes().add((Object)(n.getPosition() + var4_5));
                    ++var4_5;
                }
                break;
            }
            case 4: {
                list = new ArrayList();
                operation.getIndexes().add((Object)n.getPosition());
                list.add(n.getOldValue());
                break;
            }
            case 6: {
                list = (List)n.getOldValue();
                if (n.getNewValue() == null) {
                    void var4_7;
                    boolean bl = false;
                    while (var4_7 < list.size()) {
                        operation.getIndexes().add((Object)((int)var4_7));
                        ++var4_7;
                    }
                } else {
                    int[] nArray = (int[])n.getNewValue();
                    int n2 = nArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4 = nArray[n3];
                        operation.getIndexes().add((Object)n4);
                        ++n3;
                    }
                }
                break;
            }
        }
        for (Object e : list) {
            operation.getReferencedValues().add(e);
        }
        return operation;
    }

    private AbstractOperation handleMultiReference(NotificationInfo n) {
        List<EObject> list = null;
        switch (n.getEventType()) {
            case 3: {
                list = new ArrayList();
                list.add(n.getNewModelElementValue());
                break;
            }
            case 5: {
                list = (List)n.getNewValue();
                break;
            }
            case 4: {
                list = new ArrayList();
                list.add(n.getOldModelElementValue());
                break;
            }
            case 6: {
                list = (List)n.getOldValue();
                break;
            }
        }
        boolean isAdd = n.isAddEvent() || n.isAddManyEvent();
        return NotificationToOperationConverter.createMultiReferenceOperation(this.project, n.getNotifierModelElement(), n.getReference(), list, isAdd, n.getPosition());
    }

    public static MultiReferenceOperation createMultiReferenceOperation(IdEObjectCollectionImpl collection, EObject modelElement, EReference reference, List<EObject> referencedElements, boolean isAdd, int position) {
        MultiReferenceOperation op = OperationsFactory.eINSTANCE.createMultiReferenceOperation();
        NotificationToOperationConverter.setCommonValues(collection, (AbstractOperation)op, modelElement);
        NotificationToOperationConverter.setBidirectionalAndContainmentInfo((ReferenceOperation)op, reference);
        op.setFeatureName(reference.getName());
        op.setAdd(isAdd);
        op.setIndex(position);
        EList referencedModelElements = op.getReferencedModelElements();
        for (EObject valueElement : referencedElements) {
            ModelElementId id = collection.getModelElementId(valueElement);
            if (id == null) {
                id = collection.getDeletedModelElementId(valueElement);
            }
            if (id != null) {
                referencedModelElements.add(id);
                continue;
            }
            if (ModelUtil.getProject((EObject)valueElement) != collection) continue;
            throw new IllegalStateException("Element in Project does not have an ID: " + valueElement);
        }
        return op;
    }

    private AbstractOperation handleReferenceMove(NotificationInfo n) {
        MultiReferenceMoveOperation op = OperationsFactory.eINSTANCE.createMultiReferenceMoveOperation();
        NotificationToOperationConverter.setCommonValues(this.project, (AbstractOperation)op, n.getNotifierModelElement());
        op.setFeatureName(n.getReference().getName());
        op.setReferencedModelElementId(this.project.getModelElementId(n.getNewModelElementValue()));
        op.setNewIndex(n.getPosition());
        op.setOldIndex(((Integer)n.getOldValue()).intValue());
        return op;
    }

    private AbstractOperation handleAttributeMove(NotificationInfo n) {
        MultiAttributeMoveOperation operation = OperationsFactory.eINSTANCE.createMultiAttributeMoveOperation();
        NotificationToOperationConverter.setCommonValues(this.project, (AbstractOperation)operation, n.getNotifierModelElement());
        operation.setFeatureName(n.getAttribute().getName());
        operation.setNewIndex(n.getPosition());
        operation.setOldIndex(((Integer)n.getOldValue()).intValue());
        operation.setReferencedValue(n.getNewValue());
        return operation;
    }

    private AbstractOperation handleSetAttribute(NotificationInfo n) {
        if (!n.getAttribute().isMany()) {
            Object op = null;
            op = this.isDiagramLayoutAttribute(n.getAttribute(), n.getNotifierModelElement()) ? OperationsFactory.eINSTANCE.createDiagramLayoutOperation() : OperationsFactory.eINSTANCE.createAttributeOperation();
            NotificationToOperationConverter.setCommonValues(this.project, (AbstractOperation)op, n.getNotifierModelElement());
            op.setFeatureName(n.getAttribute().getName());
            op.setNewValue(n.getNewValue());
            op.setOldValue(n.getOldValue());
            return op;
        }
        MultiAttributeSetOperation setOperation = OperationsFactory.eINSTANCE.createMultiAttributeSetOperation();
        NotificationToOperationConverter.setCommonValues(this.project, (AbstractOperation)setOperation, n.getNotifierModelElement());
        setOperation.setFeatureName(n.getAttribute().getName());
        setOperation.setNewValue(n.getNewValue());
        setOperation.setOldValue(n.getOldValue());
        setOperation.setIndex(n.getPosition());
        return setOperation;
    }

    public static SingleReferenceOperation createSingleReferenceOperation(IdEObjectCollectionImpl collection, ModelElementId oldReference, ModelElementId newReference, EReference reference, EObject modelElement) {
        SingleReferenceOperation op = OperationsFactory.eINSTANCE.createSingleReferenceOperation();
        NotificationToOperationConverter.setCommonValues(collection, (AbstractOperation)op, modelElement);
        op.setFeatureName(reference.getName());
        NotificationToOperationConverter.setBidirectionalAndContainmentInfo((ReferenceOperation)op, reference);
        op.setOldValue(oldReference);
        op.setNewValue(newReference);
        return op;
    }

    private AbstractOperation handleSetReference(NotificationInfo n) {
        ModelElementId oldModelElementId = this.project.getModelElementId(n.getOldModelElementValue());
        ModelElementId newModelElementId = this.project.getModelElementId(n.getNewModelElementValue());
        if (oldModelElementId == null) {
            oldModelElementId = ((ProjectImpl)this.project).getDeletedModelElementId(n.getOldModelElementValue());
        }
        if (newModelElementId == null) {
            newModelElementId = ((ProjectImpl)this.project).getDeletedModelElementId(n.getNewModelElementValue());
        }
        if (!n.getReference().isMany()) {
            return NotificationToOperationConverter.createSingleReferenceOperation(this.project, oldModelElementId, newModelElementId, n.getReference(), n.getNotifierModelElement());
        }
        MultiReferenceSetOperation setOperation = OperationsFactory.eINSTANCE.createMultiReferenceSetOperation();
        NotificationToOperationConverter.setCommonValues(this.project, (AbstractOperation)setOperation, (EObject)n.getNotifier());
        setOperation.setFeatureName(n.getReference().getName());
        NotificationToOperationConverter.setBidirectionalAndContainmentInfo((ReferenceOperation)setOperation, n.getReference());
        setOperation.setIndex(n.getPosition());
        if (n.getOldValue() != null) {
            setOperation.setOldValue(oldModelElementId);
        }
        if (n.getNewValue() != null) {
            setOperation.setNewValue(newModelElementId);
        }
        return setOperation;
    }

    private static void setCommonValues(IdEObjectCollectionImpl collection, AbstractOperation operation, EObject modelElement) {
        operation.setClientDate(new Date());
        ModelElementId id = collection.getModelElementId(modelElement);
        if (id == null) {
            id = collection.getDeletedModelElementId(modelElement);
        }
        if (id == null) {
            WorkspaceUtil.handleException(new IllegalStateException("Model Element does not have an ID: " + modelElement));
        }
        operation.setModelElementId(id);
    }

    private static void setBidirectionalAndContainmentInfo(ReferenceOperation referenceOperation, EReference reference) {
        if (reference.getEOpposite() != null) {
            referenceOperation.setBidirectional(true);
            referenceOperation.setOppositeFeatureName(reference.getEOpposite().getName());
        } else {
            referenceOperation.setBidirectional(false);
        }
        if (reference.isContainer()) {
            referenceOperation.setContainmentType(ContainmentType.CONTAINER);
        }
        if (reference.isContainment()) {
            referenceOperation.setContainmentType(ContainmentType.CONTAINMENT);
        }
    }

    private boolean isDiagramLayoutAttribute(EAttribute attribute, EObject modelElement) {
        boolean isLayoutAttribute = attribute.getName().equals("diagramLayout");
        return isLayoutAttribute;
    }
}

