/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.connection.xmlrpc;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.emfstore.common.model.EMFStoreProperty;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.server.EmfStore;
import org.eclipse.emf.emfstore.server.accesscontrol.AuthenticationControl;
import org.eclipse.emf.emfstore.server.connection.xmlrpc.XmlRpcConnectionHandler;
import org.eclipse.emf.emfstore.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.server.filetransfer.FileChunk;
import org.eclipse.emf.emfstore.server.filetransfer.FileTransferInformation;
import org.eclipse.emf.emfstore.server.model.ClientVersionInfo;
import org.eclipse.emf.emfstore.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.server.model.SessionId;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.model.accesscontrol.OrgUnitProperty;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcEmfStoreImpl
implements EmfStore,
AuthenticationControl {
    private EmfStore getEmfStore() {
        return XmlRpcConnectionHandler.getEmfStore();
    }

    private AuthenticationControl getAccessControl() {
        return XmlRpcConnectionHandler.getAccessControl();
    }

    @Override
    public SessionId logIn(String username, String password, ClientVersionInfo clientVersionInfo) throws AccessControlException {
        return this.getAccessControl().logIn(username, password, clientVersionInfo);
    }

    @Override
    public void logout(SessionId sessionId) throws AccessControlException {
        this.getAccessControl().logout(sessionId);
    }

    @Override
    public void addTag(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws EmfStoreException {
        this.getEmfStore().addTag(sessionId, projectId, versionSpec, tag);
    }

    @Override
    public ProjectInfo createEmptyProject(SessionId sessionId, String name, String description, LogMessage logMessage) throws EmfStoreException {
        return this.getEmfStore().createEmptyProject(sessionId, name, description, logMessage);
    }

    @Override
    public ProjectInfo createProject(SessionId sessionId, String name, String description, LogMessage logMessage, Project project) throws EmfStoreException {
        return this.getEmfStore().createProject(sessionId, name, description, logMessage, project);
    }

    @Override
    public PrimaryVersionSpec createVersion(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec baseVersionSpec, ChangePackage changePackage, LogMessage logMessage) throws EmfStoreException, InvalidVersionSpecException {
        return this.getEmfStore().createVersion(sessionId, projectId, baseVersionSpec, changePackage, logMessage);
    }

    @Override
    public void deleteProject(SessionId sessionId, ProjectId projectId, boolean deleteFiles) throws EmfStoreException {
        this.getEmfStore().deleteProject(sessionId, projectId, deleteFiles);
    }

    @Override
    public FileChunk downloadFileChunk(SessionId sessionId, ProjectId projectId, FileTransferInformation fileInformation) throws EmfStoreException {
        return this.getEmfStore().downloadFileChunk(sessionId, projectId, fileInformation);
    }

    @Override
    public ProjectHistory exportProjectHistoryFromServer(SessionId sessionId, ProjectId projectId) throws EmfStoreException {
        return this.getEmfStore().exportProjectHistoryFromServer(sessionId, projectId);
    }

    @Override
    public List<ChangePackage> getChanges(SessionId sessionId, ProjectId projectId, VersionSpec source, VersionSpec target) throws EmfStoreException {
        return this.getEmfStore().getChanges(sessionId, projectId, source, target);
    }

    @Override
    public List<HistoryInfo> getHistoryInfo(SessionId sessionId, ProjectId projectId, HistoryQuery historyQuery) throws EmfStoreException {
        return this.getEmfStore().getHistoryInfo(sessionId, projectId, historyQuery);
    }

    @Override
    public Project getProject(SessionId sessionId, ProjectId projectId, VersionSpec versionSpec) throws EmfStoreException {
        return this.getEmfStore().getProject(sessionId, projectId, versionSpec);
    }

    @Override
    public List<ProjectInfo> getProjectList(SessionId sessionId) throws EmfStoreException {
        return this.getEmfStore().getProjectList(sessionId);
    }

    @Override
    public ProjectId importProjectHistoryToServer(SessionId sessionId, ProjectHistory projectHistory) throws EmfStoreException {
        return this.getEmfStore().importProjectHistoryToServer(sessionId, projectHistory);
    }

    @Override
    public void removeTag(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws EmfStoreException {
        this.getEmfStore().removeTag(sessionId, projectId, versionSpec, tag);
    }

    @Override
    public ACUser resolveUser(SessionId sessionId, ACOrgUnitId id) throws EmfStoreException {
        return this.getEmfStore().resolveUser(sessionId, id);
    }

    @Override
    public PrimaryVersionSpec resolveVersionSpec(SessionId sessionId, ProjectId projectId, VersionSpec versionSpec) throws EmfStoreException {
        return this.getEmfStore().resolveVersionSpec(sessionId, projectId, versionSpec);
    }

    @Override
    public void transmitProperty(SessionId sessionId, OrgUnitProperty changedProperty, ACUser tmpUser, ProjectId projectId) throws EmfStoreException {
        this.getEmfStore().transmitProperty(sessionId, changedProperty, tmpUser, projectId);
    }

    @Override
    public FileTransferInformation uploadFileChunk(SessionId sessionId, ProjectId projectId, FileChunk fileChunk) throws EmfStoreException {
        return this.getEmfStore().uploadFileChunk(sessionId, projectId, fileChunk);
    }

    @Override
    public List<EMFStoreProperty> setEMFProperties(SessionId sessionId, List<EMFStoreProperty> properties, ProjectId projectId) throws EmfStoreException {
        if (properties != null && properties.size() > 0) {
            return this.getEmfStore().setEMFProperties(sessionId, properties, projectId);
        }
        return new ArrayList<EMFStoreProperty>();
    }

    @Override
    public List<EMFStoreProperty> getEMFProperties(SessionId sessionId, ProjectId projectId) throws EmfStoreException {
        return this.getEmfStore().getEMFProperties(sessionId, projectId);
    }
}

