/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.conflictDetection;

import java.util.Set;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.server.conflictDetection.ConflictDetectionStrategy;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AttributeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.DiagramLayoutOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.FeatureOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceMoveOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.ReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.SingleReferenceOperation;

public class FineGrainedConflictDetectionStrategy
implements ConflictDetectionStrategy {
    public boolean doConflict(AbstractOperation operationA, AbstractOperation operationB) {
        if (operationA instanceof DiagramLayoutOperation) {
            return this.doConflict((DiagramLayoutOperation)operationA, operationB);
        }
        if (operationA instanceof AttributeOperation) {
            return this.doConflict((AttributeOperation)operationA, operationB);
        }
        if (operationA instanceof MultiReferenceMoveOperation) {
            return this.doConflict((MultiReferenceMoveOperation)operationA, operationB);
        }
        if (operationA instanceof SingleReferenceOperation) {
            return this.doConflict((SingleReferenceOperation)operationA, operationB);
        }
        if (operationA instanceof MultiReferenceOperation) {
            return this.doConflict((MultiReferenceOperation)operationA, operationB);
        }
        if (operationA instanceof CreateDeleteOperation) {
            return this.doConflict((CreateDeleteOperation)operationA, operationB);
        }
        if (operationA instanceof CompositeOperation) {
            return this.doConflict((CompositeOperation)operationA, operationB);
        }
        throw new IllegalArgumentException("Unkown operation type: " + operationA);
    }

    private boolean doConflict(MultiReferenceOperation operationA, AbstractOperation operationB) {
        if (operationB instanceof AttributeOperation) {
            return false;
        }
        if (operationB instanceof MultiReferenceMoveOperation) {
            boolean sameFeature = operationA.getFeatureName().equals(((MultiReferenceMoveOperation)operationB).getFeatureName());
            boolean sameElement = operationA.getModelElementId().equals(operationB.getModelElementId());
            return sameElement && sameFeature;
        }
        if (operationB instanceof ReferenceOperation) {
            MultiReferenceOperation multiOperationA = operationA;
            ReferenceOperation referenceOperationB = (ReferenceOperation)operationB;
            boolean sameFeature = multiOperationA.getFeatureName().equals(referenceOperationB.getFeatureName());
            boolean sameElement = multiOperationA.getModelElementId().equals(referenceOperationB.getModelElementId());
            if (sameFeature && sameElement) {
                Set otherInvolvedModelElements = operationA.getOtherInvolvedModelElements();
                for (ModelElementId modelElementId : operationA.getReferencedModelElements()) {
                    if (!otherInvolvedModelElements.contains(modelElementId)) continue;
                    return true;
                }
            }
            if (multiOperationA.getOppositeFeatureName() != null) {
                sameFeature = multiOperationA.getOppositeFeatureName().equals(referenceOperationB.getFeatureName());
            }
            return false;
        }
        return this.doConflict(operationB, (AbstractOperation)operationA);
    }

    private boolean doConflict(CompositeOperation operationA, AbstractOperation operationB) {
        for (AbstractOperation subOperationA : operationA.getSubOperations()) {
            if (!this.doConflict(subOperationA, operationB)) continue;
            return true;
        }
        return false;
    }

    private boolean doConflict(DiagramLayoutOperation operationA, AbstractOperation operationB) {
        if (operationB instanceof DiagramLayoutOperation) {
            return operationA.getModelElementId().equals(operationA.getModelElementId());
        }
        return false;
    }

    public boolean isRequired(AbstractOperation requiredOperation, AbstractOperation operation) {
        if (requiredOperation instanceof CreateDeleteOperation) {
            return this.isRequired((CreateDeleteOperation)requiredOperation, operation);
        }
        if (requiredOperation instanceof MultiReferenceOperation && operation instanceof MultiReferenceMoveOperation) {
            return this.isRequired((MultiReferenceOperation)requiredOperation, (MultiReferenceMoveOperation)operation);
        }
        if (requiredOperation instanceof MultiReferenceOperation && operation instanceof MultiReferenceOperation) {
            return this.isRequired((MultiReferenceOperation)requiredOperation, (MultiReferenceOperation)operation);
        }
        if (requiredOperation instanceof CompositeOperation) {
            for (AbstractOperation abstractOperation : ((CompositeOperation)requiredOperation).getSubOperations()) {
                if (!this.isRequired(abstractOperation, operation)) continue;
                return true;
            }
            return false;
        }
        if (operation instanceof CompositeOperation) {
            for (AbstractOperation abstractOperation : ((CompositeOperation)operation).getSubOperations()) {
                if (!this.isRequired(requiredOperation, abstractOperation)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isRequired(MultiReferenceOperation requiredMultiReferenceOperation, MultiReferenceOperation multiReferenceOperation) {
        boolean sameElement = requiredMultiReferenceOperation.getModelElementId().equals(multiReferenceOperation.getModelElementId());
        boolean sameFeature = requiredMultiReferenceOperation.getFeatureName().equals(multiReferenceOperation.getFeatureName());
        if (sameElement && sameFeature && requiredMultiReferenceOperation.isAdd() && !multiReferenceOperation.isAdd()) {
            for (ModelElementId modelElementId : multiReferenceOperation.getReferencedModelElements()) {
                if (!requiredMultiReferenceOperation.getReferencedModelElements().contains((Object)modelElementId)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRequired(MultiReferenceOperation requiredMultiReferenceOperation, MultiReferenceMoveOperation moveOperation) {
        boolean sameElement = requiredMultiReferenceOperation.getModelElementId().equals(moveOperation.getModelElementId());
        boolean sameFeature = requiredMultiReferenceOperation.getFeatureName().equals(moveOperation.getFeatureName());
        if (sameElement && sameFeature) {
            for (ModelElementId modelElementId : requiredMultiReferenceOperation.getReferencedModelElements()) {
                if (!modelElementId.equals(moveOperation.getReferencedModelElementId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRequired(CreateDeleteOperation requiredOperation, AbstractOperation operation) {
        if (!requiredOperation.isDelete()) {
            if (operation instanceof FeatureOperation) {
                if (operation.getModelElementId().equals(requiredOperation.getModelElementId())) {
                    return true;
                }
                if (operation instanceof ReferenceOperation) {
                    return ((ReferenceOperation)operation).getOtherInvolvedModelElements().contains(requiredOperation.getModelElementId());
                }
                if (operation instanceof MultiReferenceMoveOperation) {
                    return ((MultiReferenceMoveOperation)operation).getReferencedModelElementId().equals(requiredOperation);
                }
                return false;
            }
            if (operation instanceof CompositeOperation) {
                for (AbstractOperation abstractOperation : ((CompositeOperation)operation).getSubOperations()) {
                    if (!this.isRequired(requiredOperation, abstractOperation)) continue;
                    return true;
                }
                return false;
            }
            if (operation instanceof CreateDeleteOperation) {
                return ((CreateDeleteOperation)operation).isDelete();
            }
        }
        return false;
    }

    private boolean doConflict(CreateDeleteOperation operationA, AbstractOperation operationB) {
        if (operationB instanceof CompositeOperation) {
            return this.doConflict(operationB, (AbstractOperation)operationA);
        }
        if (operationB instanceof ReferenceOperation) {
            for (ModelElementId modelElementId : ((ReferenceOperation)operationB).getOtherInvolvedModelElements()) {
                if (!operationA.getModelElementId().equals(modelElementId)) continue;
                return true;
            }
        }
        return operationA.getModelElementId().equals(operationB.getModelElementId());
    }

    private boolean doConflict(AttributeOperation operationA, AbstractOperation operationB) {
        if (!operationA.getModelElementId().equals(operationB.getModelElementId())) {
            return false;
        }
        if (operationB instanceof FeatureOperation) {
            FeatureOperation featureOperationB = (FeatureOperation)operationB;
            return featureOperationB.getFeatureName().equals(operationA.getFeatureName());
        }
        return this.doConflict(operationB, (AbstractOperation)operationA);
    }

    private boolean doConflict(MultiReferenceMoveOperation operationA, AbstractOperation operationB) {
        if (operationB instanceof MultiReferenceMoveOperation) {
            boolean sameElement = operationA.getModelElementId().equals(operationB.getModelElementId());
            boolean sameFeature = operationA.getFeatureName().equals(((MultiReferenceMoveOperation)operationB).getFeatureName());
            return sameElement && sameFeature;
        }
        if (operationB instanceof AttributeOperation) {
            return false;
        }
        return this.doConflict(operationB, (AbstractOperation)operationA);
    }

    private boolean doConflict(SingleReferenceOperation operationA, AbstractOperation operationB) {
        if (operationB instanceof SingleReferenceOperation) {
            SingleReferenceOperation singleOperationB = (SingleReferenceOperation)operationB;
            boolean sameFeature = operationA.getFeatureName().equals(singleOperationB.getFeatureName());
            if (operationA.getOppositeFeatureName() != null) {
                sameFeature = sameFeature || operationA.getOppositeFeatureName().equals(singleOperationB.getFeatureName());
            }
            boolean sameElement = operationA.getModelElementId().equals(operationB.getModelElementId());
            return sameFeature && sameElement;
        }
        if (operationB instanceof AttributeOperation) {
            return false;
        }
        if (operationB instanceof MultiReferenceMoveOperation) {
            return false;
        }
        return this.doConflict(operationB, (AbstractOperation)operationA);
    }
}

