/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.accesscontrol.authentication;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.accesscontrol.authentication.AbstractAuthenticationControl;
import org.eclipse.emf.emfstore.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.server.exceptions.FatalEmfStoreException;

public class SimplePropertyFileVerifier
extends AbstractAuthenticationControl {
    private Properties passwordFile;
    private final Hash hash;

    public SimplePropertyFileVerifier(String filePath) throws FatalEmfStoreException {
        this(filePath, Hash.NONE);
    }

    public SimplePropertyFileVerifier(String filePath, Hash hash) throws FatalEmfStoreException {
        if (hash == null) {
            throw new FatalEmfStoreException("Hash may not be null for verifier.");
        }
        this.hash = hash;
        this.passwordFile = new Properties();
        try {
            File propertyFile = new File(filePath);
            FileInputStream fis = new FileInputStream(propertyFile);
            this.passwordFile.load(fis);
            fis.close();
        }
        catch (IOException e) {
            ModelUtil.logInfo((String)("Couldn't load password file from path: " + filePath));
        }
    }

    protected boolean verifyPassword(String username, String password) throws AccessControlException {
        String expectedPassword = this.passwordFile.getProperty(username);
        password = this.hashPassword(password);
        return expectedPassword != null && expectedPassword.equals(password);
    }

    private String hashPassword(String password) {
        if (password == null || this.hash.equals((Object)Hash.NONE)) {
            return password;
        }
        try {
            MessageDigest md = null;
            switch (this.hash) {
                case SHA1: {
                    md = MessageDigest.getInstance("SHA-1");
                    break;
                }
                case MD5: {
                    md = MessageDigest.getInstance("MD5");
                }
            }
            if (md != null) {
                return new String(md.digest(password.getBytes()));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Hash {
        NONE,
        MD5,
        SHA1;

    }
}

