/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.dialogs.admin.acimport;

import java.util.ArrayList;
import java.util.Properties;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.eclipse.emf.emfstore.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.dialogs.admin.acimport.CorruptedSourceException;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.dialogs.admin.acimport.ImportItemWrapper;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.dialogs.admin.acimport.ImportSource;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.dialogs.admin.acimport.LdapSourceDialog;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.server.model.accesscontrol.AccesscontrolFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapImportSource
extends ImportSource {
    private static final String DEFAULT_CTX = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String LDAP_BASE = "ldapbase";
    private DirContext dirContext;
    private String[] attrSet = new String[]{"objectclass", "cn", "uid"};
    private String personObjectClass = "inetOrgPerson";
    private String groupObjectClass = "posixGroup";
    private Properties properties;

    @Override
    public boolean init(Shell shell) {
        LdapSourceDialog dialog = new LdapSourceDialog(shell, this);
        dialog.setBlockOnOpen(true);
        dialog.create();
        dialog.open();
        return dialog.getIsInitFinished();
    }

    @Override
    public String getLabel() {
        return "LDAP Import";
    }

    @Override
    public Object[] getChildren(Object arg0) {
        return this.setChildOrgUnits(arg0).getChildOrgUnits().toArray();
    }

    private ImportItemWrapper setChildOrgUnits(Object arg0) {
        try {
            ImportItemWrapper wrappedObject = (ImportItemWrapper)arg0;
            String str = (String)wrappedObject.getSourceObj();
            NamingEnumeration<NameClassPair> list = this.dirContext.list(str);
            ArrayList<ImportItemWrapper> arrayList = new ArrayList<ImportItemWrapper>();
            while (list.hasMore()) {
                ACGroup orgUnit;
                String nameInNamespace = list.next().getNameInNamespace();
                Attributes attr = new BasicAttributes();
                try {
                    attr = this.dirContext.getAttributes(nameInNamespace, this.attrSet);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                Attribute objectclasses = attr.get("objectclass");
                if (this.isGroup(objectclasses)) {
                    orgUnit = AccesscontrolFactory.eINSTANCE.createACGroup();
                    orgUnit.setName((String)attr.get("cn").get());
                } else if (this.isPerson(objectclasses)) {
                    orgUnit = AccesscontrolFactory.eINSTANCE.createACUser();
                    String username = attr.get("uid") != null ? (String)attr.get("uid").get() : (String)attr.get("cn").get();
                    orgUnit.setName(username);
                } else {
                    orgUnit = AccesscontrolFactory.eINSTANCE.createACOrgUnit();
                    if (attr.get("cn") != null) {
                        orgUnit.setName((String)attr.get("cn").get());
                    } else {
                        orgUnit.setName(nameInNamespace);
                    }
                }
                arrayList.add(new ImportItemWrapper(nameInNamespace, (ACOrgUnit)orgUnit, wrappedObject));
            }
            wrappedObject.setChildOrgUnits(arrayList);
            return wrappedObject;
        }
        catch (NamingException e) {
            WorkspaceUtil.logException((String)e.getMessage(), (Exception)e);
            return null;
        }
    }

    @Override
    public Object[] getElements(Object arg0) {
        try {
            NamingEnumeration<NameClassPair> list = this.dirContext.list(this.properties.getProperty(LDAP_BASE));
            ArrayList<ImportItemWrapper> arrayList = new ArrayList<ImportItemWrapper>();
            while (list.hasMore()) {
                ACGroup orgUnit;
                String nameInNamespace = list.next().getNameInNamespace();
                Attributes attr = this.dirContext.getAttributes(nameInNamespace, this.attrSet);
                Attribute objectclasses = attr.get("objectclass");
                if (this.isGroup(objectclasses)) {
                    orgUnit = AccesscontrolFactory.eINSTANCE.createACGroup();
                    orgUnit.setName((String)attr.get("cn").get());
                } else if (this.isPerson(objectclasses)) {
                    orgUnit = AccesscontrolFactory.eINSTANCE.createACUser();
                    String username = attr.get("uid") != null ? (String)attr.get("uid").get() : (String)attr.get("cn").get();
                    orgUnit.setName(username);
                } else {
                    orgUnit = AccesscontrolFactory.eINSTANCE.createACOrgUnit();
                    if (attr.get("cn") != null) {
                        orgUnit.setName((String)attr.get("cn").get());
                    } else {
                        orgUnit.setName(nameInNamespace);
                    }
                }
                arrayList.add(new ImportItemWrapper(nameInNamespace, (ACOrgUnit)orgUnit));
            }
            return arrayList.toArray();
        }
        catch (NamingException e) {
            WorkspaceUtil.logException((String)e.getMessage(), (Exception)e);
            return null;
        }
    }

    private boolean isGroup(Attribute objectclasses) throws NamingException {
        if (objectclasses == null) {
            return false;
        }
        int i = 0;
        while (i < objectclasses.size()) {
            if (((String)objectclasses.get(i)).equals(this.groupObjectClass)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isPerson(Attribute objectclasses) throws NamingException {
        if (objectclasses == null) {
            return false;
        }
        int i = 0;
        while (i < objectclasses.size()) {
            if (((String)objectclasses.get(i)).equals(this.personObjectClass)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ArrayList<NameClassPair> namingEnumerationToArrayList(NamingEnumeration<NameClassPair> list) throws NamingException {
        ArrayList<NameClassPair> arrayList = new ArrayList<NameClassPair>();
        while (list.hasMore()) {
            arrayList.add(list.next());
        }
        return arrayList;
    }

    public void setProperties(Properties serverProperties) {
        this.properties = serverProperties;
    }

    public void connect() throws CorruptedSourceException {
        this.properties.put("java.naming.ldap.version", "3");
        this.properties.put("java.naming.factory.initial", DEFAULT_CTX);
        try {
            this.dirContext = new InitialDirContext(this.properties);
        }
        catch (NamingException e) {
            WorkspaceUtil.logWarning((String)e.getMessage(), (Exception)e);
            throw new CorruptedSourceException("Couldn't connect to server!");
        }
    }

    @Override
    public String getMessage() {
        return "Import from " + this.properties.getProperty("java.naming.provider.url") + " with base: " + this.properties.getProperty(LDAP_BASE);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }
}

