/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.dialogs.admin.acimport;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.emf.emfstore.client.model.AdminBroker;
import org.eclipse.emf.emfstore.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.client.ui.util.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.dialogs.admin.acimport.ImportItemWrapper;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.dialogs.admin.acimport.ImportSource;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportController {
    private final AdminBroker adminBroker;
    private ImportSource importSource;
    private Hashtable<ACOrgUnitId, ImportItemWrapper> importedUnits;

    public ImportController(AdminBroker adminBroker) {
        this.adminBroker = adminBroker;
        this.importedUnits = new Hashtable();
    }

    public void importOrgUnits(ArrayList<ImportItemWrapper> wrappedOrgUnits) {
        this.importGroups(wrappedOrgUnits);
        this.importUsers(wrappedOrgUnits);
        this.setAssociations();
    }

    private void importUsers(ArrayList<ImportItemWrapper> wrappedOrgUnits) {
        int i = 0;
        while (i < wrappedOrgUnits.size()) {
            ImportItemWrapper wrappedOrgUnit = wrappedOrgUnits.get(i);
            if (wrappedOrgUnit.getOrgUnit() instanceof ACUser) {
                try {
                    String username = wrappedOrgUnit.getOrgUnit().getName();
                    if (this.existUser(username) == null) {
                        this.importedUnits.put(this.adminBroker.createUser(username), wrappedOrgUnit);
                    }
                }
                catch (EmfStoreException e) {
                    WorkspaceUtil.logWarning((String)e.getMessage(), (Exception)((Object)e));
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
                }
            }
            ++i;
        }
    }

    private void importGroups(ArrayList<ImportItemWrapper> wrappedOrgUnits) {
        int i = 0;
        while (i < wrappedOrgUnits.size()) {
            ImportItemWrapper wrappedOrgUnit = wrappedOrgUnits.get(i);
            if (wrappedOrgUnit.getOrgUnit() instanceof ACGroup) {
                try {
                    String groupname = wrappedOrgUnit.getOrgUnit().getName();
                    if (this.existGroup(groupname) == null) {
                        this.importedUnits.put(this.adminBroker.createGroup(groupname), wrappedOrgUnit);
                    }
                }
                catch (EmfStoreException e) {
                    WorkspaceUtil.logWarning((String)e.getMessage(), (Exception)((Object)e));
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
                }
            }
            ++i;
        }
    }

    private void setAssociations() {
        for (ACOrgUnitId unitId : this.importedUnits.keySet()) {
            ACOrgUnitId existGroup;
            if (this.importedUnits.get(unitId).getParentOrgUnit() == null || (existGroup = this.existGroup(this.importedUnits.get(unitId).getParentOrgUnit().getOrgUnit().getName())) == null || existGroup.equals(unitId)) continue;
            try {
                this.adminBroker.addMember(existGroup, unitId);
            }
            catch (EmfStoreException e) {
                WorkspaceUtil.logWarning((String)e.getMessage(), (Exception)((Object)e));
                EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
            }
        }
    }

    private ACOrgUnitId existGroup(String groupName) {
        ACOrgUnitId exist = null;
        try {
            List groups = this.getAdminBroker().getGroups();
            for (ACGroup gr : groups) {
                if (!gr.getName().equalsIgnoreCase(groupName)) continue;
                exist = gr.getId();
            }
        }
        catch (EmfStoreException e) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
        }
        return exist;
    }

    private ACOrgUnitId existUser(String userName) {
        ACOrgUnitId exist = null;
        try {
            List users = this.getAdminBroker().getUsers();
            for (ACUser us : users) {
                if (!us.getName().equalsIgnoreCase(userName)) continue;
                exist = us.getId();
            }
        }
        catch (EmfStoreException e) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
        }
        return exist;
    }

    public AdminBroker getAdminBroker() {
        return this.adminBroker;
    }

    public void setImportSource(ImportSource importSource) {
        this.importSource = importSource;
    }

    public ImportSource getImportSource() {
        return this.importSource;
    }

    public String getTitle() {
        return this.importSource == null ? "" : this.importSource.getLabel();
    }

    public String getMessage() {
        return this.importSource == null ? "" : this.importSource.getMessage();
    }
}

