/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.dialogs.admin.acimport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.emfstore.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.client.ui.util.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.client.ui.util.EMFStorePreferenceHelper;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.dialogs.admin.acimport.ImportItemWrapper;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.dialogs.admin.acimport.ImportSource;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.model.accesscontrol.AccesscontrolFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CSVImportSource
extends ImportSource {
    private static final String CSV_IMPORT_SOURCE_PATH = "org.eclipse.emf.emfstore.client.ui.CSVImportSourcePath";
    private HashMap<String, ImportItemWrapper> groupMap = new HashMap();
    private ArrayList<ImportItemWrapper> groups;
    private ArrayList<ImportItemWrapper> users;
    private String absFileName;

    public Object[] getChildren(Object ob) {
        ImportItemWrapper importWrapper = (ImportItemWrapper)ob;
        if (importWrapper != null && importWrapper.getChildOrgUnits() != null) {
            return importWrapper.getChildOrgUnits().toArray();
        }
        return null;
    }

    public Object[] getElements(Object ob) {
        return this.groups.toArray();
    }

    public String getLabel() {
        return "import from CSV file";
    }

    public boolean init(Shell shell) {
        this.groups = new ArrayList();
        this.users = new ArrayList();
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
        dialog.setText("Choose import file");
        String initialPath = EMFStorePreferenceHelper.getPreference(CSV_IMPORT_SOURCE_PATH, System.getProperty("user.home"));
        dialog.setFilterPath(initialPath);
        String fn = dialog.open();
        if (fn == null) {
            return false;
        }
        String fileName = dialog.getFileName();
        String filterPath = dialog.getFilterPath();
        if (fileName == null) {
            return false;
        }
        this.absFileName = String.valueOf(filterPath) + File.separatorChar + fileName;
        File file = new File(this.absFileName);
        EMFStorePreferenceHelper.setPreference(CSV_IMPORT_SOURCE_PATH, filterPath);
        BufferedReader bufferedReader = null;
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(new FileInputStream(file));
            bufferedReader = new BufferedReader(isr);
            String line = bufferedReader.readLine();
            int indexUserName = 0;
            int indexForGroup = 1;
            int counter = 0;
            while ((line = bufferedReader.readLine()) != null) {
                ArrayList<ImportItemWrapper> childOrgUnits;
                String[] title = line.split(",");
                String userName = title[indexUserName];
                String groupName = title[indexForGroup];
                ImportItemWrapper importWrapper = null;
                if (this.groupMap.get(groupName) == null) {
                    ACGroup group = AccesscontrolFactory.eINSTANCE.createACGroup();
                    importWrapper = new ImportItemWrapper(null, (ACOrgUnit)group);
                    group.setName(groupName);
                    this.groups.add(importWrapper);
                    this.groupMap.put(groupName, importWrapper);
                    childOrgUnits = new ArrayList();
                } else {
                    importWrapper = this.groupMap.get(groupName);
                    childOrgUnits = importWrapper.getChildOrgUnits();
                }
                ACUser user = AccesscontrolFactory.eINSTANCE.createACUser();
                user.setName(userName);
                ImportItemWrapper userImportWrapper = new ImportItemWrapper(null, (ACOrgUnit)user, importWrapper);
                this.users.add(userImportWrapper);
                childOrgUnits.add(userImportWrapper);
                importWrapper.setChildOrgUnits(childOrgUnits);
                ++counter;
            }
            bufferedReader.close();
            isr.close();
        }
        catch (FileNotFoundException e) {
            WorkspaceUtil.logWarning((String)e.getMessage(), (Exception)e);
            EMFStoreMessageDialog.showExceptionDialog("File not found", e);
            return false;
        }
        catch (IOException e) {
            WorkspaceUtil.logWarning((String)e.getMessage(), (Exception)e);
            EMFStoreMessageDialog.showExceptionDialog("An I/O-exception occured", e);
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            WorkspaceUtil.logWarning((String)e.getMessage(), (Exception)e);
            EMFStoreMessageDialog.showExceptionDialog("ArrayIndexOutOfBoundsException", e);
            return false;
        }
        return true;
    }

    public String getMessage() {
        return "Importing from file: " + this.absFileName;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }
}

