/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.testers;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.emfstore.client.model.ServerInfo;
import org.eclipse.emf.emfstore.client.model.Usersession;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.accesscontrol.AccessControlHelper;
import org.eclipse.emf.emfstore.client.model.util.EMFStoreCommandWithResult;
import org.eclipse.emf.emfstore.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.server.model.ProjectInfo;

public class IsServerAdminTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, final Object expectedValue) {
        if ((receiver instanceof ServerInfo || receiver instanceof ProjectInfo) && expectedValue instanceof Boolean) {
            ServerInfo serverInfo = null;
            if (receiver instanceof ServerInfo) {
                serverInfo = (ServerInfo)receiver;
            } else if (receiver instanceof ProjectInfo) {
                ProjectInfo projectInfo = (ProjectInfo)receiver;
                serverInfo = this.findServerInfo(projectInfo);
            }
            final ServerInfo finalServerInfo = serverInfo;
            EMFStoreCommandWithResult<Boolean> command = new EMFStoreCommandWithResult<Boolean>(){

                protected Boolean doRun() {
                    Usersession usersession = finalServerInfo.getLastUsersession();
                    boolean isAdmin = false;
                    if (usersession != null && usersession.getACUser() != null) {
                        AccessControlHelper accessControlHelper = new AccessControlHelper(usersession);
                        try {
                            accessControlHelper.checkServerAdminAccess();
                            isAdmin = true;
                        }
                        catch (AccessControlException accessControlException) {
                            // empty catch block
                        }
                    }
                    return new Boolean(isAdmin).equals(expectedValue);
                }
            };
            Boolean result = (Boolean)command.run(false);
            return result;
        }
        return false;
    }

    private ServerInfo findServerInfo(ProjectInfo projectInfo) {
        for (ServerInfo serverInfo : WorkspaceManager.getInstance().getCurrentWorkspace().getServerInfos()) {
            if (projectInfo.eContainer() != null && projectInfo.eContainer().equals(serverInfo)) {
                return serverInfo;
            }
            for (ProjectInfo info : serverInfo.getProjectInfos()) {
                if (!info.getProjectId().equals(projectInfo.getProjectId())) continue;
                return serverInfo;
            }
        }
        return null;
    }
}

