/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.DecisionManager;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.Conflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.DecisionUtil;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.SingleReferenceOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReferenceSetSingleConflict
extends Conflict {
    public MultiReferenceSetSingleConflict(List<AbstractOperation> leftOperations, List<AbstractOperation> rightOperations, DecisionManager decisionManager, boolean setLeft) {
        super(leftOperations, rightOperations, decisionManager, setLeft, true);
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        String descriptionTxt = "You have moved [target] to the [feature] reference of [modelelement], on the repository it was moved to [othercontainer].";
        description.setDescription(descriptionTxt);
        description.add("target", ((SingleReferenceOperation)this.getRightOperation()).getNewValue());
        description.add("othercontainer", this.getTheirOperation().getModelElementId());
        description.setImage("multiref.gif");
        return description;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ConflictOption myOption = new ConflictOption("", ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ConflictOption theirOption = new ConflictOption("", ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        EObject target = this.getDecisionManager().getModelElement(((SingleReferenceOperation)this.getLeftOperation()).getNewValue());
        myOption.setOptionLabel("Move " + DecisionUtil.getClassAndName(target) + "to" + DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getMyOperation().getModelElementId())));
        theirOption.setOptionLabel("Move " + DecisionUtil.getClassAndName(target) + " to" + DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getTheirOperation().getModelElementId())));
        options.add(myOption);
        options.add(theirOption);
    }
}

