/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.DecisionManager;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictContext;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.CustomConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.CustomConflictOptionFactory;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.DecisionUtil;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPoint;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.FeatureOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Conflict
extends Observable {
    private DecisionManager decisionManager;
    private ArrayList<ConflictOption> options;
    private ConflictOption solution;
    private ConflictContext conflictContext;
    private ConflictDescription conflictDescription;
    private List<AbstractOperation> leftOperations;
    private List<AbstractOperation> rightOperations;
    private boolean leftIsMy;

    public Conflict(List<AbstractOperation> leftOperations, List<AbstractOperation> rightOperations, DecisionManager decisionManager) {
        this(leftOperations, rightOperations, decisionManager, true, true);
    }

    public boolean isLeftMy() {
        return this.leftIsMy;
    }

    public Conflict(List<AbstractOperation> leftOperations, List<AbstractOperation> rightOperations, DecisionManager decisionManager, boolean leftIsMy, boolean init) {
        this.leftIsMy = leftIsMy;
        this.leftOperations = leftOperations;
        this.rightOperations = rightOperations;
        this.decisionManager = decisionManager;
        if (init) {
            this.init();
        }
    }

    protected void init() {
        this.conflictContext = this.initConflictContext();
        this.conflictDescription = this.initConflictDescription();
        this.options = new ArrayList();
        this.initConflictOptions(this.options);
        this.initAdditionalConflictOptions(this.options);
    }

    private void initAdditionalConflictOptions(ArrayList<ConflictOption> options2) {
        if (!this.allowOtherOptions()) {
            return;
        }
        for (ExtensionElement element : new ExtensionPoint("org.eclipse.emf.emfstore.client.ui.merge.customoption").getExtensionElements()) {
            CustomConflictOption customConflictOption;
            CustomConflictOptionFactory factory = (CustomConflictOptionFactory)element.getClass("class", CustomConflictOptionFactory.class);
            if (factory == null || !factory.isApplicableConflict(this) || (customConflictOption = factory.createCustomConflictOption(this)) == null) continue;
            this.options.add(customConflictOption);
        }
    }

    protected boolean allowOtherOptions() {
        return true;
    }

    protected abstract void initConflictOptions(List<ConflictOption> var1);

    protected abstract ConflictDescription initConflictDescription(ConflictDescription var1);

    private ConflictDescription initConflictDescription() {
        ConflictDescription description = new ConflictDescription("");
        description.setImage("notset.gif");
        EObject modelElement = this.getDecisionManager().getModelElement(this.getMyOperation().getModelElementId());
        if (modelElement != null) {
            description.add("modelelement", modelElement);
        }
        if (this.getMyOperation() instanceof FeatureOperation) {
            description.add("feature", ((FeatureOperation)this.getMyOperation()).getFeatureName());
        }
        description.setDecisionManager(this.getDecisionManager());
        return this.initConflictDescription(description);
    }

    protected ConflictContext initConflictContext() {
        return new ConflictContext(this.getDecisionManager(), this.getMyOperation(), this.getTheirOperation());
    }

    public ConflictContext getConflictContext() {
        return this.conflictContext;
    }

    public ConflictDescription getConflictDescription() {
        return this.conflictDescription;
    }

    public List<ConflictOption> getOptions() {
        return this.options;
    }

    public boolean isResolved() {
        return this.solution != null;
    }

    public boolean hasDetails() {
        for (ConflictOption option : this.getOptions()) {
            if (!option.isDetailsProvider()) continue;
            return true;
        }
        return false;
    }

    public void setSolution(ConflictOption conflictOption) {
        this.solution = conflictOption;
        this.setChanged();
        this.notifyObservers();
    }

    public DecisionManager getDecisionManager() {
        return this.decisionManager;
    }

    public ConflictOption getSolution() {
        return this.solution;
    }

    public List<AbstractOperation> getRejectedTheirs() {
        if (!this.isResolved()) {
            throw new IllegalStateException("Can't call this method, unless conflict is resolved.");
        }
        if (this.solution.getType() == ConflictOption.OptionType.TheirOperation) {
            return new ArrayList<AbstractOperation>();
        }
        for (ConflictOption options : this.getOptions()) {
            if (options.getType() != ConflictOption.OptionType.TheirOperation) continue;
            return options.getOperations();
        }
        throw new IllegalStateException("No TheirOperations found.");
    }

    public List<AbstractOperation> getAcceptedMine() {
        if (!this.isResolved()) {
            throw new IllegalStateException("Can't call this method, unless conflict is resolved.");
        }
        if (this.solution.getType() == ConflictOption.OptionType.TheirOperation) {
            return new ArrayList<AbstractOperation>();
        }
        return this.solution.getOperations();
    }

    public ConflictOption getOptionOfType(ConflictOption.OptionType type) {
        return DecisionUtil.getConflictOptionByType(this.getOptions(), type);
    }

    protected List<AbstractOperation> getMyOperations() {
        return this.leftIsMy ? this.leftOperations : this.rightOperations;
    }

    protected List<AbstractOperation> getTheirOperations() {
        return !this.leftIsMy ? this.leftOperations : this.rightOperations;
    }

    protected List<AbstractOperation> getLeftOperations() {
        return this.leftOperations;
    }

    protected List<AbstractOperation> getRightOperations() {
        return this.rightOperations;
    }

    protected AbstractOperation getLeftOperation() {
        return this.leftOperations.get(0);
    }

    protected AbstractOperation getRightOperation() {
        return this.rightOperations.get(0);
    }

    protected AbstractOperation getMyOperation() {
        return this.getMyOperations().get(0);
    }

    protected AbstractOperation getTheirOperation() {
        return this.getTheirOperations().get(0);
    }

    protected <T> T getMyOperation(Class<T> clazz) {
        return (T)this.getMyOperation();
    }

    protected <T> T getTheirOperation(Class<T> clazz) {
        return (T)this.getTheirOperation();
    }
}

