/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.model.internal;

import org.eclipse.fx.ide.model.IFXCollectionProperty;
import org.eclipse.fx.ide.model.internal.FXClass;
import org.eclipse.fx.ide.model.internal.FXProperty;
import org.eclipse.fx.ide.model.internal.utils.Util;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class FXCollectionProperty
extends FXProperty
implements IFXCollectionProperty {
    private String collectionTypeAsString;
    private String genericType;
    private IType elementType;

    public FXCollectionProperty(FXClass fxClass, String name, IMethod javaElement, String erasedFQNType, String genericType, boolean isStatic) {
        super(fxClass, name, (IJavaElement)javaElement, isStatic);
        this.collectionTypeAsString = erasedFQNType;
        this.genericType = genericType;
    }

    public static boolean isList(IJavaProject jp, String erasedFQNType) throws JavaModelException {
        String checkType = erasedFQNType;
        do {
            if ("javafx.collections.ObservableList".equals(checkType) || "javafx.collections.ObservableSet".equals(checkType) || "java.util.Collection".equals(checkType)) {
                return true;
            }
            IType t = jp.findType(checkType);
            if ((checkType = t.getSuperclassName()) == null) continue;
            checkType = Util.getFQNType(t, checkType);
        } while (checkType != null);
        return false;
    }

    public String toString() {
        return "FXCollectionProperty(" + this.getName() + ")";
    }

    @Override
    public String getCollectionTypeAsString(boolean fqn) {
        return fqn ? this.collectionTypeAsString : Signature.getSimpleName((String)this.collectionTypeAsString);
    }

    @Override
    public String getCollectionAsString() {
        return Signature.getSimpleName((String)this.genericType);
    }

    @Override
    public IType getElementType() {
        if (this.elementType == null) {
            String fqnType;
            block8: {
                String eType;
                IMethod m = (IMethod)this.getJavaElement();
                String signature = this.isSetable() ? m.getParameterTypes()[0] : m.getReturnType();
                String genericType = Signature.toString((String)signature);
                if (genericType.contains("extends")) {
                    eType = genericType.substring(genericType.indexOf("extends") + "extends".length(), genericType.indexOf(62));
                } else if (genericType.contains("super")) {
                    eType = genericType.substring(genericType.indexOf("super") + "super".length(), genericType.indexOf(62));
                } else {
                    eType = genericType.substring(genericType.indexOf(60) + 1, genericType.lastIndexOf(62));
                    eType = Signature.getTypeErasure((String)eType);
                }
                eType = eType.trim();
                IType t = (IType)m.getParent();
                fqnType = Util.getFQNType(t, eType);
                if (fqnType != null) break block8;
                return null;
            }
            try {
                this.elementType = this.getFXClass().getJavaProject().findType(fqnType);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return this.elementType;
    }
}

