/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Rendering_intent implements Enumerator
{
    AUTO(0, "auto", "auto"),
    PERCEPTUAL(1, "perceptual", "perceptual"),
    RELATIVE_COLORIMETRIC(2, "relative_colorimetric", "relative-colorimetric"),
    SATURATION(3, "saturation", "saturation"),
    ABSOLUTE_COLORIMETRIC(4, "absolute_colorimetric", "absolute-colorimetric");

    public static final int AUTO_VALUE = 0;
    public static final int PERCEPTUAL_VALUE = 1;
    public static final int RELATIVE_COLORIMETRIC_VALUE = 2;
    public static final int SATURATION_VALUE = 3;
    public static final int ABSOLUTE_COLORIMETRIC_VALUE = 4;
    private static final Rendering_intent[] VALUES_ARRAY;
    public static final List<Rendering_intent> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Rendering_intent[]{AUTO, PERCEPTUAL, RELATIVE_COLORIMETRIC, SATURATION, ABSOLUTE_COLORIMETRIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Rendering_intent get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Rendering_intent result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Rendering_intent getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Rendering_intent result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Rendering_intent get(int value) {
        switch (value) {
            case 0: {
                return AUTO;
            }
            case 1: {
                return PERCEPTUAL;
            }
            case 2: {
                return RELATIVE_COLORIMETRIC;
            }
            case 3: {
                return SATURATION;
            }
            case 4: {
                return ABSOLUTE_COLORIMETRIC;
            }
        }
        return null;
    }

    private Rendering_intent(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

