/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.editors;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.fx.ide.jdt.ui.internal.editors.AddFontDialog;
import org.eclipse.fx.ide.jdt.ui.internal.editors.AddIconDialog;
import org.eclipse.fx.ide.jdt.ui.internal.editors.AddManifestAttributeDialog;
import org.eclipse.fx.ide.jdt.ui.internal.editors.AddMetaInfFileDialog;
import org.eclipse.fx.ide.jdt.ui.internal.editors.AddSplashDialog;
import org.eclipse.fx.ide.jdt.ui.internal.editors.Messages;
import org.eclipse.fx.ide.jdt.ui.internal.editors.PropertiesToModelTransformer;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.AntTask;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.AntTasksPackage;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.PackagingFormat;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.ApplicationToolkitType;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.Icon;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.KeyValuePair;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.Param;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.ParametersFactory;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.ParametersPackage;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.Splash;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.MainTypeSelectionDialog;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class JFXBuildConfigurationEditor
extends MultiPageEditorPart {
    final WritableValue bean = new WritableValue();
    AdapterFactoryEditingDomain editingDomain;
    private ComposedAdapterFactory adapterFactory;
    Viewer currentViewer;
    boolean updateProblemIndication = true;
    Collection<Resource> removedResources = new ArrayList<Resource>();
    Collection<Resource> changedResources = new ArrayList<Resource>();
    Collection<Resource> savedResources = new ArrayList<Resource>();
    private Properties properties = new Properties();
    private MarkerHelper markerHelper = new EditUIMarkerHelper();
    Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    private FormToolkit toolkit;
    private static final int DELAY = 500;
    private DataBindingContext dbc;
    protected ISelectionChangedListener selectionChangedListener;
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).JFXBuildConfigurationEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        Resource resource;
                        if (delta.getResource().getType() == 1 && (delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                            if (delta.getKind() == 2) {
                                this.removedResources.add(resource);
                            } else if (!(this).JFXBuildConfigurationEditor.this.savedResources.remove(resource)) {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    JFXBuildConfigurationEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).JFXBuildConfigurationEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!JFXBuildConfigurationEditor.this.isDirty()) {
                                JFXBuildConfigurationEditor.this.getSite().getPage().closeEditor((IEditorPart)JFXBuildConfigurationEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    JFXBuildConfigurationEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).JFXBuildConfigurationEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (JFXBuildConfigurationEditor.this.getSite().getPage().getActiveEditor() == JFXBuildConfigurationEditor.this) {
                                JFXBuildConfigurationEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    };
    private EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = JFXBuildConfigurationEditor.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            JFXBuildConfigurationEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            JFXBuildConfigurationEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!JFXBuildConfigurationEditor.this.updateProblemIndication) return;
                        JFXBuildConfigurationEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                JFXBuildConfigurationEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
        }
    };

    public JFXBuildConfigurationEditor() {
        this.initializeEditingDomain();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    private boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.JFXBuildConfigurationEditor_FileConflict, (String)"There are unsaved changes that conflict with changes made outside the editor.  Do you wish to discard this editor's changes?");
    }

    private void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                    this.bean.setValue((Object)this.getTask());
                    this.dbc.updateTargets();
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, JFXBuildConfigurationEditor.analyzeResourceProblems(resource, exception));
                }
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    private void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                JFXBuildConfigurationEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        JFXBuildConfigurationEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            JFXBuildConfigurationEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    private void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (JFXBuildConfigurationEditor.this.currentViewer != null) {
                        JFXBuildConfigurationEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : JFXBuildConfigurationEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !JFXBuildConfigurationEditor.this.isPersisted(resource) || JFXBuildConfigurationEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            JFXBuildConfigurationEditor.this.savedResources.add(resource);
                        }
                    }
                    catch (Exception exception) {
                        JFXBuildConfigurationEditor.this.resourceToDiagnosticMap.put(resource, JFXBuildConfigurationEditor.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.fx.ide.jdt.ui", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    static Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.fx.ide.jdt.ui", 0, "_UI_CreateModelError_message", new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.fx.ide.jdt.ui", 0, "_UI_CreateModelError_message", new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());){
                result = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    private void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    private EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    private IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.dbc.dispose();
        super.dispose();
    }

    protected void createPages() {
        this.createModel();
        if (!this.editingDomain.getResourceSet().getResources().isEmpty()) {
            AntTask task = this.getTask();
            this.createPageOverview(task);
            this.createPageDeploy(task);
            this.createPageSigning(task);
        }
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                JFXBuildConfigurationEditor.this.setActivePage(0);
            }
        });
    }

    AntTask getTask() {
        AntTask task;
        try {
            task = (AntTask)((Resource)this.editingDomain.getResourceSet().getResources().get(0)).getContents().get(0);
        }
        catch (Exception e) {
            if (!this.properties.isEmpty()) {
                task = PropertiesToModelTransformer.transform(this.properties);
                ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).getContents().add(0, (Object)task);
                this.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            throw new UnsupportedOperationException("Could not read file");
        }
        return task;
    }

    private void createModel() {
        AntTasksPackage.eINSTANCE.eClass();
        ParametersPackage.eINSTANCE.eClass();
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = JFXBuildConfigurationEditor.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, diagnostic);
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
        try {
            IFileEditorInput i = (IFileEditorInput)editorInput;
            this.properties.load(i.getFile().getContents());
            this.setPartName(editorInput.getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void createPageOverview(final AntTask task) {
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.fx.ide.jdt.ui.JFXBuildConfigurationEditor_overview");
        this.bean.setValue((Object)task);
        this.toolkit = new FormToolkit(composite.getDisplay());
        Form form = this.toolkit.createForm(composite);
        form.setText("FX Build Configuration");
        form.setImage(this.getTitleImage());
        form.getBody().setLayout((Layout)new FillLayout());
        this.toolkit.decorateFormHeading(form);
        this.initToolbar(form);
        ScrolledForm scrolledForm = this.toolkit.createScrolledForm(form.getBody());
        scrolledForm.getBody().setLayout((Layout)new GridLayout(2, false));
        Composite sectionParent = scrolledForm.getBody();
        this.dbc = new DataBindingContext();
        IWidgetValueProperty textModify = WidgetProperties.text((int)24);
        IWidgetValueProperty selChange = WidgetProperties.selection();
        Section section = this.toolkit.createSection(sectionParent, 450);
        section.setText("Build && Package Properties");
        section.setDescription("The following properties are needed to build the JavaFX-Application");
        section.setLayoutData((Object)new GridData(768));
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new GridLayout(4, false));
        this.toolkit.createLabel(sectionClient, "Build Directory*:");
        final Text t = this.toolkit.createText(sectionClient, "", 2048);
        t.setLayoutData((Object)new GridData(768));
        this.toolkit.createButton(sectionClient, "Filesystem ...", 8).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir = JFXBuildConfigurationEditor.this.handleBuildFilesystemDirectorySelection(t.getShell());
                if (dir != null) {
                    t.setText(dir);
                }
            }
        });
        this.toolkit.createButton(sectionClient, "Workspace ...", 8).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir = JFXBuildConfigurationEditor.this.handleBuildWorkbenchDirectorySelection(t.getShell());
                if (dir != null) {
                    t.setText(dir);
                }
            }
        });
        IEMFEditValueProperty prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)AntTasksPackage.Literals.ANT_TASK__BUILD_DIRECTORY);
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop.observeDetail((IObservableValue)this.bean));
        this.toolkit.createLabel(sectionClient, "Vendor name*:");
        t = this.toolkit.createText(sectionClient, "", 2048);
        t.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__INFO, ParametersPackage.Literals.INFO__VENDOR}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop.observeDetail((IObservableValue)this.bean));
        this.toolkit.createLabel(sectionClient, "Application title*:");
        t = this.toolkit.createText(sectionClient, "", 2048);
        t.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__INFO, ParametersPackage.Literals.INFO__TITLE}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop.observeDetail((IObservableValue)this.bean));
        this.toolkit.createLabel(sectionClient, "Application version*:");
        t = this.toolkit.createText(sectionClient, "", 2048);
        t.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__APPLICATION, ParametersPackage.Literals.APPLICATION__VERSION}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop.observeDetail((IObservableValue)this.bean));
        this.toolkit.createLabel(sectionClient, "Application class*:");
        t = this.toolkit.createText(sectionClient, "", 2048);
        t.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Button b = this.toolkit.createButton(sectionClient, "Browse ...", 8);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = JFXBuildConfigurationEditor.this.handleRootclassSelection(t.getShell());
                if (name != null) {
                    t.setText(name);
                }
            }
        });
        b.setLayoutData((Object)new GridData(4, 2, false, false));
        IEMFEditValueProperty prop2 = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__APPLICATION, ParametersPackage.Literals.APPLICATION__MAINCLASS}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop2.observeDetail((IObservableValue)this.bean));
        this.toolkit.createLabel(sectionClient, "Preloader class:");
        t = this.toolkit.createText(sectionClient, "", 2048);
        t.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        b = this.toolkit.createButton(sectionClient, "Browse ...", 8);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = JFXBuildConfigurationEditor.this.handlePreloaderclassSelection(t.getShell());
                if (name != null) {
                    t.setText(name);
                }
            }
        });
        b.setLayoutData((Object)new GridData(4, 2, false, false));
        prop2 = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__APPLICATION, ParametersPackage.Literals.APPLICATION__PRELOADERCLASS}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop2.observeDetail((IObservableValue)this.bean));
        this.toolkit.createLabel(sectionClient, "Splash:");
        t = this.toolkit.createText(sectionClient, "", 2048);
        t.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        b = this.toolkit.createButton(sectionClient, "Browse ...", 8);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = JFXBuildConfigurationEditor.this.handleSplashImage(t.getShell());
                if (name != null) {
                    t.setText(name);
                }
            }
        });
        b.setLayoutData((Object)new GridData(4, 2, false, false));
        prop2 = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__SPLASH_IMAGE}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop2.observeDetail((IObservableValue)this.bean));
        this.toolkit.createLabel(sectionClient, "Manifest-Attributes:").setLayoutData((Object)new GridData(1, 1, false, false));
        Composite container = this.toolkit.createComposite(sectionClient);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginTop = 0;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginHeight = 0;
        gl.marginBottom = 0;
        container.setLayout((Layout)gl);
        GridData gdContainer = new GridData(768);
        gdContainer.horizontalSpan = 2;
        container.setLayoutData((Object)gdContainer);
        Composite tableContainer = this.toolkit.createComposite(container);
        Table t2 = this.toolkit.createTable(tableContainer, 68352);
        t2.setHeaderVisible(true);
        t2.setLinesVisible(true);
        GridData gdTable = new GridData(768);
        gdTable.heightHint = t2.getHeaderHeight() + t2.getItemHeight() * 5;
        tableContainer.setLayoutData((Object)gdTable);
        TableColumnLayout tablelayout = new TableColumnLayout();
        final TableViewer v = new TableViewer(t2);
        GridData gd = new GridData(768);
        gd.heightHint = t2.getHeaderHeight() + t2.getItemHeight() * 5;
        v.getControl().setLayoutData((Object)gd);
        v.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn c = new TableViewerColumn(v, 0);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Param)element).getName();
            }
        });
        tablelayout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)new ColumnWeightData(33));
        c.getColumn().setText("Name");
        c = new TableViewerColumn(v, 0);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Param)element).getValue();
            }
        });
        tablelayout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)new ColumnWeightData(67));
        c.getColumn().setText("Value");
        tableContainer.setLayout((Layout)tablelayout);
        v.setInput(task.getManifestEntries());
        Composite buttonComp = this.toolkit.createComposite(sectionClient);
        buttonComp.setLayoutData((Object)new GridData(1, 3, false, false));
        buttonComp.setLayout((Layout)new GridLayout());
        Button b2 = this.toolkit.createButton(buttonComp, "Add ...", 8);
        b2.setLayoutData((Object)new GridData(4, 1, false, false));
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JFXBuildConfigurationEditor.this.handleAddManifestAttr(JFXBuildConfigurationEditor.this.getSite().getShell())) {
                    v.setInput(task.getManifestEntries());
                    v.setSelection((ISelection)new StructuredSelection(task.getManifestEntries().get(task.getManifestEntries().size() - 1)));
                }
            }
        });
        b2 = this.toolkit.createButton(buttonComp, "Remove", 8);
        b2.setLayoutData((Object)new GridData(4, 1, false, false));
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Param value = (Param)((IStructuredSelection)v.getSelection()).getFirstElement();
                if (value != null) {
                    if (JFXBuildConfigurationEditor.this.handleRemoveManifestAttr(value)) {
                        v.setInput(task.getManifestEntries());
                    }
                } else {
                    MessageDialog.openWarning((Shell)JFXBuildConfigurationEditor.this.getSite().getShell(), (String)"Warning", (String)"Please select an entry");
                }
            }
        });
        this.toolkit.createLabel(sectionClient, "Toolkit Type:").setLayoutData((Object)new GridData(1, 1, false, false));
        ComboViewer c2 = new ComboViewer(sectionClient);
        c2.getCombo().setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        c2.setContentProvider((IContentProvider)new ArrayContentProvider());
        c2.setInput(ApplicationToolkitType.VALUES);
        IEMFEditValueProperty prop3 = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__APPLICATION, ParametersPackage.Literals.APPLICATION__TOOLKIT}));
        this.dbc.bindValue((IObservableValue)selChange.observe((Widget)c2.getCombo()), prop3.observeDetail((IObservableValue)this.bean));
        this.toolkit.createLabel(sectionClient, "Packaging Format:").setLayoutData((Object)new GridData(1, 1, false, false));
        c2 = new ComboViewer(sectionClient);
        c2.getCombo().setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        c2.setContentProvider((IContentProvider)new ArrayContentProvider());
        c2.setInput(PackagingFormat.VALUES);
        prop3 = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__PACKAGING_FORMAT}));
        this.dbc.bindValue((IObservableValue)selChange.observe((Widget)c2.getCombo()), prop3.observeDetail((IObservableValue)this.bean));
        b2 = this.toolkit.createButton(sectionClient, "automatic Proxy Resolution", 32);
        b2.setLayoutData((Object)new GridData(4, 2, true, false, 4, 1));
        prop3 = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__PROXY_RESOLUTION}));
        this.dbc.bindValue((IObservableValue)selChange.observe((Widget)b2), prop3.observeDetail((IObservableValue)this.bean));
        b2 = this.toolkit.createButton(sectionClient, "Convert CSS into binary form", 32);
        b2.setLayoutData((Object)new GridData(4, 2, true, false, 4, 1));
        prop3 = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__CSS_TO_BIN}));
        this.dbc.bindValue((IObservableValue)selChange.observe((Widget)b2), prop3.observeDetail((IObservableValue)this.bean));
        b2 = this.toolkit.createButton(sectionClient, "Enable verbose build mode (Not recommended)", 32);
        b2.setLayoutData((Object)new GridData(4, 2, true, false, 4, 1));
        prop3 = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__VERBOSE}));
        this.dbc.bindValue((IObservableValue)selChange.observe((Widget)b2), prop3.observeDetail((IObservableValue)this.bean));
        section.setClient((Control)sectionClient);
        section = this.toolkit.createSection(sectionParent, 450);
        section.setText("Building & Exporting");
        section.setLayoutData((Object)new GridData(4, 4, false, true, 1, 2));
        sectionClient = this.toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new GridLayout(1, false));
        FormText text = this.toolkit.createFormText(sectionClient, false);
        text.setText("<p>To generate build instructions and export the project: <li style=\"bullet\" bindent=\"1\">Generate <a href=\"generateAnt\">ant build.xml</a> only</li><li style=\"bullet\" bindent=\"2\">Generate <a href=\"generateAndRun\">ant build.xml and run</a></li>&#160;</p>", true, false);
        text.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                try {
                    if ("generateAndRun".equals(e.getHref())) {
                        JFXBuildConfigurationEditor.this.executeExport();
                    } else {
                        JFXBuildConfigurationEditor.this.executeGenerateAnt();
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        section.setClient((Control)sectionClient);
        int index = this.addPage((Control)composite);
        this.setPageText(index, "Overview");
    }

    private void createPageDeploy(final AntTask task) {
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.fx.ide.jdt.ui.JFXBuildConfigurationEditor_deploy");
        WritableValue bean = new WritableValue();
        bean.setValue((Object)task);
        this.toolkit = new FormToolkit(composite.getDisplay());
        Form form = this.toolkit.createForm(composite);
        form.setText("FX Build Configuration");
        form.setImage(this.getTitleImage());
        form.getBody().setLayout((Layout)new FillLayout());
        this.toolkit.decorateFormHeading(form);
        this.initToolbar(form);
        ScrolledForm scrolledForm = this.toolkit.createScrolledForm(form.getBody());
        scrolledForm.getBody().setLayout((Layout)new GridLayout(2, false));
        Composite sectionParent = scrolledForm.getBody();
        IWidgetValueProperty textModify = WidgetProperties.text((int)24);
        IWidgetValueProperty selChange = WidgetProperties.selection();
        Section section = this.toolkit.createSection(sectionParent, 450);
        section.setText("Deploy Properties");
        section.setDescription("The following properties are needed to create a Java Webstart Deployment");
        section.setLayoutData((Object)new GridData(768));
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        int COLUMN_COUNT = 3;
        sectionClient.setLayout((Layout)new GridLayout(3, false));
        this.toolkit.createLabel(sectionClient, "Applet Width*:");
        Text t = this.toolkit.createText(sectionClient, "", 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        IEMFEditValueProperty prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__WIDTH}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop.observeDetail((IObservableValue)bean));
        this.toolkit.createLabel(sectionClient, "Applet Height*:");
        t = this.toolkit.createText(sectionClient, "", 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__HEIGHT}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop.observeDetail((IObservableValue)bean));
        Button b = this.toolkit.createButton(sectionClient, "Embed JNLP", 32);
        b.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        IEMFEditValueProperty prop2 = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__EMBEDJNLP}));
        this.dbc.bindValue((IObservableValue)selChange.observe((Widget)b), prop2.observeDetail((IObservableValue)bean));
        b = this.toolkit.createButton(sectionClient, "Treat files as extensions", 32);
        b.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        prop2 = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__EXTENSION}));
        this.dbc.bindValue((IObservableValue)selChange.observe((Widget)b), prop2.observeDetail((IObservableValue)bean));
        b = this.toolkit.createButton(sectionClient, "Include deployment toolkit", 32);
        b.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        prop2 = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__INCLUDE_DT}));
        this.dbc.bindValue((IObservableValue)selChange.observe((Widget)b), prop2.observeDetail((IObservableValue)bean));
        b = this.toolkit.createButton(sectionClient, "Offline allowed", 32);
        b.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        prop2 = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__OFFLINE_ALLOWED}));
        this.dbc.bindValue((IObservableValue)selChange.observe((Widget)b), prop2.observeDetail((IObservableValue)bean));
        this.toolkit.createLabel(sectionClient, "Placeholder Ref.*:");
        t = this.toolkit.createText(sectionClient, "", 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__PLACEHOLDERREF}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop.observeDetail((IObservableValue)bean));
        this.toolkit.createLabel(sectionClient, "Placeholder ID*:");
        t = this.toolkit.createText(sectionClient, "", 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__PLACEHOLDERID}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop.observeDetail((IObservableValue)bean));
        this.toolkit.createLabel(sectionClient, "HTML Template:");
        t = this.toolkit.createText(sectionClient, "", 2048);
        t.setLayoutData((Object)new GridData(768));
        prop2 = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__TEMPLATE, ParametersPackage.Literals.TEMPLATE__FILE}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop2.observeDetail((IObservableValue)bean));
        Button b2 = this.toolkit.createButton(sectionClient, "Workspace ...", 0);
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] rv;
                FilteredResourcesSelectionDialog d = new FilteredResourcesSelectionDialog(JFXBuildConfigurationEditor.this.getSite().getShell(), false, (IContainer)((IFileEditorInput)JFXBuildConfigurationEditor.this.getEditorInput()).getFile().getProject(), 1){

                    protected IStatus validateItem(Object item) {
                        IFile f = (IFile)item;
                        if (f.getParent() instanceof IProject) {
                            return new Status(4, "org.eclipse.fx.ide.jdt.ui", "The selected resource has to be part of the source folder");
                        }
                        if (!f.getName().endsWith(".fxtemplate")) {
                            return new Status(4, "org.eclipse.fx.ide.jdt.ui", "The selected resource does not seem to be a html file");
                        }
                        return super.validateItem(item);
                    }
                };
                if (d.open() == 0 && (rv = d.getResult()).length == 1) {
                    IPackageFragment p;
                    IFile f = (IFile)rv[0];
                    IJavaElement j = JavaCore.create((IResource)f.getParent());
                    String template = null;
                    if (j instanceof IPackageFragment) {
                        p = (IPackageFragment)j;
                        template = String.valueOf(p.getElementName().replace('.', '/')) + "/" + f.getName();
                    } else if (j instanceof IPackageFragmentRoot) {
                        p = (IPackageFragmentRoot)j;
                        template = f.getName();
                    } else {
                        MessageDialog.openInformation((Shell)JFXBuildConfigurationEditor.this.getSite().getShell(), (String)"Not valid", (String)"The selected resource has to be part of the source folder");
                    }
                    if (template != null) {
                        SetCommand cmd;
                        if (JFXBuildConfigurationEditor.this.getTask().getDeploy().getTemplate() == null && (cmd = new SetCommand((EditingDomain)JFXBuildConfigurationEditor.this.editingDomain, (EObject)JFXBuildConfigurationEditor.this.getTask().getDeploy(), (EStructuralFeature)AntTasksPackage.Literals.DEPLOY__TEMPLATE, (Object)ParametersFactory.eINSTANCE.createTemplate())).canExecute()) {
                            cmd.execute();
                        }
                        if ((cmd = new SetCommand((EditingDomain)JFXBuildConfigurationEditor.this.editingDomain, (EObject)JFXBuildConfigurationEditor.this.getTask().getDeploy().getTemplate(), (EStructuralFeature)ParametersPackage.Literals.TEMPLATE__FILE, (Object)template)).canExecute()) {
                            cmd.execute();
                        }
                    }
                }
            }
        });
        this.toolkit.createLabel(sectionClient, "Template Output File:");
        t = this.toolkit.createText(sectionClient, "", 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__DEPLOY, AntTasksPackage.Literals.DEPLOY__TEMPLATE, ParametersPackage.Literals.TEMPLATE__TO_FILE}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop.observeDetail((IObservableValue)bean));
        this.toolkit.createLabel(sectionClient, "Webstart Splash:").setLayoutData((Object)new GridData(1, 1, false, false));
        Composite container = this.toolkit.createComposite(sectionClient);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginTop = 0;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginHeight = 0;
        gl.marginBottom = 0;
        container.setLayout((Layout)gl);
        GridData gdContainer = new GridData(768);
        gdContainer.horizontalSpan = 2;
        container.setLayoutData((Object)gdContainer);
        Composite tableContainer = this.toolkit.createComposite(container);
        Table t2 = this.toolkit.createTable(tableContainer, 68352);
        t2.setHeaderVisible(true);
        t2.setLinesVisible(true);
        GridData gdTable = new GridData(768);
        gdTable.heightHint = t2.getItemHeight() * 5;
        tableContainer.setLayoutData((Object)gdTable);
        TableColumnLayout tablelayout = new TableColumnLayout();
        final TableViewer v = new TableViewer(t2);
        GridData gd2 = new GridData(768);
        gd2.heightHint = t2.getItemHeight() * 5;
        v.getControl().setLayoutData((Object)gd2);
        v.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn c = new TableViewerColumn(v, 0);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Splash)element).getMode().getName();
            }
        });
        tablelayout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 100, false));
        c.getColumn().setText("Mode");
        c = new TableViewerColumn(v, 0);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Splash)element).getHref();
            }
        });
        tablelayout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)new ColumnWeightData(90));
        c.getColumn().setText("URL");
        tableContainer.setLayout((Layout)tablelayout);
        v.setInput(task.getDeploy().getInfo().getSplash());
        Composite buttonComp = this.toolkit.createComposite(container);
        buttonComp.setLayoutData((Object)new GridData(1, 3, false, false));
        buttonComp.setLayout((Layout)new GridLayout());
        Button b3 = this.toolkit.createButton(buttonComp, "Add ...", 8);
        b3.setLayoutData((Object)new GridData(4, 1, false, false));
        b3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JFXBuildConfigurationEditor.this.handleAddSplash()) {
                    v.setInput(task.getDeploy().getInfo().getSplash());
                    v.setSelection((ISelection)new StructuredSelection(task.getDeploy().getInfo().getSplash().get(task.getDeploy().getInfo().getSplash().size() - 1)));
                }
            }
        });
        b3 = this.toolkit.createButton(buttonComp, "Remove", 8);
        b3.setLayoutData((Object)new GridData(4, 1, false, false));
        b3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Splash value = (Splash)((IStructuredSelection)v.getSelection()).getFirstElement();
                if (value != null) {
                    if (JFXBuildConfigurationEditor.this.handleRemoveSplash(value)) {
                        v.setInput(JFXBuildConfigurationEditor.this.getTask().getDeploy().getInfo().getSplash());
                    }
                } else {
                    MessageDialog.openWarning((Shell)JFXBuildConfigurationEditor.this.getSite().getShell(), (String)"Warning", (String)"Please select an entry");
                }
            }
        });
        this.toolkit.createLabel(sectionClient, "Webstart Icons:").setLayoutData((Object)new GridData(1, 1, false, false));
        container = this.toolkit.createComposite(sectionClient);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginTop = 0;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginHeight = 0;
        gl.marginBottom = 0;
        container.setLayout((Layout)gl);
        gdContainer = new GridData(768);
        gdContainer.horizontalSpan = 2;
        container.setLayoutData((Object)gdContainer);
        tableContainer = this.toolkit.createComposite(container);
        t2 = this.toolkit.createTable(tableContainer, 68352);
        t2.setHeaderVisible(true);
        t2.setLinesVisible(true);
        gdTable = new GridData(768);
        gdTable.heightHint = t2.getItemHeight() * 5;
        tableContainer.setLayoutData((Object)gdTable);
        tablelayout = new TableColumnLayout();
        v = new TableViewer(t2);
        gd2 = new GridData(768);
        gd2.heightHint = t2.getItemHeight() * 5;
        v.getControl().setLayoutData((Object)gd2);
        v.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        c = new TableViewerColumn(v, 0);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Icon)element).getDepth();
            }
        });
        tablelayout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 50, false));
        c.getColumn().setText("Depth");
        c = new TableViewerColumn(v, 0);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Icon)element).getKind().getName();
            }
        });
        tablelayout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 100, false));
        c.getColumn().setText("Kind");
        c = new TableViewerColumn(v, 0);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Icon)element).getWidth();
            }
        });
        tablelayout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 50, false));
        c.getColumn().setText("Width");
        c = new TableViewerColumn(v, 0);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Icon)element).getHeight();
            }
        });
        tablelayout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 50, false));
        c.getColumn().setText("Height");
        c = new TableViewerColumn(v, 0);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Icon)element).getHref();
            }
        });
        tablelayout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)new ColumnWeightData(60));
        c.getColumn().setText("Url");
        tableContainer.setLayout((Layout)tablelayout);
        v.setInput(task.getDeploy().getInfo().getIcon());
        buttonComp = this.toolkit.createComposite(container);
        buttonComp.setLayoutData((Object)new GridData(1, 3, false, false));
        buttonComp.setLayout((Layout)new GridLayout());
        b3 = this.toolkit.createButton(buttonComp, "Add ...", 8);
        b3.setLayoutData((Object)new GridData(4, 1, false, false));
        b3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JFXBuildConfigurationEditor.this.handleAddIcon()) {
                    v.setInput(task.getDeploy().getInfo().getIcon());
                    v.setSelection((ISelection)new StructuredSelection(task.getDeploy().getInfo().getIcon().get(task.getDeploy().getInfo().getIcon().size() - 1)));
                }
            }
        });
        b3 = this.toolkit.createButton(buttonComp, "Remove", 8);
        b3.setLayoutData((Object)new GridData(4, 1, false, false));
        b3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Icon value = (Icon)((IStructuredSelection)v.getSelection()).getFirstElement();
                if (value != null) {
                    if (JFXBuildConfigurationEditor.this.handleRemoveIcon(value)) {
                        v.setInput(task.getDeploy().getInfo().getIcon());
                    }
                } else {
                    MessageDialog.openWarning((Shell)JFXBuildConfigurationEditor.this.getSite().getShell(), (String)"Warning", (String)"Please select an entry");
                }
            }
        });
        this.toolkit.createLabel(sectionClient, "Additional META-INF files:").setLayoutData((Object)new GridData(1, 1, false, false));
        container = this.toolkit.createComposite(sectionClient);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginTop = 0;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginHeight = 0;
        gl.marginBottom = 0;
        container.setLayout((Layout)gl);
        gdContainer = new GridData(768);
        gdContainer.horizontalSpan = 2;
        container.setLayoutData((Object)gdContainer);
        tableContainer = this.toolkit.createComposite(container);
        t2 = this.toolkit.createTable(tableContainer, 68352);
        t2.setHeaderVisible(true);
        t2.setLinesVisible(true);
        gdTable = new GridData(768);
        gdTable.heightHint = t2.getItemHeight() * 5;
        tableContainer.setLayoutData((Object)gdTable);
        tablelayout = new TableColumnLayout();
        v = new TableViewer(t2);
        gd2 = new GridData(768);
        gd2.heightHint = t2.getItemHeight() * 5;
        v.getControl().setLayoutData((Object)gd2);
        v.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        c = new TableViewerColumn(v, 0);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((KeyValuePair)element).getKey();
            }
        });
        tablelayout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)new ColumnWeightData(33));
        c.getColumn().setText("Folder");
        c = new TableViewerColumn(v, 0);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((KeyValuePair)element).getValue();
            }
        });
        tablelayout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)new ColumnWeightData(67));
        c.getColumn().setText("File");
        tableContainer.setLayout((Layout)tablelayout);
        v.setInput(task.getFiles());
        buttonComp = this.toolkit.createComposite(container);
        buttonComp.setLayoutData((Object)new GridData(1, 3, false, false));
        buttonComp.setLayout((Layout)new GridLayout());
        b3 = this.toolkit.createButton(buttonComp, "Add ...", 8);
        b3.setLayoutData((Object)new GridData(4, 1, false, false));
        b3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JFXBuildConfigurationEditor.this.handleAddMetaInfFile()) {
                    v.setInput(task.getFiles());
                    v.setSelection((ISelection)new StructuredSelection(task.getFiles().get(task.getFiles().size() - 1)));
                }
            }
        });
        b3 = this.toolkit.createButton(buttonComp, "Remove", 8);
        b3.setLayoutData((Object)new GridData(4, 1, false, false));
        b3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyValuePair value = (KeyValuePair)((IStructuredSelection)v.getSelection()).getFirstElement();
                if (value != null) {
                    if (JFXBuildConfigurationEditor.this.handleRemoveMetaInfFile(value)) {
                        v.setInput(task.getFiles());
                    }
                } else {
                    MessageDialog.openWarning((Shell)JFXBuildConfigurationEditor.this.getSite().getShell(), (String)"Warning", (String)"Please select an entry");
                }
            }
        });
        this.toolkit.createLabel(sectionClient, "Fonts:").setLayoutData((Object)new GridData(1, 1, false, false));
        container = this.toolkit.createComposite(sectionClient);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginTop = 0;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginHeight = 0;
        gl.marginBottom = 0;
        container.setLayout((Layout)gl);
        gdContainer = new GridData(768);
        gdContainer.horizontalSpan = 2;
        container.setLayoutData((Object)gdContainer);
        tableContainer = this.toolkit.createComposite(container);
        t2 = this.toolkit.createTable(tableContainer, 68352);
        t2.setHeaderVisible(true);
        t2.setLinesVisible(true);
        gdTable = new GridData(768);
        gdTable.heightHint = t2.getItemHeight() * 5;
        tableContainer.setLayoutData((Object)gdTable);
        tablelayout = new TableColumnLayout();
        v = new TableViewer(t2);
        gd2 = new GridData(768);
        gd2.heightHint = t2.getItemHeight() * 5;
        v.getControl().setLayoutData((Object)gd2);
        ArrayContentProvider cp = new ArrayContentProvider();
        v.setContentProvider((IContentProvider)cp);
        IEMFEditValueProperty prop3 = EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ParametersPackage.Literals.KEY_VALUE_PAIR__KEY);
        TableViewerColumn c2 = new TableViewerColumn(v, 0);
        TableColumn tc = c2.getColumn();
        tc.setText("Font name");
        c2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((KeyValuePair)element).getKey();
            }
        });
        tablelayout.setColumnData((Widget)c2.getColumn(), (ColumnLayoutData)new ColumnWeightData(33));
        prop3 = EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ParametersPackage.Literals.KEY_VALUE_PAIR__VALUE);
        c2 = new TableViewerColumn(v, 0);
        tc = c2.getColumn();
        tc.setText("File");
        c2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((KeyValuePair)element).getValue();
            }
        });
        tablelayout.setColumnData((Widget)c2.getColumn(), (ColumnLayoutData)new ColumnWeightData(67));
        tableContainer.setLayout((Layout)tablelayout);
        v.setInput(task.getFonts());
        Composite buttonComp2 = this.toolkit.createComposite(container);
        buttonComp2.setLayoutData((Object)new GridData(1, 3, false, false));
        buttonComp2.setLayout((Layout)new GridLayout());
        Button b4 = this.toolkit.createButton(buttonComp2, "Add ...", 8);
        b4.setLayoutData((Object)new GridData(4, 1, false, false));
        b4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JFXBuildConfigurationEditor.this.handleAddFont()) {
                    KeyValuePair newFont = (KeyValuePair)task.getFonts().get(task.getFonts().size() - 1);
                    v.refresh();
                    v.setSelection((ISelection)new StructuredSelection((Object)newFont));
                }
            }
        });
        b4 = this.toolkit.createButton(buttonComp2, "Remove", 8);
        b4.setLayoutData((Object)new GridData(4, 1, false, false));
        b4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyValuePair value = (KeyValuePair)((IStructuredSelection)v.getSelection()).getFirstElement();
                if (value != null) {
                    if (JFXBuildConfigurationEditor.this.handleRemoveFont(value)) {
                        v.setInput(task.getFonts());
                    }
                } else {
                    MessageDialog.openWarning((Shell)JFXBuildConfigurationEditor.this.getSite().getShell(), (String)"Warning", (String)"Please select an entry");
                }
            }
        });
        section.setClient((Control)sectionClient);
        int index = this.addPage((Control)composite);
        this.setPageText(index, "Deploy");
    }

    private void initToolbar(Form form) {
        IToolBarManager mgr = form.getToolBarManager();
        mgr.add((IAction)new Action("Build & Export FX Application", ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getClassLoader().getResource("/icons/exportrunnablejar_wiz.gif"))){

            public void run() {
                try {
                    JFXBuildConfigurationEditor.this.executeExport();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        form.updateToolBar();
    }

    boolean handleRemoveMetaInfFile(KeyValuePair value) {
        RemoveCommand cmd;
        if (MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"Confirm delete", (String)"Would really like to remove the selected META-INF file") && (cmd = new RemoveCommand((EditingDomain)this.editingDomain, this.getTask().getFiles(), (Object)value)).canExecute()) {
            cmd.execute();
            return true;
        }
        return false;
    }

    private boolean handleRemoveFont(KeyValuePair value) {
        RemoveCommand cmd;
        if (MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"Confirm delete", (String)"Would really like to remove the selected font") && (cmd = new RemoveCommand((EditingDomain)this.editingDomain, this.getTask().getFonts(), (Object)value)).canExecute()) {
            cmd.execute();
            return true;
        }
        return false;
    }

    boolean handleAddMetaInfFile() {
        AddMetaInfFileDialog d = new AddMetaInfFileDialog(this.getSite().getShell(), (EditingDomain)this.editingDomain, this.getTask(), (IContainer)((IFileEditorInput)this.getEditorInput()).getFile().getProject().getWorkspace().getRoot());
        return d.open() == 0;
    }

    private boolean handleAddFont() {
        AddFontDialog d = new AddFontDialog(this.getSite().getShell(), (EditingDomain)this.editingDomain, this.getTask(), (IContainer)((IFileEditorInput)this.getEditorInput()).getFile().getProject());
        return d.open() == 0;
    }

    private void createPageSigning(AntTask task) {
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.fx.ide.jdt.ui.JFXBuildConfigurationEditor_signing");
        WritableValue bean = new WritableValue();
        bean.setValue((Object)task);
        this.toolkit = new FormToolkit(composite.getDisplay());
        Form form = this.toolkit.createForm(composite);
        form.setText("FX Build Configuration");
        form.setImage(this.getTitleImage());
        form.getBody().setLayout((Layout)new FillLayout());
        this.toolkit.decorateFormHeading(form);
        this.initToolbar(form);
        ScrolledForm scrolledForm = this.toolkit.createScrolledForm(form.getBody());
        scrolledForm.getBody().setLayout((Layout)new GridLayout(2, false));
        Composite sectionParent = scrolledForm.getBody();
        IWidgetValueProperty textModify = WidgetProperties.text((int)24);
        Section section = this.toolkit.createSection(sectionParent, 450);
        section.setText("Signing Properties");
        section.setDescription("Information for signing result jar");
        section.setLayoutData((Object)new GridData(768));
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new GridLayout(4, false));
        this.toolkit.createLabel(sectionClient, "Alias*:");
        final Text t = this.toolkit.createText(sectionClient, "", 2048);
        t.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        IEMFEditValueProperty prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__SIGNJAR, AntTasksPackage.Literals.SIGN_JAR__ALIAS}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop.observeDetail((IObservableValue)bean));
        this.toolkit.createLabel(sectionClient, "Key-Password*:");
        t = this.toolkit.createText(sectionClient, "", 2048);
        t.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__SIGNJAR, AntTasksPackage.Literals.SIGN_JAR__KEYPASS}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop.observeDetail((IObservableValue)bean));
        this.toolkit.createLabel(sectionClient, "Keystore*:");
        t = this.toolkit.createText(sectionClient, "", 2048);
        t.setLayoutData((Object)new GridData(768));
        this.toolkit.createButton(sectionClient, "Filesystem ...", 8).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String v = JFXBuildConfigurationEditor.this.handleKeyStoreFilesystemSelection(t.getShell());
                if (v != null) {
                    t.setText(v);
                }
            }
        });
        this.toolkit.createButton(sectionClient, "Workspace ...", 8).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String v = JFXBuildConfigurationEditor.this.handleKeyStoreWorkspaceSelection(t.getShell());
                if (v != null) {
                    t.setText(v);
                }
            }
        });
        prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__SIGNJAR, AntTasksPackage.Literals.SIGN_JAR__KEYSTORE}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop.observeDetail((IObservableValue)bean));
        this.toolkit.createLabel(sectionClient, "Store-Password*:");
        t = this.toolkit.createText(sectionClient, "", 2048);
        t.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__SIGNJAR, AntTasksPackage.Literals.SIGN_JAR__STOREPASS}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop.observeDetail((IObservableValue)bean));
        this.toolkit.createLabel(sectionClient, "Storetype:");
        t = this.toolkit.createText(sectionClient, "", 2048);
        t.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AntTasksPackage.Literals.ANT_TASK__SIGNJAR, AntTasksPackage.Literals.SIGN_JAR__STORETYPE}));
        this.dbc.bindValue((IObservableValue)textModify.observeDelayed(500, (Widget)t), prop.observeDetail((IObservableValue)bean));
        section.setClient((Control)sectionClient);
        int index = this.addPage((Control)composite);
        this.setPageText(index, "Signing");
    }

    boolean handleRemoveManifestAttr(Param value) {
        RemoveCommand cmd;
        if (MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"Confirm delete", (String)"Would really like to remove the selected attribute") && (cmd = new RemoveCommand((EditingDomain)this.editingDomain, this.getTask().getManifestEntries(), (Object)value)).canExecute()) {
            cmd.execute();
            return true;
        }
        return false;
    }

    boolean handleAddManifestAttr(Shell shell) {
        AddManifestAttributeDialog d = new AddManifestAttributeDialog(this.getSite().getShell(), (EditingDomain)this.editingDomain, this.getTask());
        return d.open() == 0;
    }

    String handleSplashImage(Shell shell) {
        Object[] rv;
        FilteredResourcesSelectionDialog d = new FilteredResourcesSelectionDialog(shell, false, (IContainer)((IFileEditorInput)this.getEditorInput()).getFile().getProject(), 1){

            protected IStatus validateItem(Object item) {
                IFile f = (IFile)item;
                if (f.getParent() instanceof IProject) {
                    return new Status(4, "org.eclipse.fx.ide.jdt.ui", "The selected resource has to part of the source folder");
                }
                return super.validateItem(item);
            }
        };
        if (d.open() == 0 && (rv = d.getResult()).length == 1) {
            IFile f = (IFile)rv[0];
            IJavaElement j = JavaCore.create((IResource)f.getParent());
            if (j instanceof IPackageFragment) {
                IPackageFragment p = (IPackageFragment)j;
                return String.valueOf(p.getElementName().replace('.', '/')) + "/" + f.getName();
            }
            if (j instanceof IPackageFragmentRoot) {
                return f.getName();
            }
            MessageDialog.openInformation((Shell)shell, (String)"Not valid", (String)"The selected resource has to part of the source folder");
        }
        return null;
    }

    boolean handleRemoveIcon(Icon value) {
        RemoveCommand cmd;
        if (MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"Confirm delete", (String)"Would really like to remove the selected icon") && (cmd = new RemoveCommand((EditingDomain)this.editingDomain, this.getTask().getDeploy().getInfo().getIcon(), (Object)value)).canExecute()) {
            cmd.execute();
            return true;
        }
        return false;
    }

    boolean handleAddIcon() {
        AddIconDialog d = new AddIconDialog(this.getSite().getShell(), (EditingDomain)this.editingDomain, this.getTask());
        return d.open() == 0;
    }

    boolean handleAddSplash() {
        AddSplashDialog d = new AddSplashDialog(this.getSite().getShell(), (EditingDomain)this.editingDomain, this.getTask());
        return d.open() == 0;
    }

    boolean handleRemoveSplash(Splash value) {
        RemoveCommand cmd;
        if (MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"Confirm delete", (String)"Would really like to remove the selected splash") && (cmd = new RemoveCommand((EditingDomain)this.editingDomain, this.getTask().getDeploy().getInfo().getSplash(), (Object)value)).canExecute()) {
            cmd.execute();
            return true;
        }
        return false;
    }

    String handleBuildFilesystemDirectorySelection(Shell parent) {
        DirectoryDialog dialog = new DirectoryDialog(parent);
        return dialog.open();
    }

    String handleBuildWorkbenchDirectorySelection(Shell parent) {
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses);
        FolderSelectionDialog dialog = new FolderSelectionDialog(parent, (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle("Output directory");
        dialog.setMessage("Select output directory");
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            IContainer c = (IContainer)dialog.getFirstResult();
            if (c.getProject() == ((IFileEditorInput)this.getEditorInput()).getFile().getProject()) {
                return "${project}/" + c.getProjectRelativePath().toString();
            }
            return "${workspace}/" + c.getProject().getName() + "/" + c.getProjectRelativePath().toString();
        }
        return null;
    }

    String handleRootclassSelection(Shell parent) {
        IFileEditorInput i = (IFileEditorInput)this.getEditorInput();
        IJavaProject project = JavaCore.create((IProject)i.getFile().getProject());
        if (project == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{project};
        int constraints = 1;
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)(constraints |= 2));
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        MainTypeSelectionDialog dialog = new MainTypeSelectionDialog(parent, (IRunnableContext)context, searchScope, 0);
        dialog.setTitle("Find class");
        dialog.setMessage("Find the class used to launch the application");
        if (dialog.open() == 1) {
            return null;
        }
        Object[] results = dialog.getResult();
        IType type = (IType)results[0];
        if (type != null) {
            return type.getFullyQualifiedName();
        }
        return null;
    }

    String handlePreloaderclassSelection(Shell parent) {
        IFileEditorInput i = (IFileEditorInput)this.getEditorInput();
        IJavaProject project = JavaCore.create((IProject)i.getFile().getProject());
        if (project == null) {
            return null;
        }
        try {
            IType superType = project.findType("javafx.application.Preloader");
            IJavaSearchScope searchScope = SearchEngine.createStrictHierarchyScope((IJavaProject)project, (IType)superType, (boolean)true, (boolean)false, null);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)parent, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)searchScope, (int)2, (boolean)false, (String)"");
            dialog.setTitle("Find Preloader");
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getResult()[0];
                return type.getFullyQualifiedName('$');
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String handleKeyStoreFilesystemSelection(Shell parent) {
        FileDialog dialog = new FileDialog(parent, 4096);
        String keystore = dialog.open();
        if (keystore != null) {
            IStatus s = this.validateKeyStore(new File(keystore));
            if (s.isOK()) {
                return keystore;
            }
            MessageDialog.openError((Shell)parent, (String)"Not a keystore", (String)"Looks like the selected file is not a keystore");
            return this.handleKeyStoreFilesystemSelection(parent);
        }
        return null;
    }

    private String handleKeyStoreWorkspaceSelection(Shell parent) {
        IFile f;
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent, (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length > 1) {
                    return new Status(4, "org.eclipse.fx.ide.jdt.ui", "Only one file allowed.");
                }
                if (selection.length == 1 && selection[0] instanceof IFile) {
                    IFile f = (IFile)selection[0];
                    return JFXBuildConfigurationEditor.this.validateKeyStore(f.getLocation().toFile());
                }
                return Status.OK_STATUS;
            }
        });
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0 && (f = (IFile)dialog.getFirstResult()) != null) {
            if (f.getProject() == ((IFileEditorInput)this.getEditorInput()).getFile().getProject()) {
                return "${project}/" + f.getProjectRelativePath().toString();
            }
            return "${workspace}/" + f.getProject().getName() + "/" + f.getProjectRelativePath().toString();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private IStatus validateKeyStore(File f) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void pageChange(int newPageIndex) {
        this.dbc.updateTargets();
    }

    private void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, "Selection");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    void executeExport() throws Exception {
        if (this.validateAndShowErrors()) {
            IHandlerService hs = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            hs.executeCommand("org.eclipse.fx.ide.jdt.ui.export", null);
        }
    }

    void executeGenerateAnt() throws Exception {
        if (this.validateAndShowErrors()) {
            IHandlerService hs = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            hs.executeCommand("org.eclipse.fx.ide.jdt.ui.generateAnt", null);
        }
    }

    private boolean validateAndShowErrors() {
        MultiStatus status = new MultiStatus("org.eclipse.fx.ide.jdt.ui", 0, null, null);
        if (this.isDirty()) {
            boolean option = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Save FX Build Configuration", (String)(String.valueOf(this.getEditorInput().getName()) + " must be saved before generating ant build.xml file.\nSave changes now?"));
            if (option) {
                this.doSave((IProgressMonitor)new NullProgressMonitor());
            } else {
                return false;
            }
        }
        if (this.getTask().getDeploy().getHeight() != null && this.getTask().getDeploy().getHeight().length() > 0) {
            try {
                Integer.parseInt(this.getTask().getDeploy().getHeight());
            }
            catch (Exception e) {
                status.add((IStatus)new Status(4, "org.eclipse.fx.ide.jdt.ui", "Height must be an integer value"));
            }
        }
        if (this.getTask().getDeploy().getWidth() != null && this.getTask().getDeploy().getWidth().length() > 0) {
            try {
                Integer.parseInt(this.getTask().getDeploy().getWidth());
            }
            catch (Exception e) {
                status.add((IStatus)new Status(4, "org.eclipse.fx.ide.jdt.ui", "Width must be an integer value"));
            }
        }
        if (!status.isOK()) {
            StringBuffer errors = new StringBuffer();
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus err = iStatusArray[n2];
                errors.append(err.getMessage()).append("\n");
                ++n2;
            }
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"Invalid FX Build configuration", (String)errors.toString());
        }
        return status.isOK();
    }
}

