/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.fx.core.URLStreamHandler;
import org.eclipse.fx.core.Util;
import org.eclipse.jdt.annotation.NonNull;

public class ExtensibleURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private final Map<String, URLStreamHandler> handlerMap = Util.lookupServiceList(URLStreamHandler.class).stream().collect(Collectors.toMap(h -> h.getProtocol(), h -> h));

    private ExtensibleURLStreamHandlerFactory() {
    }

    @Override
    public java.net.URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler h = this.handlerMap.get(protocol);
        if (h != null) {
            return new URLStreamHandlerImpl(h);
        }
        return null;
    }

    public static void setup() {
        URL.setURLStreamHandlerFactory(new ExtensibleURLStreamHandlerFactory());
    }

    static class URLConnectionImpl
    extends URLConnection {
        private final URLStreamHandler h;

        protected URLConnectionImpl(@NonNull URL url, @NonNull URLStreamHandler h) {
            super(url);
            this.h = h;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.h.createStream(this.getURL());
        }
    }

    static class URLStreamHandlerImpl
    extends java.net.URLStreamHandler {
        final @NonNull URLStreamHandler h;

        public URLStreamHandlerImpl(@NonNull URLStreamHandler h) {
            this.h = h;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            if (u == null) {
                throw new IllegalStateException("The url must not be null");
            }
            return new URLConnectionImpl(u, this.h);
        }
    }
}

