/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.scene.control.Control;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.fx.ui.controls.styledtext.ActionEvent;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.StyledTextLayoutContainer;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.fx.ui.controls.styledtext.VerifyEvent;
import org.eclipse.fx.ui.controls.styledtext.skin.StyledTextSkin;

public class StyledTextBehavior
extends BehaviorBase<StyledTextArea> {
    private static final List<KeyBinding> KEY_BINDINGS = new ArrayList<KeyBinding>();

    static {
        KEY_BINDINGS.add(new KeyBinding(null, KeyEvent.KEY_PRESSED, "Consume"));
    }

    public StyledTextBehavior(StyledTextArea styledText) {
        super((Control)styledText, KEY_BINDINGS);
    }

    protected void callActionForEvent(KeyEvent arg0) {
        if (arg0.getEventType() == KeyEvent.KEY_PRESSED) {
            this._keyPressed(arg0);
        } else if (arg0.getEventType() == KeyEvent.KEY_TYPED) {
            this._keyTyped(arg0);
        }
        super.callActionForEvent(arg0);
    }

    protected void callAction(String arg0) {
        super.callAction(arg0);
    }

    public void mousePressed(MouseEvent arg0) {
        super.mousePressed(arg0);
        ((StyledTextArea)this.getControl()).requestFocus();
    }

    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
    }

    public boolean invokeAction(ActionEvent.ActionType action) {
        ActionEvent evt = new ActionEvent(this.getControl(), (EventTarget)this.getControl(), action);
        Event.fireEvent((EventTarget)this.getControl(), (Event)evt);
        return evt.isConsumed();
    }

    private void _keyPressed(KeyEvent event) {
        VerifyEvent evt = new VerifyEvent(this.getControl(), (EventTarget)this.getControl(), event);
        Event.fireEvent((EventTarget)this.getControl(), (Event)evt);
        if (evt.isConsumed()) {
            event.consume();
            return;
        }
        int currentRowIndex = ((StyledTextArea)this.getControl()).getContent().getLineAtOffset(((StyledTextArea)this.getControl()).getCaretOffset());
        int offset = ((StyledTextArea)this.getControl()).getCaretOffset();
        switch (event.getCode()) {
            case SHIFT: 
            case CONTROL: 
            case ALT: {
                break;
            }
            case LEFT: {
                if (event.isAltDown()) {
                    this.invokeAction(ActionEvent.ActionType.WORD_PREVIOUS);
                    break;
                }
                if (offset == 0) {
                    event.consume();
                    break;
                }
                int newOffset = offset - 1;
                ((StyledTextArea)this.getControl()).getContent().getLineAtOffset(offset);
                ((StyledTextArea)this.getControl()).getContent().getLineAtOffset(newOffset);
                ((StyledTextArea)this.getControl()).impl_setCaretOffset(newOffset, event.isShiftDown());
                event.consume();
                break;
            }
            case RIGHT: {
                if (event.isAltDown()) {
                    this.invokeAction(ActionEvent.ActionType.WORD_NEXT);
                    break;
                }
                if (event.isMetaDown()) {
                    int currentLine = ((StyledTextArea)this.getControl()).getContent().getLineAtOffset(offset);
                    int lineOffset = ((StyledTextArea)this.getControl()).getContent().getOffsetAtLine(currentLine);
                    String lineContent = ((StyledTextArea)this.getControl()).getContent().getLine(currentLine);
                    ((StyledTextArea)this.getControl()).impl_setCaretOffset(lineOffset + lineContent.length(), event.isShiftDown());
                    event.consume();
                    break;
                }
                if (offset + 1 > ((StyledTextArea)this.getControl()).getContent().getCharCount()) break;
                int newOffset = offset + 1;
                ((StyledTextArea)this.getControl()).impl_setCaretOffset(newOffset, event.isShiftDown());
                event.consume();
                break;
            }
            case UP: {
                int rowIndex = currentRowIndex;
                if (rowIndex == 0) break;
                int colIdx = offset - ((StyledTextArea)this.getControl()).getContent().getOffsetAtLine(rowIndex);
                int lineOffset = ((StyledTextArea)this.getControl()).getContent().getOffsetAtLine(--rowIndex);
                int newCaretPosition = lineOffset + colIdx;
                int maxPosition = lineOffset + ((StyledTextArea)this.getControl()).getContent().getLine(rowIndex).length();
                ((StyledTextArea)this.getControl()).impl_setCaretOffset(Math.min(newCaretPosition, maxPosition), event.isShiftDown());
                event.consume();
                break;
            }
            case DOWN: {
                int rowIndex = currentRowIndex;
                if (rowIndex + 1 == ((StyledTextArea)this.getControl()).getContent().getLineCount()) break;
                int colIdx = offset - ((StyledTextArea)this.getControl()).getContent().getOffsetAtLine(rowIndex);
                int lineOffset = ((StyledTextArea)this.getControl()).getContent().getOffsetAtLine(++rowIndex);
                int newCaretPosition = lineOffset + colIdx;
                int maxPosition = lineOffset + ((StyledTextArea)this.getControl()).getContent().getLine(rowIndex).length();
                ((StyledTextArea)this.getControl()).impl_setCaretOffset(Math.min(newCaretPosition, maxPosition), event.isShiftDown());
                event.consume();
                break;
            }
            case ENTER: {
                if (!((StyledTextArea)this.getControl()).getEditable()) break;
                int line = ((StyledTextArea)this.getControl()).getContent().getLineAtOffset(((StyledTextArea)this.getControl()).getCaretOffset());
                String lineContent = ((StyledTextArea)this.getControl()).getContent().getLine(line);
                char[] chars = lineContent.toCharArray();
                String prefix = "";
                int i = 0;
                while (i < chars.length) {
                    if (chars[i] != ' ') break;
                    prefix = String.valueOf(prefix) + " ";
                    ++i;
                }
                ((StyledTextArea)this.getControl()).getContent().replaceTextRange(((StyledTextArea)this.getControl()).getCaretOffset(), 0, String.valueOf(event.getText()) + prefix);
                ((StyledTextArea)this.getControl()).setCaretOffset(offset + 1 + prefix.length());
                break;
            }
            case DELETE: {
                if (((StyledTextArea)this.getControl()).getEditable()) {
                    if (event.isMetaDown()) {
                        this.invokeAction(ActionEvent.ActionType.DELETE_WORD_NEXT);
                        break;
                    }
                    ((StyledTextArea)this.getControl()).getContent().replaceTextRange(((StyledTextArea)this.getControl()).getCaretOffset(), 1, "");
                    ((StyledTextArea)this.getControl()).setCaretOffset(offset);
                    break;
                }
            }
            case BACK_SPACE: {
                if (((StyledTextArea)this.getControl()).getEditable()) {
                    if (event.isMetaDown()) {
                        this.invokeAction(ActionEvent.ActionType.DELETE_WORD_PREVIOUS);
                        break;
                    }
                    TextSelection selection = ((StyledTextArea)this.getControl()).getSelection();
                    if (selection.length > 0) {
                        ((StyledTextArea)this.getControl()).getContent().replaceTextRange(selection.offset, selection.length, "");
                        ((StyledTextArea)this.getControl()).setCaretOffset(selection.offset);
                        break;
                    }
                    ((StyledTextArea)this.getControl()).getContent().replaceTextRange(((StyledTextArea)this.getControl()).getCaretOffset() - 1, 1, "");
                    ((StyledTextArea)this.getControl()).setCaretOffset(offset - 1);
                    break;
                }
            }
            case TAB: {
                if (((StyledTextArea)this.getControl()).getEditable()) {
                    event.consume();
                    if (event.isShiftDown()) break;
                    ((StyledTextArea)this.getControl()).getContent().replaceTextRange(((StyledTextArea)this.getControl()).getCaretOffset(), 0, "\t");
                    ((StyledTextArea)this.getControl()).setCaretOffset(offset + 1);
                    break;
                }
            }
            case V: {
                if (((StyledTextArea)this.getControl()).getEditable() && event.isShortcutDown()) {
                    ((StyledTextArea)this.getControl()).paste();
                    event.consume();
                    break;
                }
            }
            case C: {
                if (!((StyledTextArea)this.getControl()).getEditable() || !event.isShortcutDown()) break;
                ((StyledTextArea)this.getControl()).copy();
                event.consume();
                break;
            }
        }
    }

    private void _keyTyped(KeyEvent event) {
        if (((StyledTextArea)this.getControl()).getEditable()) {
            String character = event.getCharacter();
            if (character.length() == 0) {
                return;
            }
            if ((event.isControlDown() || event.isAltDown() || PlatformUtil.isMac() && event.isMetaDown()) && (!event.isControlDown() && !PlatformUtil.isMac() || !event.isAltDown())) {
                return;
            }
            if (character.charAt(0) > '\u001f' && character.charAt(0) != '\u007f' && !event.isMetaDown()) {
                int offset = ((StyledTextArea)this.getControl()).getCaretOffset();
                ((StyledTextArea)this.getControl()).getContent().replaceTextRange(((StyledTextArea)this.getControl()).getCaretOffset(), 0, character);
                ((StyledTextArea)this.getControl()).setCaretOffset(offset + 1);
            }
        }
    }

    public void updateCursor(MouseEvent event, List<StyledTextSkin.LineCell> visibleCells, boolean selection) {
        StyledTextSkin.LineCell lastCell = null;
        for (StyledTextSkin.LineCell tmp : visibleCells) {
            Bounds boundsInParent = tmp.getBoundsInParent();
            if (boundsInParent.getMinY() > event.getY()) {
                int index;
                if (lastCell == null) {
                    lastCell = tmp;
                }
                if (lastCell.getDomainElement() == null) break;
                StyledTextLayoutContainer n = (StyledTextLayoutContainer)lastCell.getGraphic();
                if (n.localToScene(n.getBoundsInLocal()).contains(event.getSceneX(), event.getSceneY()) && (index = n.getCaretIndexAtPoint(n.sceneToLocal(event.getSceneX(), event.getSceneY()))) >= 0) {
                    ((StyledTextArea)this.getControl()).impl_setCaretOffset(n.getStartOffset() + index, selection);
                    return;
                }
                int offset = lastCell.getDomainElement().getLineOffset() + lastCell.getDomainElement().getLineLength();
                ((StyledTextArea)this.getControl()).impl_setCaretOffset(offset, selection);
                break;
            }
            lastCell = tmp;
        }
        ((StyledTextArea)this.getControl()).requestFocus();
        Event.fireEvent((EventTarget)this.getControl(), (Event)event.copyFor((Object)this.getControl(), (EventTarget)this.getControl()));
    }
}

