/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.editors;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.fx.ide.jdt.ui.internal.editors.AddDialog;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.AntTask;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.Icon;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.IconType;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.ParametersFactory;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.ParametersPackage;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerValueProperty;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AddIconDialog
extends AddDialog<Icon> {
    private Icon o;
    private Text tUrl;
    private Text tWidth;
    private Text tHeight;
    private final EditingDomain editingDomain;
    private final AntTask task;

    public AddIconDialog(Shell parentShell, EditingDomain editingDomain, AntTask task) {
        super(parentShell);
        this.editingDomain = editingDomain;
        this.task = task;
    }

    @Override
    protected Control createDialogContent(Composite parent) {
        this.o = ParametersFactory.eINSTANCE.createIcon();
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(1, false));
        area.setLayoutData((Object)new GridData(1808));
        this.getShell().setText("Add icon");
        this.setTitle("Add icon");
        this.setMessage("Enter informations about the icon to add");
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        IViewerValueProperty selProp = ViewerProperties.singleSelection();
        IWidgetValueProperty tProp = WidgetProperties.text((int)24);
        Label l = new Label(container, 0);
        l.setText("Kind:");
        ComboViewer v = new ComboViewer(container, 8);
        v.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        v.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        v.setInput(IconType.VALUES);
        IEMFEditValueProperty prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ParametersPackage.Literals.ICON__KIND);
        this.dbContext.bindValue((IObservableValue)selProp.observe((Viewer)v), prop.observe((Object)this.o), (UpdateValueStrategy)new EMFUpdateValueStrategy(EMFUpdateValueStrategy.POLICY_ON_REQUEST), (UpdateValueStrategy)new EMFUpdateValueStrategy());
        l = new Label(container, 0);
        l.setText("URL*:");
        this.tUrl = new Text(container, 2048);
        this.tUrl.setLayoutData((Object)new GridData(768));
        IEMFEditValueProperty prop2 = EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ParametersPackage.Literals.ICON__HREF);
        this.dbContext.bindValue((IObservableValue)tProp.observeDelayed(500, (Widget)this.tUrl), prop2.observe((Object)this.o), (UpdateValueStrategy)new EMFUpdateValueStrategy(EMFUpdateValueStrategy.POLICY_ON_REQUEST), (UpdateValueStrategy)new EMFUpdateValueStrategy());
        l = new Label(container, 0);
        l.setText("Depth:");
        v = new ComboViewer(container, 8);
        v.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        v.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        v.setInput((Object)new String[]{"8", "24", "32"});
        prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ParametersPackage.Literals.ICON__DEPTH);
        this.dbContext.bindValue((IObservableValue)selProp.observe((Viewer)v), prop.observe((Object)this.o), (UpdateValueStrategy)new EMFUpdateValueStrategy(EMFUpdateValueStrategy.POLICY_ON_REQUEST), (UpdateValueStrategy)new EMFUpdateValueStrategy());
        l = new Label(container, 0);
        l.setText("Width:");
        this.tWidth = new Text(container, 2048);
        this.tWidth.setLayoutData((Object)new GridData(768));
        prop2 = EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ParametersPackage.Literals.ICON__WIDTH);
        this.dbContext.bindValue((IObservableValue)tProp.observeDelayed(500, (Widget)this.tWidth), prop2.observe((Object)this.o), (UpdateValueStrategy)new EMFUpdateValueStrategy(EMFUpdateValueStrategy.POLICY_ON_REQUEST), (UpdateValueStrategy)new EMFUpdateValueStrategy());
        l = new Label(container, 0);
        l.setText("Height:");
        this.tHeight = new Text(container, 2048);
        this.tHeight.setLayoutData((Object)new GridData(768));
        prop2 = EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ParametersPackage.Literals.ICON__HEIGHT);
        this.dbContext.bindValue((IObservableValue)tProp.observeDelayed(500, (Widget)this.tHeight), prop2.observe((Object)this.o), (UpdateValueStrategy)new EMFUpdateValueStrategy(EMFUpdateValueStrategy.POLICY_ON_REQUEST), (UpdateValueStrategy)new EMFUpdateValueStrategy());
        return area;
    }

    @Override
    protected Command generateOkCommand() {
        return new AddCommand(this.editingDomain, this.task.getDeploy().getInfo().getIcon(), (Object)this.o);
    }

    @Override
    protected IStatus validate() {
        MultiStatus status = new MultiStatus("org.eclipse.fx.ide.jdt.ui", 0, "OK", null);
        if (this.tUrl.getText() == null || this.tUrl.getText().trim().equals("")) {
            status.add((IStatus)new Status(4, "org.eclipse.fx.ide.jdt.ui", "Please enter a URL"));
        } else {
            try {
                new URL(this.tUrl.getText());
            }
            catch (MalformedURLException malformedURLException) {
                status.add((IStatus)new Status(4, "org.eclipse.fx.ide.jdt.ui", "URL seems to be invalid"));
            }
        }
        if (this.tWidth.getText() != null && this.tWidth.getText().trim().length() > 0) {
            try {
                Integer.parseInt(this.tWidth.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                status.add((IStatus)new Status(4, "org.eclipse.fx.ide.jdt.ui", "Width must be an integer value"));
            }
        }
        if (this.tHeight.getText() != null && this.tHeight.getText().trim().length() > 0) {
            try {
                Integer.parseInt(this.tHeight.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                status.add((IStatus)new Status(4, "org.eclipse.fx.ide.jdt.ui", "Height must be an integer value"));
            }
        }
        return status;
    }

    @Override
    protected Icon getObject() {
        return this.o;
    }
}

