/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.launch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.util.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenLauncherConfiguration;
import org.eclipse.m2e.core.embedder.MavenRuntime;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.launch.ClasspathEntry;
import org.eclipse.m2e.core.internal.launch.ProjectClasspathEntry;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractMavenRuntime
implements MavenRuntime {
    private static final VersionRange SUPPORTED_VERSION;
    private static final IWorkspaceRoot workspace;
    private static final IMavenProjectRegistry registry;
    private final String name;
    private List<ClasspathEntry> extensions;

    static {
        VersionRange supportedVersion;
        try {
            supportedVersion = VersionRange.createFromVersionSpec((String)"[3.0,)");
        }
        catch (InvalidVersionSpecificationException ex) {
            supportedVersion = null;
        }
        SUPPORTED_VERSION = supportedVersion;
        workspace = ResourcesPlugin.getWorkspace().getRoot();
        registry = MavenPlugin.getMavenProjectRegistry();
    }

    @Deprecated
    protected AbstractMavenRuntime() {
        this.name = null;
    }

    protected AbstractMavenRuntime(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name != null ? this.name : this.getLocation();
    }

    public List<ClasspathEntry> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<ClasspathEntry> extensions) {
        this.extensions = extensions != null && !extensions.isEmpty() ? new ArrayList<ClasspathEntry>(extensions) : null;
    }

    public boolean isLegacy() {
        return this.name == null;
    }

    protected void collectExtensions(IMavenLauncherConfiguration collector, IProgressMonitor monitor) throws CoreException {
        if (this.extensions != null) {
            for (ClasspathEntry entry : this.extensions) {
                if (!(entry instanceof ProjectClasspathEntry)) continue;
                this.collectProject(collector, (ProjectClasspathEntry)entry, monitor);
            }
        }
    }

    private void collectProject(IMavenLauncherConfiguration collector, ProjectClasspathEntry entry, IProgressMonitor monitor) throws CoreException {
        IProject project = workspace.getProject(entry.getProject());
        IMavenProjectFacade facade = registry.create(project, monitor);
        if (facade == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", NLS.bind((String)Messages.AbstractMavenRuntime_unknownProject, (Object)entry.getProject())));
        }
        collector.addProjectEntry(facade);
        MavenProject mavenProject = facade.getMavenProject(monitor);
        for (Artifact dependency : mavenProject.getArtifacts()) {
            if (!"compile".equals(dependency.getScope()) && !"runtime".equals(dependency.getScope())) continue;
            collector.addArchiveEntry(dependency.getFile().getAbsolutePath());
        }
    }

    public boolean equals(Object o) {
        if (o != null && this.getClass().equals(o.getClass())) {
            return this.getName().equals(((AbstractMavenRuntime)o).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    protected boolean isSupportedVersion() {
        return SUPPORTED_VERSION != null && SUPPORTED_VERSION.containsVersion((ArtifactVersion)new DefaultArtifactVersion(this.getVersion()));
    }

    @Override
    public String getSettings() {
        String settings = MavenPlugin.getMavenConfiguration().getGlobalSettingsFile();
        if (!StringUtils.isEmpty((String)settings)) {
            try {
                settings = new File(settings).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return settings;
    }
}

