/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.shared.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProperties {
    private static final Logger log = LoggerFactory.getLogger(MavenProperties.class);
    private static final String BUILD_VERSION_PROPERTY = "version";
    private static final String BUILD_VERSION_UNKNOWN_PROPERTY = "<version unknown>";
    private static String mavenVersion;
    private static String mavenBuildVersion;

    static {
        Properties properties = MavenProperties.getMavenRuntimeProperties();
        mavenVersion = properties.getProperty(BUILD_VERSION_PROPERTY, BUILD_VERSION_UNKNOWN_PROPERTY);
        mavenBuildVersion = MavenProperties.createMavenVersionString(properties);
    }

    private MavenProperties() {
    }

    static Properties getMavenRuntimeProperties() {
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream resourceAsStream = MavenCli.class.getResourceAsStream("/org/apache/maven/messages/build.properties");){
                if (resourceAsStream != null) {
                    properties.load(resourceAsStream);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error("Unable to read Maven properties from JAR file: {}", (Object)e.getMessage());
        }
        return properties;
    }

    static String createMavenVersionString(Properties buildProperties) {
        String timestamp = MavenProperties.reduce(buildProperties.getProperty("timestamp"));
        String version = MavenProperties.reduce(buildProperties.getProperty(BUILD_VERSION_PROPERTY));
        String rev = MavenProperties.reduce(buildProperties.getProperty("buildNumber"));
        String distributionName = MavenProperties.reduce(buildProperties.getProperty("distributionName"));
        String msg = String.valueOf(distributionName) + " ";
        msg = String.valueOf(msg) + (version != null ? version : BUILD_VERSION_UNKNOWN_PROPERTY);
        if (rev != null || timestamp != null) {
            msg = String.valueOf(msg) + " (";
            msg = String.valueOf(msg) + (rev != null ? rev : "");
            if (StringUtils.isNotBlank((String)timestamp)) {
                String ts = MavenProperties.formatTimestamp(Long.parseLong(timestamp));
                msg = String.valueOf(msg) + (rev != null ? "; " : "") + ts;
            }
            msg = String.valueOf(msg) + ")";
        }
        return msg;
    }

    private static String reduce(String s) {
        return s != null ? (s.startsWith("${") && s.endsWith("}") ? null : s) : null;
    }

    private static String formatTimestamp(long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        return sdf.format(new Date(timestamp));
    }

    public static String getMavenBuildVersion() {
        return mavenBuildVersion;
    }

    public static String getMavenVersion() {
        return mavenVersion;
    }

    public static void setProperties(Properties properties) {
        if (properties != null) {
            properties.setProperty("maven.version", mavenVersion);
            properties.setProperty("maven.build.version", mavenBuildVersion);
        }
    }
}

