/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.formatting2;

import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;
import org.eclipse.xtext.xbase.formatting2.Entry;
import org.eclipse.xtext.xbase.formatting2.SeparatorEntry;
import org.eclipse.xtext.xbase.formatting2.SeparatorRegions;

public class ObjectEntry<T, R extends ITextSegment>
extends Entry<T, R> {
    private final SeparatorRegions<T, R> list;
    private T object;

    public ITextSegment getRegion() {
        SeparatorEntry<T, R> prev = this.getLeadingSeparator();
        SeparatorEntry<T, R> trail = this.getTrailingSeparator();
        int offset = prev != null ? prev.getSeparator().getEndOffset() : this.list.getRoot().getOffset();
        int endOffset = trail != null ? trail.getSeparator().getOffset() : this.list.getRoot().getEndOffset();
        return new TextSegment(this.list.getRoot().getTextRegionAccess(), offset, endOffset - offset);
    }

    @Override
    public ObjectEntry<T, R> getLeadingObject() {
        Entry result = null;
        if (this.previous != null) {
            result = this.previous.previous;
        }
        return (ObjectEntry)result;
    }

    @Override
    public ObjectEntry<T, R> getTrailingObject() {
        Entry result = null;
        if (this.next != null) {
            result = this.next.next;
        }
        return (ObjectEntry)result;
    }

    @Override
    public SeparatorEntry<T, R> getLeadingSeparator() {
        return (SeparatorEntry)this.previous;
    }

    @Override
    public SeparatorEntry<T, R> getTrailingSeparator() {
        return (SeparatorEntry)this.next;
    }

    public String toString() {
        ITextSegment reg = this.getRegion();
        return "\"" + reg.getText() + "\" at offset=" + reg.getOffset() + " lenght=" + reg.getLength() + " (" + this.object.getClass().getSimpleName() + ")";
    }

    public ObjectEntry(SeparatorRegions<T, R> list) {
        this.list = list;
    }

    public SeparatorRegions<T, R> getList() {
        return this.list;
    }

    public T getObject() {
        return this.object;
    }

    public void setObject(T object) {
        this.object = object;
    }
}

