/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.codegen.jet.JETJavaItem;
import org.eclipse.emf.codegen.jet.JETMark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JETLiteralItem
extends JETJavaItem {
    private static final JETMark[] NO_TRANSITIONS = new JETMark[0];
    private final JETMark[] fileTransitionMarks;
    private List<JETLiteralItem> explodedItems;

    JETLiteralItem(JETMark start, JETMark stop, List<JETMark> fileTransitionMarks) {
        super(start, stop);
        this.fileTransitionMarks = fileTransitionMarks.isEmpty() ? NO_TRANSITIONS : fileTransitionMarks.toArray(new JETMark[fileTransitionMarks.size()]);
        this.assertHasConsistentTransitions();
    }

    JETLiteralItem(JETMark start, JETMark stop) {
        super(start, stop);
        this.fileTransitionMarks = NO_TRANSITIONS;
    }

    @Override
    protected void assertDoesNotSpanFiles() {
    }

    @Override
    void setSkipped(boolean skipped) {
        super.setSkipped(skipped);
        if (this.fileTransitionMarks != NO_TRANSITIONS) {
            for (JETLiteralItem jetLiteralItem : this.explode()) {
                jetLiteralItem.setSkipped(skipped);
            }
        }
    }

    protected List<JETLiteralItem> explode() {
        if (this.fileTransitionMarks == NO_TRANSITIONS) {
            return Collections.singletonList(this);
        }
        if (this.explodedItems == null) {
            ArrayList<JETLiteralItem> newExplodedItems = new ArrayList<JETLiteralItem>();
            JETMark previousStart = this.getStart();
            int i = 0;
            while (i < this.fileTransitionMarks.length) {
                JETMark nextStop = this.fileTransitionMarks[i];
                newExplodedItems.add(new JETLiteralItem(previousStart, nextStop));
                previousStart = this.fileTransitionMarks[i + 1];
                i += 2;
            }
            newExplodedItems.add(new JETLiteralItem(previousStart, this.getStop()));
            this.explodedItems = Collections.unmodifiableList(newExplodedItems);
        }
        return this.explodedItems;
    }

    protected void assertHasConsistentTransitions() {
        Assert.isTrue((this.fileTransitionMarks.length % 2 == 0 ? 1 : 0) != 0, (String)"There must be an even number of transitions");
        if (this.fileTransitionMarks.length > 0) {
            Assert.isTrue((this.getStart().getFileId() == this.fileTransitionMarks[0].getFileId() ? 1 : 0) != 0, (String)"A literal item's start and its first file transition must not span differnt files");
            int i = 1;
            while (i + 1 < this.fileTransitionMarks.length) {
                Assert.isTrue((this.fileTransitionMarks[i].getFileId() == this.fileTransitionMarks[i + 1].getFileId() ? 1 : 0) != 0, (String)"Intermediate file transitions must not span differnt files");
                i += 2;
            }
            Assert.isTrue((this.getStop().getFileId() == this.fileTransitionMarks[this.fileTransitionMarks.length - 1].getFileId() ? 1 : 0) != 0, (String)"A literal item's ttop and its last file transition must not span differnt files");
        }
    }
}

