/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ChannelSelector implements Enumerator
{
    R(0, "R", "R"),
    G(1, "G", "G"),
    B(2, "B", "B"),
    A(3, "A", "A");

    public static final int R_VALUE = 0;
    public static final int G_VALUE = 1;
    public static final int B_VALUE = 2;
    public static final int A_VALUE = 3;
    private static final ChannelSelector[] VALUES_ARRAY;
    public static final List<ChannelSelector> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ChannelSelector[]{R, G, B, A};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ChannelSelector get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChannelSelector result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChannelSelector getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChannelSelector result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChannelSelector get(int value) {
        switch (value) {
            case 0: {
                return R;
            }
            case 1: {
                return G;
            }
            case 2: {
                return B;
            }
            case 3: {
                return A;
            }
        }
        return null;
    }

    private ChannelSelector(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

