/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.ThreadQueue;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;

public class EventLoop
implements ThreadQueue {
    AtomicReference<Runnable> runnableRef = new AtomicReference();
    private volatile AtomicInteger spinningEventLoop = new AtomicInteger();
    private final Thread thread = new Thread(){

        @Override
        public void run() {
            EventLoop.this.runnableRef.get().run();
        }
    };
    private ExecutorService service = Executors.newSingleThreadExecutor(r -> {
        this.runnableRef.set(r);
        this.thread.setDaemon(true);
        return this.thread;
    });
    List<Runnable> tasks = new ArrayList<Runnable>();
    private static Logger LOGGER;

    private static Logger getLogger() {
        if (LOGGER == null) {
            LOGGER = LoggerCreator.createLogger(EventLoop.class);
        }
        return LOGGER;
    }

    @Override
    public boolean isCurrent() {
        return Thread.currentThread() == this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscription push(Runnable r) {
        if (this.isCurrent()) {
            r.run();
            return () -> {};
        }
        List<Runnable> list = this.tasks;
        synchronized (list) {
            this.tasks.add(r);
        }
        return () -> {
            List<Runnable> list = this.tasks;
            synchronized (list) {
                this.tasks.remove(r);
            }
        };
    }

    public void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch() {
        ArrayList<Runnable> list;
        if (this.spinningEventLoop.get() > 0 && !this.isCurrent()) {
            return false;
        }
        List<Runnable> list2 = this.tasks;
        synchronized (list2) {
            list = new ArrayList<Runnable>(this.tasks);
            this.tasks.clear();
        }
        Runnable executable = () -> {
            for (Runnable r : list) {
                try {
                    r.run();
                }
                catch (Throwable t) {
                    EventLoop.getLogger().error(t.getMessage(), t);
                }
            }
        };
        if (this.isCurrent()) {
            executable.run();
        } else {
            this.service.submit(executable);
        }
        List<Runnable> list3 = this.tasks;
        synchronized (list3) {
            return !this.tasks.isEmpty();
        }
    }

    public void dispose() {
        this.service.shutdown();
    }

    @Override
    public <T> void spinWhile(ThreadSynchronize.BlockCondition<T> condition) {
        this.spinningEventLoop.incrementAndGet();
        while (condition.isBlocked()) {
            if (this.dispatch()) continue;
            this.sleep();
        }
        this.spinningEventLoop.decrementAndGet();
    }
}

