/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base.addons;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.ui.workbench.renderers.base.services.DnDService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WDragSourceWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WDragTargetWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WStack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.event.Event;

public class DnDAddon {
    private static String CSS_CLASS_STACK_MOVE = "stack-move";
    @Inject
    IEventBroker eventBroker;
    @Inject
    UISynchronize synchronize;
    @Inject
    EModelService modelService;
    @Inject
    @Optional
    DnDService dndService;
    private Timer timer = new Timer(true);

    private WDragTargetWidget getTargetWidget(MUIElement changedElement) {
        if (changedElement instanceof MPlaceholder) {
            return this.getTargetWidget(((MPlaceholder)changedElement).getRef());
        }
        if (changedElement.getWidget() instanceof WDragTargetWidget) {
            return (WDragTargetWidget)changedElement.getWidget();
        }
        return null;
    }

    private WStack<?, ?, ?> getSourceWidget(MUIElement changedElement) {
        if (changedElement instanceof MPlaceholder) {
            return this.getSourceWidget(((MPlaceholder)changedElement).getRef());
        }
        if (changedElement.getWidget() instanceof WDragSourceWidget) {
            return (WStack)changedElement.getWidget();
        }
        return null;
    }

    private void handleWidget(Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        WDragTargetWidget acceptWidget = this.getTargetWidget(changedElement);
        if (acceptWidget != null) {
            acceptWidget.setDragDroppedCallback(this::droppedHandler);
        }
        if (!(changedElement instanceof MPartStack) && !(changedElement instanceof MArea)) {
            return;
        }
        WStack<?, ?, ?> sourceWidget = this.getSourceWidget(changedElement);
        if (sourceWidget != null) {
            sourceWidget.setDragStartCallback(this::dragStartHandler);
        }
    }

    private Void droppedHandler(WDragTargetWidget.DropData d) {
        @Nullable MUIElement reference = d.reference;
        @NonNull MUIElement sourceElement = d.sourceElement;
        if (d.dropType.isReorder()) {
            if (reference != null && (this.dndService == null || this.dndService.reorderAllowed(reference, sourceElement, d.dropType) && !this.dndService.handleReorder(reference, sourceElement, d.dropType)) && d.dropType instanceof WDragTargetWidget.BasicDropLocation) {
                this.handleReorder(reference, sourceElement, (WDragTargetWidget.BasicDropLocation)d.dropType);
            }
        } else if (d.dropType.isDetach()) {
            if (this.dndService == null || this.dndService.detachAllowed(sourceElement) && !this.dndService.handleDetach(d.x, d.y, sourceElement)) {
                this.handleDetach(d.x, d.y, sourceElement);
            }
        } else if (d.dropType.isInsert()) {
            if (reference != null && (this.dndService == null || this.dndService.insertAllowed(reference, sourceElement) && !this.dndService.handleInsert(reference, sourceElement))) {
                DnDAddon.handleInsert(reference, sourceElement);
            }
        } else if (d.dropType.isSplit() && reference != null && (this.dndService == null || this.dndService.splitAllowed(reference, sourceElement, d.dropType) && !this.dndService.handleSplit(reference, sourceElement, d.dropType))) {
            this.handleSplit(reference, sourceElement, d.dropType);
        }
        return null;
    }

    private void handleDetach(double x, double y, @NonNull MUIElement sourceElement) {
        this.modelService.detach((MPartSashContainerElement)sourceElement, (int)x, (int)y, 800, 600);
    }

    private static void handleInsert(@NonNull MUIElement reference, @NonNull MUIElement sourceElement) {
        if (reference instanceof MElementContainer) {
            MElementContainer c = (MElementContainer)reference;
            c.getChildren().add(sourceElement);
        }
    }

    private void handleSplit(@NonNull MUIElement reference, @NonNull MUIElement sourceElement, @NonNull WDragTargetWidget.DropLocation dropType) {
        MElementContainer parent = reference.getParent();
        if (parent instanceof MPartStack) {
            this.split((MUIElement)parent, sourceElement, dropType);
        }
    }

    private void split(MUIElement toSplit, MUIElement child, @NonNull WDragTargetWidget.DropLocation dropType) {
        child.setParent(null);
        MElementContainer owner = toSplit.getParent();
        int index = owner.getChildren().indexOf(toSplit);
        owner.getChildren().remove(toSplit);
        MPartSashContainer container = (MPartSashContainer)this.modelService.createModelElement(MPartSashContainer.class);
        container.setElementId(UUID.randomUUID().toString());
        container.setContainerData(toSplit.getContainerData());
        MPartStack childContainer = (MPartStack)this.modelService.createModelElement(MPartStack.class);
        childContainer.setElementId(UUID.randomUUID().toString());
        childContainer.getChildren().add((MStackElement)child);
        toSplit.setContainerData(null);
        childContainer.setContainerData(null);
        container.setToBeRendered(true);
        container.setVisible(true);
        container.setHorizontal(dropType == WDragTargetWidget.BasicDropLocation.SPLIT_LEFT || dropType == WDragTargetWidget.BasicDropLocation.SPLIT_RIGHT);
        if (dropType == WDragTargetWidget.BasicDropLocation.SPLIT_TOP || dropType == WDragTargetWidget.BasicDropLocation.SPLIT_LEFT) {
            container.getChildren().add(childContainer);
            container.getChildren().add((MPartSashContainerElement)toSplit);
        } else {
            container.getChildren().add((MPartSashContainerElement)toSplit);
            container.getChildren().add(childContainer);
        }
        owner.getChildren().add(index, container);
    }

    private void handleReorder(@NonNull MUIElement reference, final @NonNull MUIElement sourceElement, @NonNull WDragTargetWidget.BasicDropLocation dropType) {
        MElementContainer targetContainer;
        MElementContainer sourceContainer = sourceElement.getParent();
        if (sourceContainer == (targetContainer = reference.getParent())) {
            try {
                targetContainer.getTags().add(CSS_CLASS_STACK_MOVE);
                sourceElement.getTransientData().put("fx.rendering.stackitem.move", Boolean.TRUE);
                List children = targetContainer.getChildren();
                children.remove(sourceElement);
                int idx = targetContainer.getChildren().indexOf(reference);
                if (dropType == WDragTargetWidget.BasicDropLocation.AFTER) {
                    ++idx;
                }
                if (idx > targetContainer.getChildren().size()) {
                    targetContainer.getChildren().add(sourceElement);
                }
                targetContainer.getChildren().add(idx, sourceElement);
            }
            finally {
                sourceElement.getTransientData().put("fx.rendering.stackitem.move", Boolean.TRUE);
                targetContainer.getTags().remove(CSS_CLASS_STACK_MOVE);
            }
        } else {
            int idx = targetContainer.getChildren().indexOf(reference);
            if (dropType == WDragTargetWidget.BasicDropLocation.AFTER) {
                ++idx;
            }
            if (idx < targetContainer.getChildren().size()) {
                targetContainer.getChildren().add(idx, sourceElement);
            } else {
                targetContainer.getChildren().add(sourceElement);
            }
        }
        TimerTask t = new TimerTask(){

            @Override
            public void run() {
                DnDAddon.this.synchronize.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        targetContainer.setSelectedElement(sourceElement);
                    }
                });
            }
        };
        this.timer.schedule(t, 200L);
    }

    private @NonNull Boolean dragStartHandler(@NonNull WDragSourceWidget.DragData d) {
        return this.dndService == null || this.dndService.dragAllowed(d.container, d.item);
    }

    @PostConstruct
    void hookListeners() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", this::handleWidget);
    }
}

