/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.IExpressionScope;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IAmbiguousLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IApplicableCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceFlags;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.DefaultReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.ExpectedExceptionsStackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionAwareStackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.FollowUpError;
import org.eclipse.xtext.xbase.typesystem.internal.ForwardingResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.IFeatureScopeTracker;
import org.eclipse.xtext.xbase.typesystem.internal.ReassigningStackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeData;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.ConstraintVisitingInfo;
import org.eclipse.xtext.xbase.typesystem.util.CustomTypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.ExpectationTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.Maps2;
import org.eclipse.xtext.xbase.typesystem.util.MultimapJoiner;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByUnboundSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

public abstract class ResolvedTypes
implements IResolvedTypes {
    private final Owner owner;
    private Set<AbstractDiagnostic> diagnostics;
    private Set<IAcceptor<? super IResolvedTypes>> deferredLogic;
    private Map<JvmIdentifiableElement, LightweightTypeReference> types;
    private Map<JvmIdentifiableElement, LightweightTypeReference> reassignedTypes;
    private Map<XExpression, List<TypeData>> expressionTypes;
    private Map<XExpression, IApplicableCandidate> linkingMap;
    private Map<Object, UnboundTypeReference> unboundTypeParameters;
    private Map<Object, List<LightweightBoundTypeArgument>> typeParameterHints;
    private Set<Object> resolvedTypeParameters;
    private Set<XExpression> refinedTypes;
    private Set<XExpression> propagatedTypes;
    private List<JvmTypeParameter> declaredTypeParameters;
    final Shared shared;

    protected ResolvedTypes(Shared shared) {
        this.shared = shared;
        this.owner = new Owner(shared.resolver.getServices(), shared.resolver.getRoot().eResource().getResourceSet());
    }

    protected CancelIndicator getMonitor() {
        return this.shared.monitor;
    }

    protected void checkCanceled() {
        this.getResolver().getOperationCanceledManager().checkCanceled(this.getMonitor());
    }

    protected void clear() {
        this.diagnostics = null;
        this.deferredLogic = null;
        this.types = null;
        this.reassignedTypes = null;
        this.expressionTypes = null;
        this.linkingMap = null;
        this.unboundTypeParameters = null;
        this.typeParameterHints = null;
        this.resolvedTypeParameters = null;
        this.propagatedTypes = null;
        this.refinedTypes = null;
    }

    protected IssueSeverities getSeverities() {
        return this.shared.issueSeverities;
    }

    protected IFeatureScopeTracker getFeatureScopeTracker() {
        return this.shared.featureScopeTracker;
    }

    public ITypeReferenceOwner getReferenceOwner() {
        return this.owner;
    }

    public ResourceSet getContextResourceSet() {
        return this.owner.getContextResourceSet();
    }

    public CommonTypeComputationServices getServices() {
        return this.owner.getServices();
    }

    @Override
    public Collection<AbstractDiagnostic> getQueuedDiagnostics() {
        if (this.diagnostics == null) {
            return Collections.emptyList();
        }
        return this.diagnostics;
    }

    public Collection<IAcceptor<? super IResolvedTypes>> getDeferredLogic() {
        if (this.deferredLogic == null) {
            return Collections.emptyList();
        }
        return this.deferredLogic;
    }

    protected void clearDeferredLogic() {
        this.deferredLogic = null;
    }

    public void addDiagnostic(AbstractDiagnostic diagnostic) {
        if (this.diagnostics == null) {
            this.diagnostics = Sets.newLinkedHashSet();
        }
        if (!this.diagnostics.add(diagnostic)) {
            throw new IllegalStateException("Duplicate diagnostic: " + diagnostic);
        }
    }

    protected void addDeferredLogic(IAcceptor<? super IResolvedTypes> code) {
        if (this.deferredLogic == null) {
            this.deferredLogic = Sets.newLinkedHashSet();
        }
        if (!this.deferredLogic.add(code)) {
            throw new IllegalStateException("Duplicate runnable: " + code);
        }
    }

    @Override
    public List<LightweightTypeReference> getThrownExceptions(XExpression obj) {
        return this.getServices().getEarlyExitComputer().getThrownExceptions(obj, this, this.getReferenceOwner());
    }

    @Override
    public JvmIdentifiableElement getLinkedFeature(XAbstractFeatureCall featureCall) {
        if (!this.shared.allLinking.contains(featureCall)) {
            return null;
        }
        return this.doGetLinkedFeature(featureCall);
    }

    @Override
    public JvmIdentifiableElement getLinkedFeature(XConstructorCall constructorCall) {
        if (!this.shared.allLinking.contains(constructorCall)) {
            return null;
        }
        return this.doGetLinkedFeature(constructorCall);
    }

    @Override
    public IFeatureLinkingCandidate getLinkingCandidate(XAbstractFeatureCall featureCall) {
        if (!this.shared.allLinking.contains(featureCall)) {
            return null;
        }
        return (IFeatureLinkingCandidate)this.doGetCandidate(featureCall);
    }

    @Override
    public IConstructorLinkingCandidate getLinkingCandidate(XConstructorCall constructorCall) {
        if (!this.shared.allLinking.contains(constructorCall)) {
            return null;
        }
        return (IConstructorLinkingCandidate)this.doGetCandidate(constructorCall);
    }

    protected IApplicableCandidate doGetCandidate(XExpression featureOrConstructorCall) {
        if (this.linkingMap == null || featureOrConstructorCall == null) {
            return null;
        }
        IApplicableCandidate candidate = this.linkingMap.get(featureOrConstructorCall);
        return candidate;
    }

    protected JvmIdentifiableElement doGetLinkedFeature(XExpression featureOrConstructorCall) {
        if (this.linkingMap == null || featureOrConstructorCall == null || featureOrConstructorCall.eClass() == XbasePackage.Literals.XCLOSURE) {
            return null;
        }
        IApplicableCandidate candidate = this.linkingMap.get(featureOrConstructorCall);
        if (candidate == null) {
            return null;
        }
        return ((ILinkingCandidate)candidate).getFeature();
    }

    protected TypeData getTypeData(XExpression expression, boolean returnType) {
        return this.getTypeData(expression, returnType, false);
    }

    protected TypeData getTypeData(XExpression expression, boolean returnType, boolean nullIfEmpty) {
        if (!this.shared.allExpressionTypes.contains(expression)) {
            return null;
        }
        List<TypeData> values = this.doGetTypeData(expression);
        if (values == null) {
            return null;
        }
        TypeData result = this.mergeTypeData(expression, values, returnType, nullIfEmpty);
        return result;
    }

    protected List<TypeData> doGetTypeData(XExpression expression) {
        List<TypeData> result = this.basicGetExpressionTypes().get(expression);
        return result;
    }

    protected TypeData mergeTypeData(XExpression expression, List<TypeData> allValues, boolean returnType, boolean nullIfEmpty) {
        List<TypeData> values;
        int allSize = allValues.size();
        if (nullIfEmpty && allSize == 0) {
            return null;
        }
        if (allSize == 1) {
            TypeData result = allValues.get(0);
            if (result.isReturnType() == returnType) {
                return this.getSingleMergeResult(result, expression, returnType);
            }
            if (nullIfEmpty) {
                return null;
            }
            if (returnType) {
                return this.getSingleMergeResult(result, expression, returnType);
            }
            values = Collections.emptyList();
        } else {
            values = this.collectValues(allValues, returnType);
        }
        if (nullIfEmpty && values.size() == 0) {
            return null;
        }
        if (values.size() == 1) {
            TypeData typeData = values.get(0);
            return this.getSingleMergeResult(typeData, expression, returnType);
        }
        MergeData mergeData = new MergeData();
        this.enhanceMergeData(values, mergeData);
        LightweightTypeReference mergedType = this.getMergedType(mergeData, values);
        if (mergedType == null) {
            return null;
        }
        if (mergeData.expectation == null) {
            throw new IllegalStateException("Expectation should never be null here");
        }
        mergedType = this.refineMergedType(mergeData, mergedType, returnType, nullIfEmpty);
        TypeData result = new TypeData(expression, mergeData.expectation, mergedType, mergeData.mergedFlags, returnType);
        return result;
    }

    private TypeData getSingleMergeResult(TypeData typeData, XExpression expression, boolean returnType) {
        LightweightTypeReference upperBoundSubstitute = typeData.getActualType().getUpperBoundSubstitute();
        if (upperBoundSubstitute != typeData.getActualType()) {
            return new TypeData(expression, typeData.getExpectation(), upperBoundSubstitute, typeData.getConformanceFlags(), returnType);
        }
        return typeData;
    }

    private LightweightTypeReference refineMergedType(MergeData mergeData, LightweightTypeReference mergedType, boolean returnType, boolean useExpectation) {
        LightweightTypeReference expectedType;
        if (useExpectation && mergeData.expectation != null && (returnType || !mergeData.allNoImplicitReturn) && (expectedType = mergeData.expectation.getExpectedType()) != null && expectedType.isResolved() && !expectedType.isAssignableFrom(mergedType)) {
            boolean valid = true;
            for (LightweightTypeReference mergedReference : mergeData.references) {
                if (expectedType.isAssignableFrom(mergedReference)) continue;
                valid = false;
                break;
            }
            if (valid) {
                mergedType = expectedType;
                mergeData.mergedFlags &= 0xFE3BFFFF;
                mergeData.mergedFlags |= 0x100200;
            }
        }
        if (mergeData.voidSeen && returnType && !mergeData.references.isEmpty()) {
            mergedType = mergedType.getWrapperTypeIfPrimitive();
        }
        return mergedType;
    }

    private LightweightTypeReference getMergedType(MergeData mergeData, List<TypeData> values) {
        LightweightTypeReference mergedType = !mergeData.references.isEmpty() || !mergeData.voidSeen ? this.getMergedType(mergeData.references) : values.get(0).getActualType();
        return mergedType;
    }

    private void enhanceMergeData(List<TypeData> values, MergeData mergeData) {
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            ITypeExpectation knownExpectation;
            TypeData value = values.get(i);
            LightweightTypeReference reference = value.getActualType().getUpperBoundSubstitute();
            int flags = value.getConformanceFlags();
            if (reference.isPrimitiveVoid()) {
                if ((flags & 0x8000000) != 0) {
                    mergeData.references.clear();
                    mergeData.references.add(reference);
                    mergeData.mergedFlags = flags;
                    mergeData.expectation = value.getExpectation();
                    mergeData.voidSeen = false;
                    return;
                }
                mergeData.voidSeen = true;
            } else {
                mergeData.references.add(reference);
            }
            mergeData.allNoImplicitReturn = mergeData.allNoImplicitReturn && (flags & 0x4000000) != 0;
            boolean bl = mergeData.allThrownException = mergeData.allThrownException && (flags & 0x20000000) != 0;
            if (!reference.isUnknown()) {
                mergeData.mergedFlags |= flags;
            }
            if (mergeData.expectation == null) {
                mergeData.expectation = value.getExpectation();
                continue;
            }
            if (mergeData.expectation.getExpectedType() != null || (knownExpectation = value.getExpectation()).getExpectedType() == null) continue;
            mergeData.expectation = knownExpectation;
        }
        if (mergeData.mergedFlags == 0x2000000) {
            mergeData.mergedFlags |= 0x100200;
        }
        if (!mergeData.allNoImplicitReturn) {
            mergeData.mergedFlags &= 0xFBFFFFFF;
        }
        if (!mergeData.allThrownException) {
            mergeData.mergedFlags &= 0xDFFFFFFF;
        }
        if ((mergeData.mergedFlags & 0x500000) == 0x500000) {
            mergeData.mergedFlags &= 0xFE6BFDFF;
        }
        if ((mergeData.mergedFlags & 0x400000) != 0) {
            mergeData.mergedFlags &= 0xFFDFFFFF;
        }
    }

    private List<TypeData> collectValues(List<TypeData> allValues, boolean returnType) {
        int size = allValues.size();
        for (int i = 0; i < size; ++i) {
            TypeData value = allValues.get(i);
            if (returnType == value.isReturnType()) continue;
            ArrayList result = Lists.newArrayListWithCapacity((int)allValues.size());
            if (i != 0) {
                result.addAll(allValues.subList(0, i));
            }
            for (int j = i + 1; j < size; ++j) {
                value = allValues.get(j);
                if (returnType != value.isReturnType()) continue;
                result.add(value);
            }
            if (result.isEmpty() && returnType) {
                return allValues;
            }
            return result;
        }
        return allValues;
    }

    protected LightweightTypeReference getMergedType(List<LightweightTypeReference> types) {
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() == 1) {
            LightweightTypeReference result = types.get(0);
            return result;
        }
        LightweightTypeReference result = this.getServices().getTypeConformanceComputer().getCommonSuperType(types, this.getReferenceOwner());
        if (result != null || types.isEmpty()) {
            return result;
        }
        for (LightweightTypeReference type : types) {
            if (type.isType(Void.TYPE)) continue;
            return type;
        }
        return types.get(0);
    }

    @Override
    public LightweightTypeReference getActualType(XExpression expression) {
        LightweightTypeReference result = this.doGetActualType(expression);
        return this.toOwnedReference(result);
    }

    protected abstract LightweightTypeReference getExpectedTypeForAssociatedExpression(JvmMember var1, XExpression var2);

    @Override
    public LightweightTypeReference getReturnType(XExpression expression) {
        LightweightTypeReference result = this.doGetReturnType(expression);
        return this.toOwnedReference(result);
    }

    protected LightweightTypeReference toOwnedReference(LightweightTypeReference result) {
        return result != null ? result.copyInto(this.getReferenceOwner()) : null;
    }

    protected LightweightTypeReference doGetActualType(XExpression expression) {
        TypeData typeData = this.getTypeData(expression, false);
        if (typeData != null) {
            return typeData.getActualType();
        }
        return null;
    }

    protected LightweightTypeReference doGetReturnType(XExpression expression) {
        TypeData typeData = this.getTypeData(expression, true);
        if (typeData != null) {
            return typeData.getActualType();
        }
        return null;
    }

    @Override
    public LightweightTypeReference getExpectedType(XExpression expression) {
        LightweightTypeReference result = this.doGetExpectedType(expression, false);
        return this.toOwnedReference(result);
    }

    protected ResolvedTypes pushExpectedExceptions(List<LightweightTypeReference> exceptions) {
        return new ExpectedExceptionsStackedResolvedTypes(this, exceptions);
    }

    protected ResolvedTypes discardExpectedExceptions() {
        return new ExpectedExceptionsStackedResolvedTypes(this);
    }

    protected ResolvedTypes pushExpectedExceptions(JvmExecutable exceptionDeclarator) {
        EList executablesExceptions = exceptionDeclarator.getExceptions();
        if (executablesExceptions.isEmpty()) {
            return this;
        }
        ArrayList exceptions = Lists.newArrayListWithCapacity((int)executablesExceptions.size());
        for (JvmTypeReference exception : executablesExceptions) {
            exceptions.add(this.getReferenceOwner().toLightweightTypeReference(exception));
        }
        return this.pushExpectedExceptions(exceptions);
    }

    @Override
    public LightweightTypeReference getExpectedReturnType(XExpression expression) {
        LightweightTypeReference result = this.doGetExpectedType(expression, true);
        return this.toOwnedReference(result);
    }

    @Override
    public boolean isVoidTypeAllowed(XExpression expression) {
        TypeData typeData = this.getTypeData(expression, false);
        if (typeData != null) {
            return typeData.getExpectation().isVoidTypeAllowed();
        }
        return true;
    }

    public boolean isVoidReturnTypeAllowed(XExpression expression) {
        TypeData typeData = this.getTypeData(expression, true);
        if (typeData != null && typeData.isReturnType()) {
            return typeData.getExpectation().isVoidTypeAllowed();
        }
        return true;
    }

    protected LightweightTypeReference doGetExpectedType(XExpression expression, boolean returnType) {
        TypeData typeData = this.getTypeData(expression, returnType, !returnType);
        if (typeData != null) {
            return typeData.getExpectation().getExpectedType();
        }
        return null;
    }

    @Override
    public final List<LightweightTypeReference> getActualTypeArguments(XExpression expression) {
        if (!this.shared.allLinking.contains(expression)) {
            return Collections.emptyList();
        }
        List<LightweightTypeReference> result = this.doGetActualTypeArguments(expression);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    protected List<LightweightTypeReference> doGetActualTypeArguments(XExpression expression) {
        if (expression == null || expression.eClass() == XbasePackage.Literals.XCLOSURE) {
            return Collections.emptyList();
        }
        ILinkingCandidate result = (ILinkingCandidate)this.basicGetLinkingMap().get(expression);
        if (result != null) {
            return result.getTypeArguments();
        }
        return Collections.emptyList();
    }

    public void setType(JvmIdentifiableElement identifiable, LightweightTypeReference reference) {
        LightweightTypeReference prev = this.ensureTypesMapExists().put(identifiable, reference);
        if (prev != null) {
            throw new IllegalStateException("identifiable [" + identifiable + "] was already typed as [" + prev.getIdentifier() + "]");
        }
    }

    public void reassignType(JvmIdentifiableElement identifiable, LightweightTypeReference reference) {
        if (reference != null) {
            LightweightTypeReference actualType = this.getActualType(identifiable);
            if (actualType != null) {
                if (actualType.getKind() == 6 && !((UnboundTypeReference)actualType).internalIsResolved()) {
                    UnboundTypeReference casted = (UnboundTypeReference)actualType;
                    List<LightweightBoundTypeArgument> hints = this.getHints(casted.getHandle());
                    boolean canAddHint = true;
                    for (int i = 0; i < hints.size() && canAddHint; ++i) {
                        LightweightBoundTypeArgument hint = hints.get(i);
                        if (hint.getTypeReference() != null && (hint.getSource() == BoundTypeArgumentSource.EXPECTATION || hint.getSource() == BoundTypeArgumentSource.INFERRED_CONSTRAINT)) continue;
                        canAddHint = false;
                    }
                    if (canAddHint) {
                        casted.acceptHint(reference, BoundTypeArgumentSource.EXPECTATION, identifiable, VarianceInfo.OUT, VarianceInfo.OUT);
                    }
                    this.ensureReassignedTypesMapExists().put(identifiable, reference);
                } else if (!reference.isAssignableFrom(actualType)) {
                    if (actualType.isAssignableFrom(reference)) {
                        this.ensureReassignedTypesMapExists().put(identifiable, reference);
                    } else {
                        CompoundTypeReference multiType = this.toMultiType(actualType, reference);
                        this.ensureReassignedTypesMapExists().put(identifiable, multiType);
                    }
                }
            } else {
                this.ensureReassignedTypesMapExists().put(identifiable, reference);
            }
        } else if (this.reassignedTypes != null) {
            this.reassignedTypes.remove(identifiable);
        }
    }

    protected CompoundTypeReference toMultiType(LightweightTypeReference first, LightweightTypeReference second) {
        if (first == null) {
            throw new NullPointerException("first may not be null");
        }
        if (second == null) {
            throw new NullPointerException("second may not be null");
        }
        final ITypeReferenceOwner owner = second.getOwner();
        final CompoundTypeReference result = owner.newCompoundTypeReference(false);
        TypeReferenceVisitor visitor = new TypeReferenceVisitor(){

            @Override
            protected void doVisitMultiTypeReference(CompoundTypeReference reference) {
                List<LightweightTypeReference> components = reference.getMultiTypeComponents();
                for (LightweightTypeReference component : components) {
                    result.addComponent(component.copyInto(owner));
                }
            }

            @Override
            protected void doVisitTypeReference(LightweightTypeReference reference) {
                result.addComponent(reference.copyInto(owner));
            }
        };
        first.accept(visitor);
        second.accept(visitor);
        return result;
    }

    protected boolean isRefinedType(JvmIdentifiableElement element) {
        if (this.reassignedTypes != null && this.reassignedTypes.get(element) != null) {
            return !(element instanceof JvmType);
        }
        return false;
    }

    public void reassignTypeWithoutMerge(JvmIdentifiableElement identifiable, LightweightTypeReference reference) {
        this.ensureReassignedTypesMapExists().put(identifiable, reference);
    }

    protected LightweightTypeReference acceptType(final XExpression expression, AbstractTypeExpectation expectation, LightweightTypeReference type, boolean returnType, int flags) {
        LightweightTypeReference actualType;
        ITypeReferenceOwner referenceOwner = this.getReferenceOwner();
        if (!type.isOwnedBy(referenceOwner)) {
            throw new IllegalArgumentException("type is associated with an incompatible owner");
        }
        if (!expectation.isOwnedBy(referenceOwner)) {
            throw new IllegalArgumentException("expected type is associated with an incompatible owner");
        }
        if (!type.hasTypeArguments()) {
            actualType = type.getUpperBoundSubstitute();
        } else {
            TypeParameterByUnboundSubstitutor substitutor = new TypeParameterByUnboundSubstitutor(Collections.emptyMap(), referenceOwner){

                @Override
                protected UnboundTypeReference createUnboundTypeReference(JvmTypeParameter type) {
                    if (expression instanceof XAbstractFeatureCall || expression instanceof XConstructorCall || expression instanceof XClosure) {
                        return ResolvedTypes.this.createUnboundTypeReference(expression, type);
                    }
                    return null;
                }
            };
            actualType = ((TypeParameterSubstitutor)substitutor).substitute(type).getUpperBoundSubstitute();
        }
        this.acceptType(expression, new TypeData(expression, expectation, actualType, flags, returnType));
        return actualType;
    }

    protected int getConformanceFlags(TypeData typeData, boolean recompute) {
        int flags = typeData.getConformanceFlags();
        if (recompute) {
            if ((flags & 0x200000) != 0) {
                ConformanceFlags.sanityCheck(flags);
                return flags;
            }
            flags &= 0xFFFBFDFF;
            flags |= 0x400000;
        }
        if ((flags & 0x400000) != 0) {
            LightweightTypeReference actualType = typeData.getActualType();
            ITypeExpectation expectation = typeData.getExpectation();
            LightweightTypeReference expectedType = expectation.getExpectedType();
            if (expectedType != null) {
                int conformanceResult = expectedType.getUpperBoundSubstitute().internalIsAssignableFrom(actualType, new TypeConformanceComputationArgument());
                flags |= conformanceResult | 0x100000;
                flags &= 0xFFBFFFFF;
            } else {
                flags &= 0xFFBFFFFF;
                flags |= 0x100200;
            }
        }
        ConformanceFlags.sanityCheck(flags);
        typeData.setConformanceFlags(flags);
        return flags;
    }

    protected void acceptType(XExpression expression, TypeData typeData) {
        Maps2.putIntoListMap(expression, typeData, this.ensureExpressionTypesMapExists());
    }

    protected Map<JvmIdentifiableElement, LightweightTypeReference> basicGetTypes() {
        return this.types != null ? this.types : Collections.emptyMap();
    }

    private Map<JvmIdentifiableElement, LightweightTypeReference> ensureTypesMapExists() {
        if (this.types == null) {
            this.types = new SharedKeysAwareMap<JvmIdentifiableElement, LightweightTypeReference>(this.shared.allTypes);
        }
        return this.types;
    }

    protected Map<JvmIdentifiableElement, LightweightTypeReference> basicGetReassignedTypes() {
        return this.reassignedTypes != null ? this.reassignedTypes : Collections.emptyMap();
    }

    private Map<JvmIdentifiableElement, LightweightTypeReference> ensureReassignedTypesMapExists() {
        if (this.reassignedTypes == null) {
            this.reassignedTypes = new SharedKeysAwareMap<JvmIdentifiableElement, LightweightTypeReference>(this.shared.allReassignedTypes);
        }
        return this.reassignedTypes;
    }

    protected Map<XExpression, List<TypeData>> basicGetExpressionTypes() {
        return this.expressionTypes != null ? this.expressionTypes : Collections.emptyMap();
    }

    private Map<XExpression, List<TypeData>> ensureExpressionTypesMapExists() {
        if (this.expressionTypes == null) {
            this.expressionTypes = new SharedKeysAwareMap<XExpression, List<TypeData>>(this.shared.allExpressionTypes);
        }
        return this.expressionTypes;
    }

    protected void refineExpectedType(XExpression receiver, ITypeExpectation refinedExpectation) {
        Collection typeData = this.ensureExpressionTypesMapExists().get(receiver);
        ArrayList replaced = Lists.newArrayListWithCapacity((int)typeData.size());
        for (TypeData existing : typeData) {
            TypeData newTypeData = new TypeData(receiver, refinedExpectation, existing.getActualType(), existing.getConformanceFlags(), existing.isReturnType());
            replaced.add(newTypeData);
        }
        this.ensureExpressionTypesMapExists().put(receiver, replaced);
    }

    protected Map<Object, List<LightweightBoundTypeArgument>> basicGetTypeParameterHints() {
        return this.typeParameterHints != null ? this.typeParameterHints : Collections.emptyMap();
    }

    private Map<Object, List<LightweightBoundTypeArgument>> ensureTypeParameterHintsMapExists() {
        if (this.typeParameterHints == null) {
            this.typeParameterHints = Maps.newHashMap();
        }
        return this.typeParameterHints;
    }

    private Map<XExpression, IApplicableCandidate> ensureLinkingMapExists() {
        if (this.linkingMap == null) {
            this.linkingMap = new SharedKeysAwareMap<XExpression, IApplicableCandidate>(this.shared.allLinking);
        }
        return this.linkingMap;
    }

    protected Map<XExpression, IApplicableCandidate> basicGetLinkingMap() {
        return this.linkingMap != null ? this.linkingMap : Collections.emptyMap();
    }

    @Override
    public Collection<ILinkingCandidate> getFollowUpErrors() {
        Collection rawResult;
        Collection result = rawResult = Collections2.filter(this.basicGetLinkingMap().values(), (Predicate)new Predicate<IApplicableCandidate>(){

            public boolean apply(IApplicableCandidate input) {
                if (input == null) {
                    throw new IllegalArgumentException();
                }
                return input instanceof FollowUpError;
            }
        });
        return result;
    }

    @Override
    public Collection<IAmbiguousLinkingCandidate> getAmbiguousLinkingCandidates() {
        Collection rawResult;
        Collection result = rawResult = Collections2.filter(this.basicGetLinkingMap().values(), (Predicate)new Predicate<IApplicableCandidate>(){

            public boolean apply(IApplicableCandidate input) {
                if (input == null) {
                    throw new IllegalArgumentException();
                }
                return input instanceof IAmbiguousLinkingCandidate;
            }
        });
        return result;
    }

    @Override
    public LightweightTypeReference getActualType(JvmIdentifiableElement identifiable) {
        LightweightTypeReference result = this.doGetActualType(identifiable, false);
        return this.toOwnedReference(result);
    }

    protected final LightweightTypeReference doGetActualType(JvmIdentifiableElement identifiable, boolean ignoreReassignedTypes) {
        LightweightTypeReference result;
        if (ignoreReassignedTypes) {
            if (!this.shared.allTypes.contains(identifiable)) {
                return this.doGetDeclaredType(identifiable);
            }
        } else if (!this.shared.allReassignedTypes.contains(identifiable) && !this.shared.allTypes.contains(identifiable)) {
            int prevSize = this.shared.allReassignedTypes.size();
            LightweightTypeReference result2 = this.doGetDeclaredType(identifiable);
            if (prevSize == this.shared.allReassignedTypes.size() || !this.shared.allReassignedTypes.contains(identifiable)) {
                return result2;
            }
        }
        if ((result = this.doGetActualTypeNoDeclaration(identifiable, ignoreReassignedTypes)) == null) {
            return this.doGetDeclaredType(identifiable);
        }
        return result;
    }

    protected LightweightTypeReference doGetActualTypeNoDeclaration(JvmIdentifiableElement identifiable, boolean ignoreReassignedTypes) {
        LightweightTypeReference result;
        if (this.reassignedTypes != null && !ignoreReassignedTypes && (result = this.reassignedTypes.get(identifiable)) != null) {
            return result;
        }
        result = this.basicGetTypes().get(identifiable);
        return result;
    }

    protected LightweightTypeReference doGetDeclaredType(JvmIdentifiableElement identifiable) {
        if (identifiable instanceof JvmType) {
            ITypeReferenceOwner owner = this.getReferenceOwner();
            LightweightTypeReference result = owner.toLightweightTypeReference((JvmType)identifiable);
            return result;
        }
        JvmTypeReference type = this.getDeclaredType(identifiable);
        if (type != null) {
            ITypeReferenceOwner owner = this.getReferenceOwner();
            LightweightTypeReference result = owner.toLightweightTypeReference(type);
            return result;
        }
        return null;
    }

    protected JvmTypeReference getDeclaredType(JvmIdentifiableElement identifiable) {
        if (identifiable instanceof JvmOperation) {
            return ((JvmOperation)identifiable).getReturnType();
        }
        if (identifiable instanceof JvmField) {
            return ((JvmField)identifiable).getType();
        }
        if (identifiable instanceof JvmConstructor) {
            return this.shared.resolver.getServices().getTypeReferences().createTypeRef((JvmType)((JvmConstructor)identifiable).getDeclaringType(), new JvmTypeReference[0]);
        }
        if (identifiable instanceof JvmFormalParameter) {
            JvmTypeReference parameterType = ((JvmFormalParameter)identifiable).getParameterType();
            return parameterType;
        }
        return null;
    }

    public final IFeatureLinkingCandidate getFeature(XAbstractFeatureCall featureCall) {
        if (!this.shared.allLinking.contains(featureCall)) {
            return null;
        }
        return this.doGetFeature(featureCall);
    }

    protected IFeatureLinkingCandidate doGetFeature(XAbstractFeatureCall featureCall) {
        return (IFeatureLinkingCandidate)this.basicGetLinkingMap().get(featureCall);
    }

    public final IConstructorLinkingCandidate getConstructor(XConstructorCall constructorCall) {
        if (!this.shared.allLinking.contains(constructorCall)) {
            return null;
        }
        return this.doGetConstructor(constructorCall);
    }

    protected IConstructorLinkingCandidate doGetConstructor(XConstructorCall constructorCall) {
        return (IConstructorLinkingCandidate)this.basicGetLinkingMap().get(constructorCall);
    }

    protected void acceptCandidate(XExpression expression, IApplicableCandidate candidate) {
        IApplicableCandidate prev = this.ensureLinkingMapExists().put(expression, candidate);
        if (prev != null) {
            throw new IllegalStateException("Expression " + expression + " was already linked to: " + prev + "\nCannot relink to: " + candidate);
        }
    }

    void reassignLinkingInformation(XExpression expression, IApplicableCandidate candidate) {
        IApplicableCandidate prev = this.ensureLinkingMapExists().put(expression, candidate);
        if (prev == null) {
            throw new IllegalStateException("Expression " + expression + " was never linked, cannot replace linking information");
        }
    }

    protected DefaultReentrantTypeResolver getResolver() {
        return this.shared.resolver;
    }

    protected UnboundTypeReference getUnboundTypeReference(Object handle) {
        UnboundTypeReference result = this.basicGetTypeParameters().get(handle);
        if (result == null) {
            throw new IllegalStateException("Could not find type parameter");
        }
        if (result.internalIsResolved()) {
            throw new IllegalStateException("Cannot query unbount type reference that was already resolved");
        }
        return result;
    }

    protected UnboundTypeReference createUnboundTypeReference(XExpression expression, JvmTypeParameter type) {
        UnboundTypeReference result = new UnboundTypeReference(this.getReferenceOwner(), expression, type){};
        this.acceptUnboundTypeReference(result.getHandle(), result);
        return result;
    }

    protected void acceptUnboundTypeReference(Object handle, UnboundTypeReference reference) {
        this.ensureTypeParameterMapExists().put(handle, reference);
    }

    protected Map<Object, UnboundTypeReference> basicGetTypeParameters() {
        return this.unboundTypeParameters != null ? this.unboundTypeParameters : Collections.emptyMap();
    }

    private Map<Object, UnboundTypeReference> ensureTypeParameterMapExists() {
        if (this.unboundTypeParameters == null) {
            this.unboundTypeParameters = Maps.newLinkedHashMap();
        }
        return this.unboundTypeParameters;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append(": [");
        this.appendContent(result, "  ");
        this.closeBracket(result, "");
        return result.toString();
    }

    protected void closeBracket(StringBuilder result, String indentation) {
        if (result.charAt(result.length() - 1) != '[') {
            result.append('\n').append(indentation).append("]");
        } else {
            result.append("]");
        }
    }

    protected void appendContent(StringBuilder result, String indentation) {
        this.appendContent(this.types, "types", result, indentation);
        this.appendContent(this.reassignedTypes, "reassignedTypes", result, indentation);
        this.appendListMapContent(this.expressionTypes, "expressionTypes", result, indentation);
        this.appendContent(this.linkingMap, "featureLinking", result, indentation);
        this.appendContent(this.unboundTypeParameters, "unboundTypeParameters", result, indentation);
        this.appendListMapContent(this.typeParameterHints, "typeParameterHints", result, indentation);
        this.appendContent(this.declaredTypeParameters, "declaredTypeParameters", result, indentation);
        this.appendContent(this.diagnostics, "diagnostics", result, indentation);
        this.appendContent(this.deferredLogic, "runnables", result, indentation);
        this.appendContent(this.propagatedTypes, "propagatedTypes", result, indentation);
    }

    protected void appendContent(Map<?, ?> map, String prefix, StringBuilder result, String indentation) {
        if (map != null) {
            Joiner.MapJoiner joiner = Joiner.on((String)("\n  " + indentation)).withKeyValueSeparator(" -> ");
            result.append("\n").append(indentation).append(prefix).append(":\n").append(indentation).append("  ");
            joiner.appendTo(result, map);
        }
    }

    protected void appendContent(Collection<?> values, String prefix, StringBuilder result, String indentation) {
        if (values != null) {
            Joiner joiner = Joiner.on((String)("\n  " + indentation));
            result.append("\n").append(indentation).append(prefix).append(":\n").append(indentation).append("  ");
            joiner.appendTo(result, values);
        }
    }

    protected void appendListMapContent(Map<?, ? extends Collection<?>> map, String prefix, StringBuilder result, String indentation) {
        if (map != null) {
            MultimapJoiner joiner = new MultimapJoiner(Joiner.on((String)("\n    " + indentation)), "\n  " + indentation, " ->\n" + indentation + "    ");
            result.append("\n").append(indentation).append(prefix).append(":\n").append(indentation).append("  ");
            joiner.appendTo(result, map);
        }
    }

    public void acceptHint(Object handle, LightweightBoundTypeArgument boundTypeArgument) {
        if (boundTypeArgument.getSource() == BoundTypeArgumentSource.RESOLVED) {
            if (this.resolvedTypeParameters == null) {
                this.resolvedTypeParameters = new SharedKeysAwareSet<Object>(this.shared.allResolvedTypeParameters);
            }
            if (this.resolvedTypeParameters.add(handle)) {
                if (boundTypeArgument.getDeclaredVariance().mergeDeclaredWithActual(boundTypeArgument.getActualVariance()) == VarianceInfo.INVARIANT) {
                    this.resolveDependentTypeArguments(handle, boundTypeArgument);
                }
                LightweightBoundTypeArgument boundWithoutRecursion = this.removeRecursiveTypeArguments(handle, boundTypeArgument);
                this.ensureTypeParameterHintsMapExists().put(handle, Collections.singletonList(boundWithoutRecursion));
            }
        } else if (!this.isResolved(handle)) {
            if (boundTypeArgument.getTypeReference() instanceof UnboundTypeReference && boundTypeArgument.getSource() != BoundTypeArgumentSource.CONSTRAINT) {
                UnboundTypeReference other = (UnboundTypeReference)boundTypeArgument.getTypeReference();
                Object otherHandle = other.getHandle();
                if (this.ensureTypeParameterHintsMapExists().containsKey(handle)) {
                    List<LightweightBoundTypeArgument> existingValues = this.ensureTypeParameterHintsMapExists().get(handle);
                    for (LightweightBoundTypeArgument existingValue : existingValues) {
                        if (!(existingValue.getTypeReference() instanceof UnboundTypeReference) || ((UnboundTypeReference)existingValue.getTypeReference()).getHandle() != otherHandle || existingValue.getActualVariance() != boundTypeArgument.getActualVariance() || existingValue.getDeclaredVariance() != boundTypeArgument.getDeclaredVariance() || existingValue.getSource() != boundTypeArgument.getSource()) continue;
                        return;
                    }
                }
                UnboundTypeReference currentUnbound = this.getUnboundTypeReference(handle);
                Maps2.putIntoListMap(otherHandle, this.copyBoundTypeArgument(currentUnbound, boundTypeArgument), this.ensureTypeParameterHintsMapExists());
            }
            Maps2.putIntoListMap(handle, boundTypeArgument, this.ensureTypeParameterHintsMapExists());
        } else {
            throw new IllegalStateException("Cannot add hints if the reference was already resolved");
        }
    }

    protected LightweightBoundTypeArgument copyBoundTypeArgument(LightweightTypeReference typeReference, LightweightBoundTypeArgument boundTypeArgument) {
        return new LightweightBoundTypeArgument(typeReference, boundTypeArgument.getSource(), boundTypeArgument.getOrigin(), boundTypeArgument.getDeclaredVariance(), boundTypeArgument.getActualVariance());
    }

    protected LightweightBoundTypeArgument removeRecursiveTypeArguments(final Object handle, LightweightBoundTypeArgument boundTypeArgument) {
        final HashSet handles = Sets.newHashSet((Object[])new Object[]{handle});
        LightweightTypeReference boundArgumentWithoutRecursion = new CustomTypeParameterSubstitutor(Collections.emptyMap(), boundTypeArgument.getTypeReference().getOwner()){

            @Override
            protected LightweightTypeReference visitTypeArgument(LightweightTypeReference reference, ConstraintVisitingInfo visiting, boolean lowerBound) {
                if (reference.getKind() == 6 && handle.equals(((UnboundTypeReference)reference).getHandle())) {
                    return this.doVisitUnboundTypeReference((UnboundTypeReference)reference, visiting);
                }
                return super.visitTypeArgument(reference, visiting, lowerBound);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected LightweightTypeReference doVisitUnboundTypeReference(UnboundTypeReference reference, ConstraintVisitingInfo visiting) {
                if (!handle.equals(reference.getHandle())) {
                    return reference;
                }
                JvmTypeParameter typeParameter = reference.getTypeParameter();
                if (!visiting.tryVisit(typeParameter)) {
                    LightweightTypeReference mappedReference = this.getDeclaredUpperBound(typeParameter, visiting);
                    this.getTypeParameterMapping().put(typeParameter, new LightweightMergedBoundTypeArgument(mappedReference, VarianceInfo.INVARIANT));
                    if (mappedReference != null) {
                        return mappedReference;
                    }
                    return this.getObjectReference();
                }
                try {
                    LightweightMergedBoundTypeArgument boundTypeArgument = this.getTypeParameterMapping().get(typeParameter);
                    if (boundTypeArgument != null && boundTypeArgument.getTypeReference() != reference) {
                        LightweightTypeReference result;
                        LightweightTypeReference lightweightTypeReference = result = boundTypeArgument.getTypeReference().accept(this, visiting);
                        return lightweightTypeReference;
                    }
                    LightweightTypeReference mappedReference = this.getDeclaredUpperBound(visiting.getCurrentDeclarator(), visiting.getCurrentIndex(), visiting);
                    this.getTypeParameterMapping().put(typeParameter, new LightweightMergedBoundTypeArgument(mappedReference, VarianceInfo.INVARIANT));
                    LightweightTypeReference lightweightTypeReference = mappedReference;
                    return lightweightTypeReference;
                }
                finally {
                    visiting.didVisit(typeParameter);
                }
            }

            @Override
            protected LightweightTypeReference doVisitWildcardTypeReference(WildcardTypeReference reference, ConstraintVisitingInfo visiting) {
                if (reference.isResolved() && reference.isOwnedBy(this.getOwner())) {
                    return reference;
                }
                LightweightTypeReference lowerBound = reference.getLowerBound();
                if (lowerBound instanceof UnboundTypeReference && !handles.add(((UnboundTypeReference)lowerBound).getHandle())) {
                    WildcardTypeReference result = this.getOwner().newWildcardTypeReference();
                    for (LightweightTypeReference upperBound : reference.getUpperBounds()) {
                        result.addUpperBound(this.visitTypeArgument(upperBound, visiting));
                    }
                    return result;
                }
                return super.doVisitWildcardTypeReference(reference, visiting);
            }

            @Override
            protected LightweightTypeReference getUnmappedSubstitute(ParameterizedTypeReference reference, JvmTypeParameter type, ConstraintVisitingInfo visiting) {
                return reference;
            }
        }.substitute(boundTypeArgument.getTypeReference());
        LightweightBoundTypeArgument boundWithoutRecursion = this.copyBoundTypeArgument(boundArgumentWithoutRecursion, boundTypeArgument);
        return boundWithoutRecursion;
    }

    protected void resolveDependentTypeArguments(Object handle, LightweightBoundTypeArgument boundTypeArgument) {
        List<LightweightBoundTypeArgument> existingTypeArguments = this.ensureTypeParameterHintsMapExists().get(handle);
        if (existingTypeArguments != null) {
            for (int i = 0; i < existingTypeArguments.size(); ++i) {
                UnboundTypeReference existingReference;
                LightweightBoundTypeArgument existingTypeArgument = existingTypeArguments.get(i);
                BoundTypeArgumentSource source = existingTypeArgument.getSource();
                LightweightTypeReference existingTypeReference = existingTypeArgument.getTypeReference();
                LightweightTypeReference boundTypeReference = boundTypeArgument.getTypeReference();
                if (source == BoundTypeArgumentSource.INFERRED || source == BoundTypeArgumentSource.INFERRED_EXPECTATION) {
                    if (existingTypeReference instanceof UnboundTypeReference) {
                        existingReference = (UnboundTypeReference)existingTypeReference;
                        if (existingTypeArgument.getDeclaredVariance() != existingTypeArgument.getActualVariance()) continue;
                        this.acceptHint(existingReference.getHandle(), boundTypeArgument);
                        continue;
                    }
                    if (existingTypeReference == null || existingTypeReference == boundTypeReference || existingTypeReference.isResolved()) continue;
                    ExpectationTypeParameterHintCollector collector = new ExpectationTypeParameterHintCollector(this.getReferenceOwner());
                    collector.processPairedReferences(boundTypeReference, existingTypeReference);
                    continue;
                }
                if (source == BoundTypeArgumentSource.CONSTRAINT) {
                    if (!(existingTypeReference instanceof UnboundTypeReference) || (existingReference = (UnboundTypeReference)existingTypeReference).internalIsResolved()) continue;
                    existingReference.acceptHint(boundTypeReference, BoundTypeArgumentSource.INFERRED, boundTypeArgument, VarianceInfo.OUT, VarianceInfo.OUT);
                    continue;
                }
                if (source == BoundTypeArgumentSource.INFERRED_CONSTRAINT) {
                    if (!(existingTypeReference instanceof UnboundTypeReference) || this.isResolved((existingReference = (UnboundTypeReference)existingTypeReference).getHandle()) || boundTypeReference.isWildcard()) continue;
                    existingReference.acceptHint(boundTypeReference, BoundTypeArgumentSource.INFERRED, boundTypeArgument, VarianceInfo.OUT, VarianceInfo.OUT);
                    continue;
                }
                if (source != BoundTypeArgumentSource.INFERRED_LATER || !(existingTypeReference instanceof UnboundTypeReference) || this.isResolved((existingReference = (UnboundTypeReference)existingTypeReference).getHandle()) || !boundTypeReference.isWildcard() || existingTypeArgument.getActualVariance() != VarianceInfo.INVARIANT || existingTypeArgument.getDeclaredVariance() != VarianceInfo.OUT) continue;
                existingReference.acceptHint(boundTypeReference.getInvariantBoundSubstitute(), BoundTypeArgumentSource.INFERRED, boundTypeArgument, VarianceInfo.OUT, VarianceInfo.OUT);
            }
        }
    }

    public final boolean isResolved(Object handle) {
        return this.shared.allResolvedTypeParameters.contains(handle) && this.doIsResolved(handle);
    }

    protected boolean doIsResolved(Object handle) {
        return this.resolvedTypeParameters != null && this.resolvedTypeParameters.contains(handle);
    }

    protected boolean isPropagatedType(XExpression expression) {
        return this.propagatedTypes != null && this.propagatedTypes.contains(expression);
    }

    @Override
    public boolean isRefinedType(XExpression expression) {
        return this.refinedTypes != null && this.refinedTypes.contains(expression);
    }

    protected void setPropagatedType(XExpression expression) {
        if (this.propagatedTypes == null) {
            this.propagatedTypes = Sets.newHashSet((Object[])new XExpression[]{expression});
        } else {
            this.propagatedTypes.add(expression);
        }
    }

    protected void setRefinedType(XExpression expression) {
        if (this.refinedTypes == null) {
            this.refinedTypes = Sets.newHashSet((Object[])new XExpression[]{expression});
        } else {
            this.refinedTypes.add(expression);
        }
    }

    protected Set<XExpression> basicGetPropagatedTypes() {
        return this.propagatedTypes != null ? this.propagatedTypes : Collections.emptySet();
    }

    protected Set<XExpression> basicGetRefinedTypes() {
        return this.refinedTypes != null ? this.refinedTypes : Collections.emptySet();
    }

    protected List<JvmTypeParameter> basicGetDeclardTypeParameters() {
        return this.declaredTypeParameters;
    }

    public List<JvmTypeParameter> getDeclaredTypeParameters() {
        return this.declaredTypeParameters != null ? this.declaredTypeParameters : Collections.emptyList();
    }

    public void addDeclaredTypeParameters(List<JvmTypeParameter> typeParameters) {
        if (this.declaredTypeParameters == null) {
            this.declaredTypeParameters = Lists.newArrayList(typeParameters);
        } else {
            this.declaredTypeParameters.addAll(typeParameters);
        }
    }

    protected List<LightweightTypeReference> getExpectedExceptions() {
        return Collections.emptyList();
    }

    public List<LightweightBoundTypeArgument> getAllHints(Object handle) {
        LightweightBoundTypeArgument hint;
        int i;
        List<LightweightBoundTypeArgument> actualHints = this.getHints(handle);
        for (i = 0; i < actualHints.size() && !((hint = actualHints.get(i)).getTypeReference() instanceof UnboundTypeReference); ++i) {
        }
        if (i >= actualHints.size()) {
            return actualHints;
        }
        ArrayList transitivity = Lists.newArrayList();
        HashSet seenHandles = Sets.newHashSet((Object[])new Object[]{handle});
        transitivity.addAll(actualHints.subList(0, i));
        List<LightweightBoundTypeArgument> allRemaining = actualHints.subList(i, actualHints.size());
        this.addNonRecursiveHints(allRemaining, seenHandles, transitivity);
        return transitivity;
    }

    protected List<LightweightBoundTypeArgument> getHints(Object handle) {
        List<LightweightBoundTypeArgument> result = this.basicGetTypeParameterHints().get(handle);
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    protected void addNonRecursiveHints(List<LightweightBoundTypeArgument> hints, Set<Object> seenHandles, List<LightweightBoundTypeArgument> result) {
        for (LightweightBoundTypeArgument hint : hints) {
            LightweightTypeReference reference = hint.getTypeReference();
            if (reference instanceof UnboundTypeReference) {
                this.addNonRecursiveHints(hint, (UnboundTypeReference)reference, seenHandles, result);
                continue;
            }
            if (result.contains(hint)) continue;
            result.add(hint);
        }
    }

    protected void addNonRecursiveHints(LightweightBoundTypeArgument original, List<LightweightBoundTypeArgument> hints, Set<Object> seenHandles, List<LightweightBoundTypeArgument> result) {
        for (LightweightBoundTypeArgument hint : hints) {
            LightweightTypeReference reference = hint.getTypeReference();
            if (reference instanceof UnboundTypeReference) {
                this.addNonRecursiveHints(original, (UnboundTypeReference)reference, seenHandles, result);
                continue;
            }
            if (original.getDeclaredVariance() == VarianceInfo.IN && hint.getTypeReference() instanceof WildcardTypeReference) {
                LightweightTypeReference upperBound = hint.getTypeReference().getUpperBoundSubstitute();
                if (upperBound instanceof UnboundTypeReference) {
                    this.addNonRecursiveHints(original, (UnboundTypeReference)upperBound, seenHandles, result);
                    continue;
                }
                LightweightBoundTypeArgument delegateHint = new LightweightBoundTypeArgument(upperBound, original.getSource(), hint.getOrigin(), hint.getDeclaredVariance(), original.getActualVariance());
                result.add(delegateHint);
                continue;
            }
            if (!result.isEmpty()) {
                if (original.getDeclaredVariance() == VarianceInfo.OUT && original.getActualVariance() == VarianceInfo.INVARIANT && hint.getDeclaredVariance() == VarianceInfo.OUT && hint.getActualVariance() == VarianceInfo.INVARIANT || result.contains(hint)) continue;
                result.add(hint);
                continue;
            }
            result.add(hint);
        }
    }

    protected void addNonRecursiveHints(LightweightBoundTypeArgument original, UnboundTypeReference reference, Set<Object> seenHandles, List<LightweightBoundTypeArgument> result) {
        Object otherHandle = reference.getHandle();
        if (seenHandles.add(otherHandle)) {
            if (this.isResolved(otherHandle)) {
                result.addAll(this.getHints(otherHandle));
            } else {
                this.addNonRecursiveHints(original, this.getHints(otherHandle), seenHandles, result);
            }
        }
    }

    protected StackedResolvedTypes pushTypes() {
        return new StackedResolvedTypes(this);
    }

    protected ExpressionAwareStackedResolvedTypes pushTypes(XExpression context) {
        ExpressionAwareStackedResolvedTypes result = new ExpressionAwareStackedResolvedTypes(this, context);
        return result;
    }

    protected StackedResolvedTypes pushReassigningTypes() {
        return new ReassigningStackedResolvedTypes(this);
    }

    protected abstract void markToBeInferred(XExpression var1);

    protected void addExpressionScope(EObject context, IFeatureScopeSession session, IExpressionScope.Anchor anchor) {
        this.getFeatureScopeTracker().addExpressionScope(this, context, session, anchor);
    }

    protected void replacePreviousExpressionScope(EObject context, IFeatureScopeSession session, IExpressionScope.Anchor anchor) {
        this.getFeatureScopeTracker().replacePreviousExpressionScope(context, session, anchor);
    }

    @Override
    public IExpressionScope getExpressionScope(EObject context, IExpressionScope.Anchor anchor) {
        return this.getFeatureScopeTracker().getExpressionScope(context, anchor);
    }

    @Override
    public boolean hasExpressionScope(EObject context, IExpressionScope.Anchor anchor) {
        return this.getFeatureScopeTracker().hasExpressionScope(context, anchor);
    }

    protected IResolvedTypes withFlattenedReassignedTypes() {
        final Map<JvmIdentifiableElement, LightweightTypeReference> flattened = this.getFlattenedReassignedTypes();
        if (flattened != null) {
            return new ForwardingResolvedTypes(){

                @Override
                public LightweightTypeReference getActualType(JvmIdentifiableElement identifiable) {
                    LightweightTypeReference reassigned = (LightweightTypeReference)flattened.get(identifiable);
                    if (reassigned != null) {
                        return reassigned;
                    }
                    return super.getActualType(identifiable);
                }

                @Override
                protected IResolvedTypes delegate() {
                    return ResolvedTypes.this;
                }
            };
        }
        return this;
    }

    protected Map<JvmIdentifiableElement, LightweightTypeReference> getFlattenedReassignedTypes() {
        if (this.reassignedTypes == null || this.reassignedTypes.isEmpty()) {
            return null;
        }
        if (this.reassignedTypes.size() == 1) {
            Map.Entry<JvmIdentifiableElement, LightweightTypeReference> singleEntry = this.reassignedTypes.entrySet().iterator().next();
            return Collections.singletonMap(singleEntry.getKey(), singleEntry.getValue());
        }
        return new HashMap<JvmIdentifiableElement, LightweightTypeReference>(this.reassignedTypes);
    }

    private static class MergeData {
        List<LightweightTypeReference> references = Lists.newArrayList();
        boolean voidSeen = false;
        ITypeExpectation expectation = null;
        boolean allNoImplicitReturn = true;
        boolean allThrownException = true;
        int mergedFlags = 0x2000000;

        private MergeData() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MergeData [");
            if (this.references != null) {
                builder.append("references=");
                builder.append(this.references);
                builder.append(", ");
            }
            builder.append("voidSeen=");
            builder.append(this.voidSeen);
            builder.append(", ");
            if (this.expectation != null) {
                builder.append("expectation=");
                builder.append(this.expectation);
                builder.append(", ");
            }
            builder.append("allNoImplicitReturn=");
            builder.append(this.allNoImplicitReturn);
            builder.append(", allThrownException=");
            builder.append(this.allThrownException);
            builder.append(", mergedFlags=");
            builder.append(ConformanceFlags.toString(this.mergedFlags));
            builder.append("]");
            return builder.toString();
        }
    }

    public static class Shared {
        final DefaultReentrantTypeResolver resolver;
        final CancelIndicator monitor;
        final IFeatureScopeTracker featureScopeTracker;
        final IssueSeverities issueSeverities;
        final Set<JvmIdentifiableElement> allTypes = Sets.newHashSet();
        final Set<JvmIdentifiableElement> allReassignedTypes = Sets.newHashSet();
        final Set<XExpression> allExpressionTypes = Sets.newHashSet();
        final Set<XExpression> allLinking = Sets.newHashSet();
        final Set<Object> allResolvedTypeParameters = Sets.newHashSet();
        ResolvedTypes root;

        public Shared(DefaultReentrantTypeResolver resolver, CancelIndicator monitor) {
            this.resolver = resolver;
            this.monitor = monitor;
            this.featureScopeTracker = resolver.createFeatureScopeTracker();
            this.issueSeverities = resolver.getIssueSeverities();
        }
    }

    protected class Owner
    extends StandardTypeReferenceOwner {
        public Owner(CommonTypeComputationServices services, ResourceSet context) {
            super(services, context);
        }

        @Override
        public void acceptHint(Object handle, LightweightBoundTypeArgument boundTypeArgument) {
            ResolvedTypes.this.acceptHint(handle, boundTypeArgument);
        }

        @Override
        public List<LightweightBoundTypeArgument> getAllHints(Object handle) {
            return ResolvedTypes.this.getAllHints(handle);
        }

        @Override
        public boolean isResolved(Object handle) {
            return ResolvedTypes.this.isResolved(handle);
        }

        @Override
        public List<JvmTypeParameter> getDeclaredTypeParameters() {
            return ResolvedTypes.this.getDeclaredTypeParameters();
        }

        public String toString() {
            return String.format("Owner: %s", ResolvedTypes.this);
        }
    }

    protected static class SharedKeysAwareSet<E>
    extends HashSet<E> {
        private static final long serialVersionUID = 1L;
        private final Set<E> sharedKeys;

        public SharedKeysAwareSet(Set<E> sharedItems) {
            this.sharedKeys = sharedItems;
        }

        @Override
        public boolean add(E e) {
            this.sharedKeys.add(e);
            return super.add(e);
        }
    }

    protected static class SharedKeysAwareMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final Set<K> sharedKeys;

        public SharedKeysAwareMap(Set<K> sharedKeys) {
            this.sharedKeys = sharedKeys;
        }

        @Override
        public V put(K key, V value) {
            this.sharedKeys.add(key);
            return super.put(key, value);
        }
    }
}

