/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.dnd;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.dnd.EFXDragEvent;

public class EFXDnDAdapter {
    private final Node node;
    private boolean dragInProgress;
    private boolean dragStartSend;
    private boolean dragStartFlag;
    private BiFunction<EFXDnDAdapter, MouseEvent, Boolean> dragStartValidator;
    private BiConsumer<EFXDnDAdapter, EFXDragEvent> dragStartConsumer;
    private BiConsumer<EFXDnDAdapter, EFXDragEvent> dragDoneConsumer;
    private Node eventTarget;

    public EFXDnDAdapter(Node node, Node doneEventTarget) {
        this.node = node;
        this.eventTarget = doneEventTarget;
    }

    public void enable() {
        this.node.addEventHandler(MouseEvent.MOUSE_PRESSED, this::handleMousePressed);
        this.node.addEventHandler(MouseEvent.MOUSE_DRAGGED, this::handleMouseDragged);
        this.node.addEventHandler(MouseEvent.MOUSE_RELEASED, this::handleMouseReleased);
    }

    public void disable() {
        this.node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this::handleMousePressed);
        this.node.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this::handleMouseDragged);
        this.node.removeEventHandler(MouseEvent.MOUSE_RELEASED, this::handleMouseReleased);
    }

    public void setDragStartValidator(BiFunction<EFXDnDAdapter, MouseEvent, Boolean> dragStartValidator) {
        this.dragStartValidator = dragStartValidator;
    }

    public void setDragStartConsumer(BiConsumer<EFXDnDAdapter, EFXDragEvent> dragStartConsumer) {
        this.dragStartConsumer = dragStartConsumer;
    }

    public void setDragDoneConsumer(BiConsumer<EFXDnDAdapter, EFXDragEvent> dragDoneConsumer) {
        this.dragDoneConsumer = dragDoneConsumer;
    }

    private void handleMousePressed(MouseEvent e) {
        this.dragStartFlag = true;
    }

    private void handleMouseDragged(MouseEvent e) {
        if (!this.dragStartFlag) {
            return;
        }
        if (!(this.dragStartSend || this.dragStartValidator != null && Boolean.FALSE.equals(this.dragStartValidator.apply(this, e)))) {
            EFXDragEvent event = new EFXDragEvent(this.node, (EventTarget)this.node, EFXDragEvent.DRAG_START, e.getScreenX(), e.getScreenY(), false);
            Event.fireEvent((EventTarget)this.node, (Event)event);
            this.dragStartSend = true;
            boolean bl = this.dragInProgress = event.getDraggedContent() != null;
            if (this.dragInProgress && this.dragStartConsumer != null) {
                this.dragStartConsumer.accept(this, event);
            }
        }
        Node node = Util.findNode(this.node.getScene().getWindow(), e.getScreenX(), e.getScreenY());
        if (this.dragInProgress) {
            if (node != null) {
                Event.fireEvent((EventTarget)node, (Event)new EFXDragEvent(this.node, (EventTarget)node, EFXDragEvent.DRAG_OVER, e.getScreenX(), e.getScreenY(), false));
            } else {
                EFXDragEvent.updateFeedbackLocation(e.getScreenX(), e.getScreenY());
            }
        }
    }

    private void handleMouseReleased(MouseEvent e) {
        this.dragStartSend = false;
        this.dragStartFlag = false;
        if (this.dragInProgress) {
            EFXDragEvent event;
            Node node = Util.findNode(this.node.getScene().getWindow(), e.getScreenX(), e.getScreenY());
            boolean isComplete = false;
            if (node != null) {
                event = new EFXDragEvent(node, (EventTarget)node, EFXDragEvent.DRAG_DROPPED, e.getScreenX(), e.getScreenY(), false);
                Event.fireEvent((EventTarget)node, (Event)event);
                isComplete = event.isComplete();
            }
            event = new EFXDragEvent(this.eventTarget, (EventTarget)this.eventTarget, EFXDragEvent.DRAG_DONE, e.getScreenX(), e.getScreenY(), isComplete);
            Event.fireEvent((EventTarget)this.eventTarget, (Event)event);
            if (this.dragDoneConsumer != null) {
                this.dragDoneConsumer.accept(this, event);
            }
        }
        this.dragInProgress = false;
    }
}

