/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import org.eclipse.xtext.formatting2.IAutowrapFormatter;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.debug.HiddenRegionFormattingToString;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;

public class WhitespaceReplacer
implements ITextReplacer {
    private final IHiddenRegionFormatting formatting;
    private final ITextSegment region;

    public WhitespaceReplacer(ITextSegment whitespace, IHiddenRegionFormatting formatting) {
        this.region = whitespace;
        this.formatting = formatting;
    }

    protected int computeNewIndentation(ITextReplacerContext context) {
        Integer indentationIncrease = this.formatting.getIndentationIncrease();
        Integer indentationDecrease = this.formatting.getIndentationDecrease();
        int indenation = context.getIndentation();
        if (indentationIncrease != null) {
            indenation += indentationIncrease.intValue();
        }
        if (indentationDecrease != null) {
            indenation -= indentationDecrease.intValue();
        }
        if (indenation >= 0) {
            return indenation;
        }
        return 0;
    }

    protected int computeNewLineCount(ITextReplacerContext context) {
        Integer newLineDefault = this.formatting.getNewLineDefault();
        Integer newLineMin = this.formatting.getNewLineMin();
        Integer newLineMax = this.formatting.getNewLineMax();
        if (newLineMin != null || newLineDefault != null || newLineMax != null) {
            if (this.region instanceof IHiddenRegion && ((IHiddenRegion)this.region).isUndefined()) {
                if (newLineDefault != null) {
                    return newLineDefault;
                }
                if (newLineMin != null) {
                    return newLineMin;
                }
                if (newLineMax != null) {
                    return newLineMax;
                }
            } else {
                int lineCount = this.region.getLineCount() - 1;
                if (newLineMin != null && newLineMin > lineCount) {
                    lineCount = newLineMin;
                }
                if (newLineMax != null && newLineMax < lineCount) {
                    lineCount = newLineMax;
                }
                return lineCount;
            }
        }
        return 0;
    }

    @Override
    public ITextReplacerContext createReplacements(ITextReplacerContext context) {
        if (this.formatting.getAutowrap() != null && this.formatting.getAutowrap() >= 0) {
            context.setCanAutowrap(this.formatting.getAutowrap());
        }
        String space = this.formatting.getSpace();
        int trailingNewLinesOfPreviousRegion = this.trailingNewLinesOfPreviousRegion();
        int computedNewLineCount = this.computeNewLineCount(context);
        int newLineCount = Math.max(computedNewLineCount - trailingNewLinesOfPreviousRegion, 0);
        if (newLineCount == 0 && context.isAutowrap()) {
            IAutowrapFormatter onAutowrap = this.formatting.getOnAutowrap();
            if (onAutowrap != null) {
                onAutowrap.format(this.region, this.formatting, context.getDocument());
            }
            newLineCount = 1;
        }
        int indentationCount = this.computeNewIndentation(context);
        if (newLineCount == 0 && trailingNewLinesOfPreviousRegion == 0) {
            if (space != null) {
                context.addReplacement(this.region.replaceWith(space));
            }
        } else {
            boolean noIndentation = this.formatting.getNoIndentation() == Boolean.TRUE;
            String newLines = context.getNewLinesString(newLineCount);
            String indentation = noIndentation ? "" : context.getIndentationString(indentationCount);
            context.addReplacement(this.region.replaceWith(String.valueOf(newLines) + indentation));
        }
        return context.withIndentation(indentationCount);
    }

    public IHiddenRegionFormatting getFormatting() {
        return this.formatting;
    }

    @Override
    public ITextSegment getRegion() {
        return this.region;
    }

    public String toString() {
        return new HiddenRegionFormattingToString().apply(this.formatting);
    }

    protected int trailingNewLinesOfPreviousRegion() {
        int offset = this.region.getOffset();
        if (offset < 1) {
            return 0;
        }
        String previous = this.region.getTextRegionAccess().textForOffset(offset - 1, 1);
        if ("\n".equals(previous)) {
            return 1;
        }
        return 0;
    }
}

