/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.validation.AbstractInjectableValidator;

public class CompositeEValidator
implements EValidator {
    public static final String USE_EOBJECT_VALIDATOR = "org.eclipse.xtext.validation.CompositeEValidator.USE_EOBJECT_VALIDATOR";
    private List<EValidatorEqualitySupport> contents;
    private static final Logger logger = Logger.getLogger(CompositeEValidator.class);
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.validation.CompositeEValidator.USE_EOBJECT_VALIDATOR")
    private boolean useEObjectValidator = true;
    @Inject
    private Provider<EValidatorEqualitySupport> equalitySupportProvider;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    protected void initDefaults() {
        if (this.isUseEObjectValidator()) {
            this.addValidator((EValidator)new EObjectValidator(){

                public boolean validate_EveryProxyResolves(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                    return true;
                }

                public boolean validate_NoCircularContainment(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                    return true;
                }
            });
        }
    }

    public void addValidator(EValidator validator) {
        if (this == validator) {
            return;
        }
        if (validator instanceof CompositeEValidator) {
            CompositeEValidator other = (CompositeEValidator)validator;
            int i = 0;
            while (i < other.getContents().size()) {
                this.addValidator(other.getContents().get(i).delegate);
                ++i;
            }
        } else {
            EValidatorEqualitySupport equalitySupport = (EValidatorEqualitySupport)this.equalitySupportProvider.get();
            equalitySupport.setDelegate(validator);
            if (!this.getContents().contains(equalitySupport)) {
                this.getContents().add(equalitySupport);
            }
        }
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) throws OperationCanceledError {
        boolean result = true;
        int i = 0;
        while (i < this.getContents().size()) {
            EValidatorEqualitySupport val = this.getContents().get(i);
            try {
                result &= val.getDelegate().validate(eObject, diagnostics, context);
            }
            catch (Throwable e) {
                this.operationCanceledManager.propagateAsErrorIfCancelException(e);
                logger.error((Object)"Error executing EValidator", e);
                diagnostics.add(this.createExceptionDiagnostic("Error executing EValidator", eObject, e));
            }
            ++i;
        }
        return result;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) throws OperationCanceledError {
        boolean result = true;
        int i = 0;
        while (i < this.getContents().size()) {
            EValidatorEqualitySupport val = this.getContents().get(i);
            try {
                result &= val.getDelegate().validate(eClass, eObject, diagnostics, context);
            }
            catch (Throwable e) {
                this.operationCanceledManager.propagateAsErrorIfCancelException(e);
                logger.error((Object)"Error executing EValidator", e);
                diagnostics.add(this.createExceptionDiagnostic("Error executing EValidator", eClass, e));
            }
            ++i;
        }
        return result;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) throws OperationCanceledError {
        boolean result = true;
        int i = 0;
        while (i < this.getContents().size()) {
            EValidatorEqualitySupport val = this.getContents().get(i);
            try {
                result &= val.getDelegate().validate(eDataType, value, diagnostics, context);
            }
            catch (Throwable e) {
                this.operationCanceledManager.propagateAsErrorIfCancelException(e);
                logger.error((Object)"Error executing EValidator", e);
                diagnostics.add(this.createExceptionDiagnostic("Error executing EValidator", eDataType, e));
            }
            ++i;
        }
        return result;
    }

    private Diagnostic createExceptionDiagnostic(String message, Object source, Throwable t) {
        return new BasicDiagnostic(4, source.toString(), 0, message, new Object[]{t});
    }

    public boolean isUseEObjectValidator() {
        return this.useEObjectValidator;
    }

    public void setUseEObjectValidator(boolean useEObjectValidator) {
        this.useEObjectValidator = useEObjectValidator;
    }

    public List<EValidatorEqualitySupport> getContents() {
        if (this.contents == null) {
            this.contents = new ArrayList<EValidatorEqualitySupport>(4);
            this.initDefaults();
        }
        return this.contents;
    }

    public void setEqualitySupportProvider(Provider<EValidatorEqualitySupport> equalitySupportProvider) {
        this.equalitySupportProvider = equalitySupportProvider;
    }

    public Provider<EValidatorEqualitySupport> getEqualitySupportProvider() {
        return this.equalitySupportProvider;
    }

    public CompositeEValidator getCopyAndClearContents() {
        CompositeEValidator result = new CompositeEValidator();
        result.equalitySupportProvider = this.equalitySupportProvider;
        result.useEObjectValidator = this.useEObjectValidator;
        result.operationCanceledManager = this.operationCanceledManager;
        if (this.contents != null) {
            result.contents = Lists.newArrayList(this.contents);
            this.contents = null;
        }
        return result;
    }

    public static class EValidatorEqualitySupport {
        private EValidator delegate;

        public boolean equals(Object obj) {
            if (!(obj instanceof EValidatorEqualitySupport)) {
                return false;
            }
            EValidator otherDelegate = ((EValidatorEqualitySupport)obj).getDelegate();
            if (otherDelegate.getClass().equals(this.getDelegate().getClass())) {
                if (this.delegate instanceof AbstractInjectableValidator) {
                    AbstractInjectableValidator casted = (AbstractInjectableValidator)this.getDelegate();
                    AbstractInjectableValidator otherCasted = (AbstractInjectableValidator)otherDelegate;
                    if (casted.isLanguageSpecific() == otherCasted.isLanguageSpecific()) {
                        if (casted.isLanguageSpecific()) {
                            return Objects.equal((Object)casted.getLanguageName(), (Object)otherCasted.getLanguageName());
                        }
                        return true;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.getDelegate().getClass().getName().hashCode();
        }

        public void setDelegate(EValidator delegate) {
            this.delegate = delegate;
        }

        public EValidator getDelegate() {
            return this.delegate;
        }
    }
}

