/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.services.EclipseAdapter;
import org.eclipse.e4.core.services.adapter.Adapter;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.ILoggerProvider;
import org.eclipse.e4.core.services.translation.TranslationProviderFactory;
import org.eclipse.e4.core.services.translation.TranslationService;
import org.eclipse.e4.ui.internal.workbench.ActiveChildLookupFunction;
import org.eclipse.e4.ui.internal.workbench.ActivePartLookupFunction;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.ExceptionHandler;
import org.eclipse.e4.ui.internal.workbench.ModelServiceImpl;
import org.eclipse.e4.ui.internal.workbench.PlaceholderResolver;
import org.eclipse.e4.ui.internal.workbench.ReflectionContributionFactory;
import org.eclipse.e4.ui.internal.workbench.ResourceHandler;
import org.eclipse.e4.ui.internal.workbench.SelectionAggregator;
import org.eclipse.e4.ui.internal.workbench.SelectionServiceImpl;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IExceptionHandler;
import org.eclipse.e4.ui.workbench.IModelResourceHandler;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessAdditions;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessRemovals;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPlaceholderResolver;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ui.services.restart.LifecycleRV;
import org.eclipse.fx.ui.services.restart.RestartService;
import org.eclipse.fx.ui.services.startup.StartupProgressTrackerService;
import org.eclipse.fx.ui.services.sync.UISynchronize;
import org.eclipse.fx.ui.workbench.base.Util;
import org.eclipse.fx.ui.workbench.base.internal.Activator;
import org.eclipse.fx.ui.workbench.base.internal.LoggerProviderImpl;
import org.eclipse.fx.ui.workbench.base.restart.RestartPreferenceUtil;
import org.eclipse.fx.ui.workbench.base.restart.RestartServiceImpl;
import org.eclipse.fx.ui.workbench.services.EModelStylingService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.service.datalocation.Location;

public abstract class AbstractE4Application
implements IApplication {
    public static final String THEME_ID = "cssTheme";
    private static final String WORKSPACE_VERSION_KEY = "org.eclipse.core.runtime";
    private static final String WORKSPACE_VERSION_VALUE = "2";
    private static final String METADATA_FOLDER = ".metadata";
    private static final String VERSION_FILENAME = "version.ini";
    protected static final String EXIT_CODE = "e4.osgi.exit.code";
    Object lcManager;
    private IModelResourceHandler handler;
    private static Logger LOGGER = LoggerCreator.createLogger(AbstractE4Application.class);

    protected abstract @NonNull Realm createRealm(@NonNull IEclipseContext var1);

    protected abstract @NonNull IResourceUtilities<?> createResourceUtility(@NonNull IEclipseContext var1);

    protected abstract @NonNull String getDefaultPresentationEngineURI(@NonNull IEclipseContext var1);

    protected static String[] getApplicationArguments(IApplicationContext applicationContext) {
        return (String[])applicationContext.getArguments().get("application.args");
    }

    public @Nullable E4Workbench createE4Workbench(IApplicationContext applicationContext, IEclipseContext appContext) {
        ContextInjectionFactory.setDefault((IEclipseContext)appContext);
        appContext.set(Realm.class, (Object)this.createRealm(appContext));
        appContext.set(IApplicationContext.class, (Object)applicationContext);
        appContext.set(EModelStylingService.class, (Object)new EModelStylingService(){
            private static final String PREFIX = "efx_styleclass:";

            public void addStyles(MUIElement element, String ... tags) {
                List toAdd = Stream.of(tags).map(t -> PREFIX + t).filter(t -> !element.getTags().contains(t)).collect(Collectors.toList());
                element.getTags().addAll(toAdd);
            }

            public void removeStyles(MUIElement element, String ... tags) {
                List cssTags = Stream.of(tags).map(t -> PREFIX + t).collect(Collectors.toList());
                element.getTags().removeAll(cssTags);
            }

            public List<String> getStyles(MUIElement element) {
                return this.getStylesFromTags(element.getTags());
            }

            public List<String> getStylesFromTags(List<String> tags) {
                return tags.stream().filter(t -> t.startsWith(PREFIX)).map(t -> t.substring(PREFIX.length())).collect(Collectors.toList());
            }
        });
        appContext.set(IResourceUtilities.class, this.createResourceUtility(appContext));
        if (!appContext.containsKey("org.eclipse.e4.ui.workbench.modeling.EModelService")) {
            throw new IllegalStateException("Core services not available. Please make sure that a declarative service implementation (such as the bundle 'org.eclipse.equinox.ds') is available!");
        }
        StartupProgressTrackerService startupProgressTrackerService = (StartupProgressTrackerService)appContext.get(StartupProgressTrackerService.class);
        if (startupProgressTrackerService != null) {
            try {
                ContextInjectionFactory.inject((Object)startupProgressTrackerService, (IEclipseContext)appContext);
            }
            catch (Throwable t) {
                LOGGER.error("Could not fully initialize the startup tracker", t);
            }
            startupProgressTrackerService.stateReached((StartupProgressTrackerService.ProgressState)StartupProgressTrackerService.DefaultProgressState.DI_SYSTEM_INITIALIZED);
        }
        IContributionFactory factory = (IContributionFactory)appContext.get(IContributionFactory.class.getName());
        this.preLifecycle(appContext);
        LifecycleRV rv = LifecycleRV.CONTINUE;
        String lifeCycleURI = AbstractE4Application.getArgValue("lifeCycleURI", applicationContext, false);
        if (lifeCycleURI != null) {
            this.lcManager = factory.create(lifeCycleURI, appContext);
            if (this.lcManager != null) {
                rv = this.invokePostContextCreate(appContext);
            }
        }
        if (startupProgressTrackerService != null) {
            startupProgressTrackerService.stateReached((StartupProgressTrackerService.ProgressState)StartupProgressTrackerService.DefaultProgressState.POST_CONTEXT_LF_FINISHED);
        }
        switch (rv) {
            case RESTART_CLEAR_STATE: {
                RestartPreferenceUtil prefUtil = (RestartPreferenceUtil)ContextInjectionFactory.make(RestartPreferenceUtil.class, (IEclipseContext)appContext);
                prefUtil.setClearPersistedStateOnRestart(true);
            }
            case RESTART: {
                appContext.set(EXIT_CODE, (Object)IApplication.EXIT_RESTART);
            }
            case SHUTDOWN: {
                return null;
            }
            case CONTINUE: {
                break;
            }
        }
        String toolItemTimer = AbstractE4Application.getArgValue("efx_TOOLITEM_TIMER", applicationContext, false);
        if (toolItemTimer != null) {
            try {
                appContext.set("efx_TOOLITEM_TIMER", (Object)Long.valueOf(toolItemTimer));
            }
            catch (NumberFormatException e) {
                LOGGER.error("Unable to parse 'efx_TOOLITEM_TIMER' value '" + toolItemTimer + "'", (Throwable)e);
            }
        }
        MApplication appModel = this.loadApplicationModel(applicationContext, appContext);
        appModel.setContext(appContext);
        Util.setup((MContext)appModel, appContext);
        this.initializeServices(appModel);
        if (this.lcManager != null) {
            ContextInjectionFactory.invoke((Object)this.lcManager, ProcessAdditions.class, (IEclipseContext)appContext, null);
            ContextInjectionFactory.invoke((Object)this.lcManager, ProcessRemovals.class, (IEclipseContext)appContext, null);
        }
        IEclipseContext addonStaticContext = EclipseContextFactory.create();
        for (MAddon addon : appModel.getAddons()) {
            addonStaticContext.set(MAddon.class, (Object)addon);
            Object obj = factory.create(addon.getContributionURI(), appContext, addonStaticContext);
            addon.setObject(obj);
        }
        String xmiURI = AbstractE4Application.getArgValue("applicationXMI", applicationContext, false);
        appContext.set("applicationXMI", (Object)xmiURI);
        String themeId = AbstractE4Application.getArgValue(THEME_ID, applicationContext, false);
        appContext.set(THEME_ID, (Object)themeId);
        appContext.set("rendererFactoryUri", (Object)AbstractE4Application.getArgValue("rendererFactoryUri", applicationContext, false));
        String presentationURI = AbstractE4Application.getArgValue("presentationURI", applicationContext, false);
        if (presentationURI == null) {
            presentationURI = this.getDefaultPresentationEngineURI(appContext);
        }
        appContext.set("presentationURI", (Object)presentationURI);
        this.preCreateWorkbench(appContext);
        E4Workbench workbench = new E4Workbench((MApplicationElement)appModel, appContext);
        appContext.set(RestartService.class, (Object)((RestartService)ContextInjectionFactory.make(RestartServiceImpl.class, (IEclipseContext)appContext)));
        return workbench;
    }

    private LifecycleRV invokePostContextCreate(final IEclipseContext appContext) {
        UISynchronize uiSynchronize = (UISynchronize)appContext.get(UISynchronize.class);
        Object rv = uiSynchronize.syncExec((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ContextInjectionFactory.invoke((Object)AbstractE4Application.this.lcManager, PostContextCreate.class, (IEclipseContext)appContext, (Object)Boolean.TRUE);
            }
        }, null);
        if (rv == null) {
            return LifecycleRV.CONTINUE;
        }
        if (rv instanceof Boolean) {
            return (Boolean)rv != false ? LifecycleRV.CONTINUE : LifecycleRV.SHUTDOWN;
        }
        if (rv instanceof LifecycleRV) {
            return (LifecycleRV)rv;
        }
        LOGGER.warning("Unrecognised return value type from @PostContextCreate. The expected types are Boolean or LifecycleRV.");
        return LifecycleRV.CONTINUE;
    }

    public void saveModel() {
        try {
            this.handler.save();
        }
        catch (IOException e) {
            LOGGER.error("Unable to persist the model", (Throwable)e);
        }
    }

    protected @Nullable Object getLifecycleManager() {
        return this.lcManager;
    }

    protected void preLifecycle(IEclipseContext appContext) {
    }

    protected void preCreateWorkbench(IEclipseContext appContext) {
    }

    private MApplication loadApplicationModel(IApplicationContext appContext, IEclipseContext eclipseContext) {
        MApplication theApp = null;
        Location instanceLocation = Activator.getDefault().getInstanceLocation();
        String appModelPath = AbstractE4Application.getArgValue("applicationXMI", appContext, false, eclipseContext);
        Assert.isNotNull((Object)appModelPath, (String)"applicationXMI argument missing");
        URI initialWorkbenchDefinitionInstance = URI.createPlatformPluginURI((String)appModelPath, (boolean)true);
        eclipseContext.set("initialWorkbenchModelURI", (Object)initialWorkbenchDefinitionInstance);
        eclipseContext.set("instanceLocation", (Object)instanceLocation);
        String value = AbstractE4Application.getArgValue("persistState", appContext, false, eclipseContext);
        boolean saveAndRestore = value == null || Boolean.parseBoolean(value);
        eclipseContext.set("persistState", (Object)saveAndRestore);
        value = AbstractE4Application.getArgValue("clearPersistedState", appContext, true, eclipseContext);
        boolean clearPersistedState = value != null && Boolean.parseBoolean(value);
        RestartPreferenceUtil restartUtil = (RestartPreferenceUtil)ContextInjectionFactory.make(RestartPreferenceUtil.class, (IEclipseContext)eclipseContext);
        if (!clearPersistedState) {
            clearPersistedState = restartUtil.isClearPersistedStateOnRestart();
        }
        eclipseContext.set("clearPersistedState", (Object)clearPersistedState);
        String deltaRestoreKey = "deltaRestore";
        value = AbstractE4Application.getArgValue(deltaRestoreKey, appContext, false, eclipseContext);
        boolean deltaRestore = value == null || Boolean.parseBoolean(value);
        eclipseContext.set(deltaRestoreKey, (Object)deltaRestore);
        String resourceHandler = AbstractE4Application.getArgValue("modelResourceHandler", appContext, false, eclipseContext);
        if (resourceHandler == null) {
            resourceHandler = "bundleclass://org.eclipse.e4.ui.workbench/" + ResourceHandler.class.getName();
        }
        IContributionFactory factory = (IContributionFactory)eclipseContext.get(IContributionFactory.class);
        this.handler = (IModelResourceHandler)factory.create(resourceHandler, eclipseContext);
        Resource resource = this.handler.loadMostRecentModel();
        theApp = (MApplication)resource.getContents().get(0);
        restartUtil.setClearPersistedStateOnRestart(false);
        return theApp;
    }

    private static String getArgValue(String argName, IApplicationContext applicationContext, boolean singledCmdArgValue, IEclipseContext eclipseContext) {
        Object value = eclipseContext.get(argName);
        if (value != null) {
            return value.toString();
        }
        return AbstractE4Application.getArgValue(argName, applicationContext, singledCmdArgValue);
    }

    protected IEclipseContext createApplicationContext() {
        IEclipseContext serviceContext = E4Workbench.getServiceContext();
        IEclipseContext appContext = serviceContext.createChild("WorkbenchContext");
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        ReflectionContributionFactory contributionFactory = new ReflectionContributionFactory(registry);
        appContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        if (appContext.get(ILoggerProvider.class) == null) {
            serviceContext.set(ILoggerProvider.class, (Object)((ILoggerProvider)ContextInjectionFactory.make(LoggerProviderImpl.class, (IEclipseContext)serviceContext)));
        }
        appContext.set(org.eclipse.e4.core.services.log.Logger.class.getName(), (Object)((ILoggerProvider)serviceContext.get(ILoggerProvider.class)).getClassLogger(E4Workbench.class));
        appContext.set(EModelService.class, (Object)new ModelServiceImpl(appContext));
        appContext.set(EPlaceholderResolver.class, (Object)new PlaceholderResolver());
        appContext.set("org.eclipse.e4.core.locale", (Object)Locale.getDefault());
        TranslationService bundleTranslationProvider = TranslationProviderFactory.bundleTranslationService((IEclipseContext)appContext);
        appContext.set(TranslationService.class, (Object)bundleTranslationProvider);
        appContext.set(Adapter.class.getName(), ContextInjectionFactory.make(EclipseAdapter.class, (IEclipseContext)appContext));
        appContext.set("e4ActivePart", (Object)new ActivePartLookupFunction());
        appContext.set(IExceptionHandler.class.getName(), (Object)exceptionHandler);
        appContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        appContext.set("activeShell", (Object)new ActiveChildLookupFunction("activeShell", "localActiveShell"));
        appContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        appContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        return appContext;
    }

    protected void initializeServices(MApplication appModel) {
        IEclipseContext appContext = appModel.getContext();
        this.initializeApplicationServices(appContext);
        List windows = appModel.getChildren();
        for (MWindow childWindow : windows) {
            this.initializeWindowServices(childWindow);
        }
        ((EObject)appModel).eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeatureID(MApplication.class) != 16) {
                    return;
                }
                if (notification.getEventType() != 3) {
                    return;
                }
                MWindow childWindow = (MWindow)notification.getNewValue();
                AbstractE4Application.this.initializeWindowServices(childWindow);
            }
        });
    }

    protected void initializeApplicationServices(IEclipseContext appContext) {
        final IEclipseContext theContext = appContext;
        appContext.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                IEclipseContext activeChildContext = context.getActiveChild();
                if (activeChildContext != null) {
                    Object selection = activeChildContext.get("org.eclipse.ui.selection");
                    theContext.set("org.eclipse.ui.selection", selection);
                }
                return true;
            }
        });
        appContext.set(ESelectionService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return ContextInjectionFactory.make(SelectionServiceImpl.class, (IEclipseContext)context);
            }
        });
    }

    protected void initializeWindowServices(MWindow childWindow) {
        IEclipseContext windowContext = childWindow.getContext();
        this.initWindowContext(windowContext);
        ((EObject)childWindow).eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeatureID(MWindow.class) != 23) {
                    return;
                }
                IEclipseContext windowContext = (IEclipseContext)notification.getNewValue();
                AbstractE4Application.this.initWindowContext(windowContext);
            }
        });
    }

    protected void initWindowContext(IEclipseContext windowContext) {
        if (windowContext == null) {
            return;
        }
        SelectionAggregator selectionAggregator = (SelectionAggregator)ContextInjectionFactory.make(SelectionAggregator.class, (IEclipseContext)windowContext);
        windowContext.set(SelectionAggregator.class, (Object)selectionAggregator);
    }

    protected static @Nullable String getArgValue(String argName, IApplicationContext applicationContext, boolean singledCmdArgValue) {
        int i;
        if (argName == null || argName.length() == 0) {
            return null;
        }
        String[] args = AbstractE4Application.getApplicationArguments(applicationContext);
        if (singledCmdArgValue) {
            i = 0;
            while (i < args.length) {
                if (("-" + argName).equals(args[i])) {
                    return "true";
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < args.length) {
                if (("-" + argName).equals(args[i]) && i + 1 < args.length) {
                    return args[i + 1];
                }
                ++i;
            }
        }
        String brandingProperty = applicationContext.getBrandingProperty(argName);
        return brandingProperty == null ? System.getProperty(argName) : brandingProperty;
    }

    public boolean checkInstanceLocation(@Nullable Location instanceLocation, @NonNull IEclipseContext context) {
        if (instanceLocation == null && Boolean.FALSE.equals(context.get("persistState"))) {
            return true;
        }
        if (instanceLocation == null) {
            return false;
        }
        if (instanceLocation.isSet()) {
            block7: {
                if (!AbstractE4Application.checkValidWorkspace(instanceLocation.getURL())) {
                    return false;
                }
                if (!instanceLocation.lock()) break block7;
                AbstractE4Application.writeWorkspaceVersion();
                return true;
            }
            try {
                File workspaceDirectory = new File(instanceLocation.getURL().getFile());
                workspaceDirectory.exists();
            }
            catch (IOException e) {
                LOGGER.error("Could not create instance location", (Throwable)e);
            }
            return false;
        }
        return false;
    }

    private static boolean checkValidWorkspace(URL url) {
        if (url == null) {
            return false;
        }
        String version = AbstractE4Application.readWorkspaceVersion(url);
        if (version == null) {
            return true;
        }
        int ide_version = Integer.parseInt(WORKSPACE_VERSION_VALUE);
        int workspace_version = Integer.parseInt(version);
        if (workspace_version == ide_version) {
            return true;
        }
        return true;
    }

    private static String readWorkspaceVersion(URL workspace) {
        File versionFile = AbstractE4Application.getVersionFile(workspace, false);
        if (versionFile == null || !versionFile.exists()) {
            return null;
        }
        try {
            Properties props = new Properties();
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream is = new FileInputStream(versionFile);){
                props.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return props.getProperty(WORKSPACE_VERSION_KEY);
        }
        catch (IOException e) {
            LOGGER.error("Unable to create workspace", (Throwable)e);
            return null;
        }
    }

    private static File getVersionFile(URL workspaceUrl, boolean create) {
        File versionFile;
        block6: {
            File metaDir;
            block5: {
                if (workspaceUrl == null) {
                    return null;
                }
                try {
                    metaDir = new File(workspaceUrl.getPath(), METADATA_FOLDER);
                    if (metaDir.exists() || create && metaDir.mkdir()) break block5;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            versionFile = new File(metaDir, VERSION_FILENAME);
            if (versionFile.exists() || create && versionFile.createNewFile()) break block6;
            return null;
        }
        return versionFile;
    }

    private static void writeWorkspaceVersion() {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null || instanceLoc.isReadOnly()) {
            return;
        }
        File versionFile = AbstractE4Application.getVersionFile(instanceLoc.getURL(), true);
        if (versionFile == null) {
            return;
        }
        String versionLine = "org.eclipse.core.runtime=2";
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream output = new FileOutputStream(versionFile);){
                ((OutputStream)output).write(versionLine.getBytes("UTF-8"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to write workspace version", (Throwable)e);
        }
    }
}

