/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.contentassist;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.PopupWindow;
import org.eclipse.fx.core.Util;
import org.eclipse.fx.text.ui.ITextViewer;
import org.eclipse.fx.text.ui.contentassist.ContentAssistContextData;
import org.eclipse.fx.text.ui.contentassist.ICompletionProposal;
import org.eclipse.fx.ui.controls.list.SimpleListCell;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ContentProposalPopup {
    private ITextViewer viewer;
    private PopupWindow stage;
    private ListView<ICompletionProposal> proposalList;
    private String prefix;
    private int offset;
    private Function<ContentAssistContextData, List<ICompletionProposal>> proposalComputer;

    public ContentProposalPopup(ITextViewer viewer, Function<ContentAssistContextData, List<ICompletionProposal>> proposalComputer) {
        this.viewer = viewer;
        this.proposalComputer = proposalComputer;
    }

    public void displayProposals(List<ICompletionProposal> proposalList, int offset, Point2D position) {
        this.setup();
        this.prefix = "";
        this.offset = offset;
        this.proposalList.setItems(FXCollections.observableArrayList(proposalList));
        this.proposalList.getSelectionModel().select(0);
        this.stage.setX(position.getX());
        this.stage.setY(position.getY());
        this.stage.setWidth(300.0);
        this.stage.setHeight(200.0);
        this.stage.show(this.viewer.getTextWidget().getScene().getWindow());
        this.stage.requestFocus();
    }

    private void handleKeyTyped(KeyEvent event) {
        if (event.getCharacter().length() == 0) {
            return;
        }
        String character = event.getCharacter();
        if (character.length() == 0) {
            return;
        }
        if ((event.isControlDown() || event.isAltDown() || Util.isMacOS() && event.isMetaDown()) && (!event.isControlDown() && !Util.isMacOS() || !event.isAltDown())) {
            return;
        }
        if (character.charAt(0) > '\u001f' && character.charAt(0) != '\u007f') {
            this.prefix = String.valueOf(this.prefix) + character;
            this.offset += event.getCharacter().length();
            this.updateProposals();
        }
    }

    private void updateProposals() {
        List<ICompletionProposal> list = this.proposalComputer.apply(new ContentAssistContextData(this.offset, this.viewer.getDocument()));
        if (!list.isEmpty()) {
            this.proposalList.setItems(FXCollections.observableArrayList(list));
            this.proposalList.scrollTo(0);
            this.proposalList.getSelectionModel().select(0);
        } else {
            this.stage.hide();
        }
    }

    private void handleKeyPressed(KeyEvent event) {
        if (event.getCode() == KeyCode.ESCAPE) {
            event.consume();
            this.stage.hide();
        } else if (event.getCode() == KeyCode.BACK_SPACE) {
            event.consume();
            --this.offset;
            try {
                this.viewer.getDocument().replace(this.offset, 1, "");
                this.viewer.getTextWidget().setCaretOffset(this.offset);
                this.updateProposals();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else if (event.getCode() == KeyCode.ENTER) {
            event.consume();
            this.applySelection();
        } else if (event.getCode() == KeyCode.LEFT) {
            event.consume();
            --this.offset;
            this.offset = Math.max(0, this.offset);
            this.viewer.getTextWidget().setCaretOffset(this.offset);
            this.updateProposals();
        } else if (event.getCode() == KeyCode.RIGHT) {
            event.consume();
            ++this.offset;
            this.offset = Math.min(this.viewer.getDocument().getLength() - 1, this.offset);
            this.viewer.getTextWidget().setCaretOffset(this.offset);
            this.updateProposals();
        }
    }

    private void applySelection() {
        ICompletionProposal selectedItem = (ICompletionProposal)this.proposalList.getSelectionModel().getSelectedItem();
        if (selectedItem != null) {
            IDocument document = this.viewer.getDocument();
            selectedItem.apply(document);
            this.viewer.getTextWidget().setSelection(selectedItem.getSelection(document));
            this.stage.hide();
        }
    }

    private void setup() {
        if (this.stage == null) {
            this.stage = new PopupWindow(){};
            this.stage.setAutoFix(false);
            this.stage.setWidth(300.0);
            this.stage.setHeight(200.0);
            BorderPane p = new BorderPane();
            p.setPrefHeight(200.0);
            p.setPrefWidth(400.0);
            this.stage.getScene().addEventFilter(KeyEvent.KEY_TYPED, this::handleKeyTyped);
            this.stage.getScene().addEventFilter(KeyEvent.KEY_PRESSED, this::handleKeyPressed);
            this.stage.getScene().getStylesheets().addAll((Collection)this.viewer.getTextWidget().getScene().getStylesheets());
            this.proposalList = new ListView();
            this.proposalList.getStyleClass().add((Object)"content-proposal-list");
            this.proposalList.setOnMouseClicked(e -> {
                if (e.getClickCount() == 1) {
                    this.applySelection();
                }
            });
            Function<ICompletionProposal, CharSequence> label = c -> c.getLabel();
            Function<ICompletionProposal, Node> graphic = c -> c.getGraphic();
            Function<ICompletionProposal, List> css = c -> Collections.emptyList();
            this.proposalList.setCellFactory(v -> new SimpleListCell(label, graphic, css));
            p.setCenter(this.proposalList);
            this.stage.getScene().setRoot((Parent)p);
            this.stage.focusedProperty().addListener(o -> {
                if (this.stage != null && !this.stage.isFocused()) {
                    Platform.runLater(() -> ((PopupWindow)this.stage).hide());
                }
            });
            this.stage.setOnHidden(o -> {
                this.stage = null;
            });
        }
    }
}

