/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.inject.ImplementedBy;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.OutputConfigurationProvider;

@ImplementedBy(value=OutputConfigurationProvider.class)
public interface IOutputConfigurationProvider {
    public Set<OutputConfiguration> getOutputConfigurations();

    public static class Delegate
    implements IOutputConfigurationProvider,
    IContextualOutputConfigurationProvider {
        private IOutputConfigurationProvider delegate;

        public IOutputConfigurationProvider getDelegate() {
            return this.delegate;
        }

        public Delegate(IOutputConfigurationProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public Set<OutputConfiguration> getOutputConfigurations() {
            return this.delegate.getOutputConfigurations();
        }

        @Override
        public Set<OutputConfiguration> getOutputConfigurations(Resource context) {
            if (this.delegate instanceof IContextualOutputConfigurationProvider) {
                return ((IContextualOutputConfigurationProvider)((Object)this.delegate)).getOutputConfigurations(context);
            }
            return this.delegate.getOutputConfigurations();
        }
    }
}

