/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import java.util.EnumSet;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class SynonymTypesProvider {
    public void collectSynonymTypes(LightweightTypeReference type, Acceptor acceptor) {
        if (type == null || type.isPrimitiveVoid() || type.isType(Void.class)) {
            return;
        }
        if (type.isWrapper()) {
            if (!acceptor.accept(type.getPrimitiveIfWrapperType(), 0x102200)) {
                return;
            }
            this.collectCustomSynonymTypes(type, acceptor);
            return;
        }
        if (type.isPrimitive()) {
            if (!acceptor.accept(type.getWrapperTypeIfPrimitive(), 1065472)) {
                return;
            }
            this.collectCustomSynonymTypes(type, acceptor);
            return;
        }
        if (this.addArrayAndListSynonyms(type, acceptor)) {
            this.collectCustomSynonymTypes(type, acceptor);
        }
    }

    protected boolean collectCustomSynonymTypes(LightweightTypeReference type, Acceptor acceptor) {
        return true;
    }

    protected boolean addArrayAndListSynonyms(LightweightTypeReference type, Acceptor acceptor) {
        if (type.isArray()) {
            LightweightTypeReference listType = type.tryConvertToListType();
            if (listType != null) {
                LightweightTypeReference componentType = type.getComponentType();
                if (componentType == null) {
                    throw new IllegalStateException("Component type of an array may not be null");
                }
                if (componentType.isPrimitive() ? !acceptor.accept(listType, 1066496) : !acceptor.accept(listType, 0x100600)) {
                    return false;
                }
            }
        } else {
            ArrayTypeReference arrayType = type.tryConvertToArray();
            if (arrayType != null) {
                ArrayTypeReference primitiveArray;
                LightweightTypeReference componentType = arrayType.getComponentType();
                LightweightTypeReference primitiveComponentType = componentType.getPrimitiveIfWrapperType();
                if (primitiveComponentType != componentType && !acceptor.accept((LightweightTypeReference)(primitiveArray = type.getOwner().newArrayTypeReference(primitiveComponentType)), 1058304)) {
                    return false;
                }
                if (!acceptor.accept((LightweightTypeReference)arrayType, 0x100600)) {
                    return false;
                }
            }
        }
        return true;
    }

    protected final boolean announceSynonym(LightweightTypeReference synonym, ConformanceHint hint, Acceptor acceptor) {
        return acceptor.accept(synonym, hint);
    }

    protected final boolean announceSynonym(LightweightTypeReference synonym, EnumSet<ConformanceHint> hints, Acceptor acceptor) {
        return acceptor.accept(synonym, hints);
    }

    protected final boolean announceSynonym(LightweightTypeReference synonym, int flags, Acceptor acceptor) {
        return acceptor.accept(synonym, flags | 0x100200);
    }

    public static abstract class Acceptor {
        protected final boolean accept(LightweightTypeReference synonym, ConformanceHint hint) {
            return this.accept(synonym, EnumSet.of(hint, ConformanceHint.SUCCESS, ConformanceHint.CHECKED));
        }

        protected final boolean accept(LightweightTypeReference synonym, EnumSet<ConformanceHint> hints) {
            return this.accept(synonym, this.toFlags(hints));
        }

        protected int toFlags(EnumSet<ConformanceHint> hints) {
            return ConformanceHint.toFlags(hints);
        }

        protected EnumSet<ConformanceHint> fromFlags(int flags) {
            return ConformanceHint.fromFlags(flags);
        }

        protected abstract boolean accept(LightweightTypeReference var1, int var2);
    }
}

