/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext;

import javafx.scene.shape.Line;
import javafx.scene.text.Text;
import org.eclipse.fx.ui.controls.styledtext.DecorationStrategyFactory;
import org.eclipse.fx.ui.controls.styledtext.StyledTextNode;
import org.eclipse.jdt.annotation.NonNull;

public class UnderlineStrategyFactory
implements DecorationStrategyFactory {
    public int getRanking() {
        return 0;
    }

    @Override
    public @NonNull String getDecorationStrategyName() {
        return "underline";
    }

    @Override
    public StyledTextNode.DecorationStrategy create(String definition) {
        return new UnderlineStrategy();
    }

    static class UnderlineStrategy
    implements StyledTextNode.DecorationStrategy {
        UnderlineStrategy() {
        }

        @Override
        public void attach(StyledTextNode node, Text textNode) {
            Line l = (Line)textNode.getUserData();
            if (l == null) {
                l = new Line();
                l.setManaged(false);
                l.setEndX(textNode.getBoundsInLocal().getWidth());
                l.setTranslateY(textNode.getBaselineOffset() + 2.0);
                textNode.setUserData((Object)l);
            }
            node.getChildren().add((Object)l);
        }

        @Override
        public void unattach(StyledTextNode node, Text textNode) {
            Line l = (Line)textNode.getUserData();
            if (l != null) {
                textNode.setUserData(null);
                node.getChildren().remove((Object)l);
            }
        }

        @Override
        public void layout(StyledTextNode node, Text textNode) {
            Line l = (Line)textNode.getUserData();
            if (l != null) {
                l.setEndX(node.getWidth());
            }
        }
    }
}

