/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.databinding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.util.Callback;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.fx.core.databinding.ObservableWritableValue;

public class AdapterFactory {
    public static <E> ObservableWritableValue<E> adapt(IObservableValue value) {
        return new WrappedValue(value);
    }

    public static <E> ObservableList<E> adapt(IObservableList list) {
        return new WrappedList(list);
    }

    public static <E> void bind(ObservableList<E> fxObs, IObservableList dbObs, InitialSync initialSync) {
        ObservableList<E> dbList = AdapterFactory.adapt(dbObs);
        if (initialSync == InitialSync.FX_TO_DB) {
            Bindings.bindContent(dbList, fxObs);
        } else {
            Bindings.bindContentBidirectional(fxObs, dbList);
        }
    }

    public static <E, F extends ObservableValue<E> & WritableValue<E>> void bind(F fxObs, IObservableValue dbObs, InitialSync initialSync) {
        if (initialSync == InitialSync.FX_TO_DB) {
            dbObs.setValue(fxObs.getValue());
        } else {
            ((WritableValue<E>)fxObs).setValue(dbObs.getValue());
        }
        ObservableWritableValue<E> wrapped = AdapterFactory.adapt(dbObs);
        AdapterFactory.do_bind(fxObs, wrapped);
    }

    public static <S, T> IObservableList convertObservableList(IObservableList source, final Callback<S, T> converter) {
        final ReadonlyWritableList target = new ReadonlyWritableList(source.getRealm());
        try {
            target.modifiable = true;
            for (Object o : source) {
                target.add(converter.call(o));
            }
        }
        finally {
            target.modifiable = false;
        }
        source.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                event.diff.accept(new ListDiffVisitor(){

                    public void handleRemove(int index, Object element) {
                        try {
                            target.modifiable = true;
                            target.remove(index);
                        }
                        finally {
                            target.modifiable = false;
                        }
                    }

                    public void handleAdd(int index, Object element) {
                        try {
                            target.modifiable = true;
                            target.add(index, converter.call(element));
                        }
                        finally {
                            target.modifiable = false;
                        }
                    }

                    public void handleReplace(int index, Object oldElement, Object newElement) {
                        try {
                            target.modifiable = true;
                            target.set(index, converter.call(newElement));
                        }
                        finally {
                            target.modifiable = false;
                        }
                    }

                    public void handleMove(int oldIndex, int newIndex, Object element) {
                        try {
                            target.modifiable = true;
                            target.move(oldIndex, newIndex);
                        }
                        finally {
                            target.modifiable = false;
                        }
                    }
                });
            }
        });
        return target;
    }

    private static <E, F extends ObservableValue<E> & WritableValue<E>> void do_bind(F fxObs, F dbObs) {
        fxObs.addListener(new ChangeListener<E>((ObservableValue)fxObs, (ObservableValue)dbObs){
            boolean syncing;
            private final /* synthetic */ ObservableValue val$fxObs;
            private final /* synthetic */ ObservableValue val$dbObs;
            {
                this.val$fxObs = observableValue;
                this.val$dbObs = observableValue2;
            }

            public void changed(ObservableValue<? extends E> observable, E oldValue, E newValue) {
                if (this.syncing) {
                    return;
                }
                try {
                    this.syncing = true;
                    if (observable == this.val$fxObs) {
                        ((WritableValue)this.val$dbObs).setValue(newValue);
                    } else {
                        ((WritableValue)this.val$fxObs).setValue(newValue);
                    }
                }
                finally {
                    this.syncing = false;
                }
            }
        });
    }

    static enum InitialSync {
        FX_TO_DB,
        DB_TO_FX;

    }

    static class ReadonlyWritableList
    extends WritableList {
        boolean modifiable;

        public ReadonlyWritableList(Realm r) {
            super(r);
        }

        public Object set(int index, Object element) {
            if (!this.modifiable) {
                throw new UnsupportedOperationException("Unmodifiable list");
            }
            return super.set(index, element);
        }

        public Object move(int oldIndex, int newIndex) {
            if (!this.modifiable) {
                throw new UnsupportedOperationException("Unmodifiable list");
            }
            return super.move(oldIndex, newIndex);
        }

        public Object remove(int index) {
            if (!this.modifiable) {
                throw new UnsupportedOperationException("Unmodifiable list");
            }
            return super.remove(index);
        }

        public boolean add(Object element) {
            if (!this.modifiable) {
                throw new UnsupportedOperationException("Unmodifiable list");
            }
            return super.add(element);
        }

        public void add(int index, Object element) {
            if (!this.modifiable) {
                throw new UnsupportedOperationException("Unmodifiable list");
            }
            super.add(index, element);
        }

        public boolean addAll(Collection c) {
            if (!this.modifiable) {
                throw new UnsupportedOperationException("Unmodifiable list");
            }
            return super.addAll(c);
        }

        public boolean addAll(int index, Collection c) {
            if (!this.modifiable) {
                throw new UnsupportedOperationException("Unmodifiable list");
            }
            return super.addAll(index, c);
        }

        public boolean remove(Object o) {
            if (!this.modifiable) {
                throw new UnsupportedOperationException("Unmodifiable list");
            }
            return super.remove(o);
        }

        public boolean removeAll(Collection c) {
            if (!this.modifiable) {
                throw new UnsupportedOperationException("Unmodifiable list");
            }
            return super.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            if (!this.modifiable) {
                throw new UnsupportedOperationException("Unmodifiable list");
            }
            return super.retainAll(c);
        }

        public void clear() {
            if (!this.modifiable) {
                throw new UnsupportedOperationException("Unmodifiable list");
            }
            super.clear();
        }
    }

    static class WrappedList<E>
    implements ObservableList<E> {
        List<InvalidationListener> fxInvalidationListeners;
        List<ListChangeListener<? super E>> fxChangeListeners;
        final IObservableList list;
        IChangeListener dbInvalidationListener;
        IListChangeListener dbChangeListener;

        public WrappedList(IObservableList list) {
            this.list = list;
            this.list.addDisposeListener(new IDisposeListener(){

                public void handleDispose(DisposeEvent event) {
                    if (WrappedList.this.fxInvalidationListeners != null) {
                        WrappedList.this.fxInvalidationListeners.clear();
                    }
                    WrappedList.this.dbInvalidationListener = null;
                    if (WrappedList.this.fxChangeListeners != null) {
                        WrappedList.this.fxChangeListeners.clear();
                    }
                    WrappedList.this.dbChangeListener = null;
                }
            });
        }

        public int size() {
            return this.list.size();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        public Iterator<E> iterator() {
            return this.list.iterator();
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public <T> T[] toArray(T[] a) {
            return this.list.toArray((Object[])a);
        }

        public boolean add(E e) {
            return this.list.add(e);
        }

        public boolean remove(Object o) {
            return this.list.remove(o);
        }

        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        public boolean addAll(Collection<? extends E> c) {
            return this.list.addAll(c);
        }

        public boolean addAll(int index, Collection<? extends E> c) {
            return this.list.addAll(index, c);
        }

        public boolean removeAll(Collection<?> c) {
            return this.list.removeAll(c);
        }

        public boolean retainAll(Collection<?> c) {
            return this.list.retainAll(c);
        }

        public void clear() {
            this.list.clear();
        }

        public E get(int index) {
            return (E)this.list.get(index);
        }

        public E set(int index, E element) {
            return (E)this.list.set(index, element);
        }

        public void add(int index, E element) {
            this.list.add(index, element);
        }

        public E remove(int index) {
            return (E)this.list.remove(index);
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        public ListIterator<E> listIterator() {
            return this.list.listIterator();
        }

        public ListIterator<E> listIterator(int index) {
            return this.list.listIterator(index);
        }

        public List<E> subList(int fromIndex, int toIndex) {
            return this.list.subList(fromIndex, toIndex);
        }

        public void addListener(InvalidationListener listener) {
            if (this.fxInvalidationListeners == null) {
                this.fxInvalidationListeners = new ArrayList<InvalidationListener>();
                this.dbInvalidationListener = new IChangeListener(){

                    public void handleChange(ChangeEvent event) {
                        InvalidationListener[] invalidationListenerArray = WrappedList.this.fxInvalidationListeners.toArray(new InvalidationListener[0]);
                        int n = invalidationListenerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            InvalidationListener l = invalidationListenerArray[n2];
                            l.invalidated((Observable)WrappedList.this);
                            ++n2;
                        }
                    }
                };
                this.list.addChangeListener(this.dbInvalidationListener);
            }
            this.fxInvalidationListeners.add(listener);
        }

        public void removeListener(InvalidationListener listener) {
            if (this.fxInvalidationListeners != null) {
                this.fxInvalidationListeners.remove(listener);
                if (this.fxInvalidationListeners.isEmpty()) {
                    this.list.removeChangeListener(this.dbInvalidationListener);
                    this.dbInvalidationListener = null;
                    this.fxInvalidationListeners = null;
                }
            }
        }

        public boolean addAll(E ... elements) {
            return this.list.addAll(Arrays.asList(elements));
        }

        public void addListener(ListChangeListener<? super E> listener) {
            if (this.fxChangeListeners == null) {
                this.fxChangeListeners = new ArrayList<ListChangeListener<? super E>>();
                this.dbChangeListener = new IListChangeListener(){

                    public void handleListChange(ListChangeEvent event) {
                        final ListDiffEntry[] differences = event.diff.getDifferences();
                        if (differences.length == 0) {
                            return;
                        }
                        ListChangeListener[] listChangeListenerArray = WrappedList.this.fxChangeListeners.toArray(new ListChangeListener[0]);
                        int n = listChangeListenerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ListChangeListener l = listChangeListenerArray[n2];
                            ListChangeListener.Change change = new ListChangeListener.Change<E>(WrappedList.this){
                                private int index;
                                private ListDiffEntry current;
                                {
                                    super($anonymous0);
                                    this.index = -1;
                                }

                                public int getFrom() {
                                    return this.current.getPosition();
                                }

                                protected int[] getPermutation() {
                                    return new int[0];
                                }

                                public List<E> getRemoved() {
                                    if (!this.current.isAddition()) {
                                        return Collections.singletonList(this.current.getElement());
                                    }
                                    return Collections.emptyList();
                                }

                                public int getTo() {
                                    if (this.current.isAddition()) {
                                        return this.current.getPosition() + 1;
                                    }
                                    return this.current.getPosition();
                                }

                                public boolean wasAdded() {
                                    return this.current.isAddition();
                                }

                                public boolean wasRemoved() {
                                    return !this.current.isAddition();
                                }

                                public boolean wasPermutated() {
                                    return false;
                                }

                                public boolean wasReplaced() {
                                    return false;
                                }

                                public boolean next() {
                                    ++this.index;
                                    if (this.index < differences.length) {
                                        this.current = differences[this.index];
                                        return true;
                                    }
                                    return false;
                                }

                                public void reset() {
                                    this.index = 0;
                                }
                            };
                            l.onChanged(change);
                            ++n2;
                        }
                    }
                };
                this.list.addListChangeListener(this.dbChangeListener);
            }
            this.fxChangeListeners.add(listener);
        }

        public void removeListener(ListChangeListener<? super E> listener) {
            if (this.fxChangeListeners != null) {
                this.fxChangeListeners.remove(listener);
                if (this.fxChangeListeners.isEmpty()) {
                    this.list.removeListChangeListener(this.dbChangeListener);
                    this.dbChangeListener = null;
                    this.fxChangeListeners = null;
                }
            }
        }

        public void remove(int from, int to) {
            int idx = to;
            while (idx >= from) {
                this.list.remove(idx);
                --idx;
            }
        }

        public boolean removeAll(E ... elements) {
            return this.list.removeAll(Arrays.asList(elements));
        }

        public boolean retainAll(E ... elements) {
            return this.list.retainAll(Arrays.asList(elements));
        }

        public boolean setAll(E ... elements) {
            this.list.clear();
            return this.list.addAll(Arrays.asList(elements));
        }

        public boolean setAll(Collection<? extends E> col) {
            this.list.clear();
            return this.list.addAll(col);
        }

        public void forEach(Consumer<? super E> action) {
            this.list.forEach(action);
        }

        public Spliterator<E> spliterator() {
            return this.list.spliterator();
        }
    }

    static class WrappedValue<E>
    implements ObservableWritableValue<E> {
        List<InvalidationListener> fxInvalidationListeners;
        List<ChangeListener<? super E>> fxChangeListeners;
        final IObservableValue value;
        IChangeListener dbInvalidationListener;
        IValueChangeListener dbChangeListener;

        public WrappedValue(IObservableValue value) {
            this.value = value;
            this.value.addDisposeListener(new IDisposeListener(){

                public void handleDispose(DisposeEvent event) {
                    if (WrappedValue.this.fxInvalidationListeners != null) {
                        WrappedValue.this.fxInvalidationListeners.clear();
                    }
                    WrappedValue.this.dbInvalidationListener = null;
                    if (WrappedValue.this.fxChangeListeners != null) {
                        WrappedValue.this.fxChangeListeners.clear();
                    }
                    WrappedValue.this.dbChangeListener = null;
                }
            });
        }

        public void addListener(InvalidationListener listener) {
            if (this.fxInvalidationListeners == null) {
                this.fxInvalidationListeners = new ArrayList<InvalidationListener>();
                this.dbInvalidationListener = new IChangeListener(){

                    public void handleChange(ChangeEvent event) {
                        InvalidationListener[] invalidationListenerArray = WrappedValue.this.fxInvalidationListeners.toArray(new InvalidationListener[0]);
                        int n = invalidationListenerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            InvalidationListener l = invalidationListenerArray[n2];
                            l.invalidated((Observable)WrappedValue.this);
                            ++n2;
                        }
                    }
                };
                this.value.addChangeListener(this.dbInvalidationListener);
            }
            this.fxInvalidationListeners.add(listener);
        }

        public void removeListener(InvalidationListener listener) {
            if (this.fxInvalidationListeners != null) {
                this.fxInvalidationListeners.remove(listener);
                if (this.fxInvalidationListeners.isEmpty()) {
                    this.value.removeChangeListener(this.dbInvalidationListener);
                    this.dbInvalidationListener = null;
                    this.fxInvalidationListeners = null;
                }
            }
        }

        public void addListener(ChangeListener<? super E> listener) {
            if (this.fxChangeListeners == null) {
                this.fxChangeListeners = new ArrayList<ChangeListener<? super E>>();
                this.dbChangeListener = new IValueChangeListener(){

                    public void handleValueChange(ValueChangeEvent event) {
                        ChangeListener[] changeListenerArray = WrappedValue.this.fxChangeListeners.toArray(new ChangeListener[0]);
                        int n = changeListenerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ChangeListener l = changeListenerArray[n2];
                            l.changed((ObservableValue)WrappedValue.this, event.diff.getOldValue(), event.diff.getNewValue());
                            ++n2;
                        }
                    }
                };
                this.value.addValueChangeListener(this.dbChangeListener);
            }
            this.fxChangeListeners.add(listener);
        }

        public void removeListener(ChangeListener<? super E> listener) {
            if (this.fxChangeListeners != null) {
                this.fxChangeListeners.remove(listener);
                if (this.fxChangeListeners.isEmpty()) {
                    this.value.removeValueChangeListener(this.dbChangeListener);
                    this.dbChangeListener = null;
                    this.fxChangeListeners = null;
                }
            }
        }

        public E getValue() {
            return (E)this.value.getValue();
        }

        public void setValue(E value) {
            this.value.setValue(value);
        }
    }
}

