/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.internal.equinox.DevClassPathHelper;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bundles {
    private static final Logger log = LoggerFactory.getLogger(Bundles.class);

    private static Bundle findDependencyBundle(Bundle bundle, String dependencyName, Set<Bundle> visited) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring == null) {
            return null;
        }
        ArrayList dependencies = new ArrayList();
        dependencies.addAll(bundleWiring.getRequiredWires("osgi.wiring.bundle"));
        dependencies.addAll(bundleWiring.getRequiredWires("osgi.wiring.package"));
        for (BundleWire wire : dependencies) {
            Bundle requiredBundle = wire.getProviderWiring().getBundle();
            if (requiredBundle == null || !visited.add(requiredBundle)) continue;
            if (dependencyName.equals(requiredBundle.getSymbolicName())) {
                return requiredBundle;
            }
            Bundle required = Bundles.findDependencyBundle(requiredBundle, dependencyName, visited);
            if (required == null) continue;
            return required;
        }
        return null;
    }

    public static Bundle findDependencyBundle(Bundle bundle, String dependencyId) {
        return Bundles.findDependencyBundle(bundle, dependencyId, new HashSet<Bundle>());
    }

    public static ClassLoader getBundleClassloader(Bundle bundle) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring == null) {
            return null;
        }
        return bundleWiring.getClassLoader();
    }

    public static List<String> getClasspathEntries(Bundle bundle) {
        log.debug("getClasspathEntries(Bundle={})", (Object)bundle.toString());
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        if (DevClassPathHelper.inDevelopmentMode()) {
            cp.addAll(Arrays.asList(DevClassPathHelper.getDevClassPath(bundle.getSymbolicName())));
        }
        cp.addAll(Arrays.asList(Bundles.parseBundleClasspath(bundle)));
        ArrayList<String> entries = new ArrayList<String>();
        for (String cpe : cp) {
            String entry = ".".equals(cpe) ? Bundles.getNestedJarOrDir(bundle, "/") : Bundles.getNestedJarOrDir(bundle, cpe);
            if (entry == null) continue;
            entry = new Path(entry).toOSString();
            log.debug("\tEntry:{}", (Object)entry);
            entries.add(entry);
        }
        return entries;
    }

    private static String[] parseBundleClasspath(Bundle bundle) {
        String[] result = new String[]{"."};
        String header = (String)bundle.getHeaders().get("Bundle-ClassPath");
        ManifestElement[] classpathEntries = null;
        try {
            classpathEntries = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)header);
        }
        catch (BundleException ex) {
            log.warn("Could not parse bundle classpath of {}", (Object)bundle.toString(), (Object)ex);
        }
        if (classpathEntries != null) {
            result = new String[classpathEntries.length];
            int i = 0;
            while (i < classpathEntries.length) {
                result[i] = classpathEntries[i].getValue();
                ++i;
            }
        }
        return result;
    }

    private static String getNestedJarOrDir(Bundle bundle, String cp) {
        File file;
        URL url = bundle.getEntry(cp);
        if (url != null) {
            try {
                return FileLocator.toFileURL((URL)url).getFile();
            }
            catch (IOException ex) {
                log.warn("Could not get entry {} for bundle {}", new Object[]{cp, bundle.toString(), ex});
            }
        }
        if (DevClassPathHelper.inDevelopmentMode() && (file = new File(cp)).exists() && file.isAbsolute()) {
            return file.getAbsolutePath();
        }
        log.debug("Bundle {} does not have entry {}", (Object)bundle.toString(), (Object)cp);
        return null;
    }

    private static Bundle findDependencyBundleByPackage(Bundle bundle, String packageName, Set<Bundle> visited) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring == null) {
            return null;
        }
        ArrayList dependencies = new ArrayList();
        dependencies.addAll(bundleWiring.getRequiredWires("osgi.wiring.bundle"));
        dependencies.addAll(bundleWiring.getRequiredWires("osgi.wiring.package"));
        for (BundleWire wire : dependencies) {
            Bundle required;
            BundleCapability cap = wire.getCapability();
            String pkg = (String)cap.getAttributes().get("osgi.wiring.package");
            Bundle requiredBundle = wire.getProviderWiring().getBundle();
            if (requiredBundle == null) continue;
            if (packageName.equals(pkg)) {
                return requiredBundle;
            }
            if (!visited.add(requiredBundle) || (required = Bundles.findDependencyBundleByPackage(requiredBundle, packageName, visited)) == null) continue;
            return required;
        }
        return null;
    }

    public static Bundle findDependencyBundleByPackage(Bundle bundle, String packageName) {
        return Bundles.findDependencyBundleByPackage(bundle, packageName, new HashSet<Bundle>());
    }
}

