/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.nls.ModelChange;
import org.eclipse.pde.internal.ui.nls.ModelChangeFile;
import org.eclipse.swt.graphics.Image;

public class ModelChangeLabelProvider
extends PDELabelProvider {
    private Image manifestImage;
    private Image xmlImage = PDEPluginImages.DESC_PLUGIN_MF_OBJ.createImage();

    public ModelChangeLabelProvider() {
        this.manifestImage = PDEPluginImages.DESC_PAGE_OBJ.createImage();
    }

    @Override
    public String getText(Object obj) {
        if (obj instanceof ModelChange) {
            return this.getObjectText(((ModelChange)obj).getParentModel().getPluginBase());
        }
        if (obj instanceof ModelChangeFile) {
            return this.getObjectText((ModelChangeFile)obj);
        }
        return super.getText(obj);
    }

    private String getObjectText(ModelChangeFile pair) {
        StringBuffer text = new StringBuffer(pair.getFile().getName());
        int count = pair.getNumChanges();
        text.append(" [");
        text.append(count);
        if (count == 1) {
            text.append(PDEUIMessages.ModelChangeLabelProvider_instance);
        } else {
            text.append(PDEUIMessages.ModelChangeLabelProvider_instances);
        }
        text.append("]");
        return text.toString();
    }

    @Override
    public Image getImage(Object obj) {
        if (obj instanceof ModelChange) {
            IPluginModelBase model = ((ModelChange)obj).getParentModel();
            if (model instanceof IPluginModel) {
                return this.getObjectImage(((IPluginModel)model).getPlugin(), false, false);
            }
            if (model instanceof IFragmentModel) {
                return this.getObjectImage(((IFragmentModel)model).getFragment(), false, false);
            }
        }
        if (obj instanceof ModelChangeFile) {
            return this.getObjectImage((ModelChangeFile)obj);
        }
        return super.getImage(obj);
    }

    private Image getObjectImage(ModelChangeFile file) {
        String type = file.getFile().getFileExtension();
        if ("xml".equalsIgnoreCase(type)) {
            return this.xmlImage;
        }
        if ("MF".equalsIgnoreCase(type)) {
            return this.manifestImage;
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.manifestImage != null) {
            this.manifestImage.dispose();
        }
        if (this.xmlImage != null) {
            this.xmlImage.dispose();
        }
        super.dispose();
    }
}

