/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.DynaPicker;
import fr.inria.zvtm.engine.Picker;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.Translucency;
import fr.inria.zvtm.glyphs.Translucent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class VCursor {
    Color color;
    Color hcolor;
    boolean isVisible = true;
    boolean sensit = true;
    boolean sync;
    protected float cx;
    protected float cy;
    protected double vx;
    protected double vy;
    protected double pvx;
    protected double pvy;
    protected int jpx;
    protected int jpy;
    float[] gain = new float[2];
    Picker picker;
    DynaPicker dynaPicker;
    Glyph[] stickedGlyphs;
    View owningView;
    int size = 10;

    VCursor(View v) {
        this.owningView = v;
        this.picker = new Picker();
        this.dynaPicker = new DynaPicker(this);
        this.vx = 0.0;
        this.pvx = 0.0;
        this.vy = 0.0;
        this.pvy = 0.0;
        this.cx = 0.0f;
        this.cy = 0.0f;
        this.jpx = 0;
        this.jpy = 0;
        this.color = Color.black;
        this.hcolor = Color.black;
        this.stickedGlyphs = new Glyph[0];
        this.sync = true;
    }

    public void setSize(int s) {
        this.size = s;
    }

    public int getSize() {
        return this.size;
    }

    public Point2D.Double getLocation() {
        return new Point2D.Double(this.vx, this.vy);
    }

    public View getOwningView() {
        return this.owningView;
    }

    public void setSync(boolean b) {
        this.sync = b;
    }

    public boolean getSync() {
        return this.sync;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void setHintColor(Color c) {
        this.hcolor = c;
    }

    public void setJPanelCoordinates(int x, int y) {
        if (this.sync) {
            this.jpx = x;
            this.jpy = y;
            this.picker.setJPanelCoordinates(this.jpx, this.jpy);
        }
    }

    public void propagateMove() {
        for (int i = 0; i < this.stickedGlyphs.length; ++i) {
            this.stickedGlyphs[i].move(this.vx - this.pvx, this.vy - this.pvy);
        }
    }

    public void stickGlyph(Glyph g) {
        if (g == null) {
            return;
        }
        g.setSensitivity(false);
        Glyph[] newStickList = new Glyph[this.stickedGlyphs.length + 1];
        System.arraycopy(this.stickedGlyphs, 0, newStickList, 0, this.stickedGlyphs.length);
        newStickList[this.stickedGlyphs.length] = g;
        this.stickedGlyphs = newStickList;
        g.stickedTo = this;
    }

    public Glyph unstickLastGlyph() {
        if (this.stickedGlyphs.length > 0) {
            Glyph g = this.stickedGlyphs[this.stickedGlyphs.length - 1];
            g.setSensitivity(true);
            g.stickedTo = null;
            Glyph[] newStickList = new Glyph[this.stickedGlyphs.length - 1];
            System.arraycopy(this.stickedGlyphs, 0, newStickList, 0, this.stickedGlyphs.length - 1);
            this.stickedGlyphs = newStickList;
            return g;
        }
        return null;
    }

    public int getStickedGlyphsNumber() {
        return this.stickedGlyphs.length;
    }

    public void unstickGlyph(Glyph g) {
        for (int i = 0; i < this.stickedGlyphs.length; ++i) {
            if (this.stickedGlyphs[i] != g) continue;
            g.stickedTo = null;
            g.setSensitivity(true);
            Glyph[] newStickList = new Glyph[this.stickedGlyphs.length - 1];
            System.arraycopy(this.stickedGlyphs, 0, newStickList, 0, i);
            System.arraycopy(this.stickedGlyphs, i + 1, newStickList, i, this.stickedGlyphs.length - i - 1);
            this.stickedGlyphs = newStickList;
            break;
        }
    }

    public Glyph[] getStickedGlyphArray() {
        return this.stickedGlyphs;
    }

    public void setVisibility(boolean b) {
        this.isVisible = b;
    }

    public void setSensitivity(boolean b) {
        this.sensit = b;
    }

    public boolean isSensitive() {
        return this.sensit;
    }

    public void unProject(Camera c, ViewPanel v) {
        if (this.sync && v.size != null) {
            if (v.lens != null) {
                v.lens.gf(this.jpx, this.jpy, this.gain);
                this.cx = this.gain[0] >= v.lens.getBufferThreshold() ? (float)v.lens.lx + (float)(this.jpx + v.lens.getXfocusOffset() - v.size.width / 2 - v.lens.lx) / this.gain[0] : (float)v.lens.lx + (float)(this.jpx - v.size.width / 2 - v.lens.lx) / this.gain[0];
                this.cy = this.gain[1] >= v.lens.getBufferThreshold() ? (float)(v.lens.ly + v.size.height / 2 - this.jpy - v.lens.getYfocusOffset()) / this.gain[1] - (float)v.lens.ly : (float)(v.lens.ly + v.size.height / 2 - this.jpy) / this.gain[1] - (float)v.lens.ly;
            } else {
                this.cx = this.jpx - v.size.width / 2;
                this.cy = v.size.height / 2 - this.jpy;
            }
            double ucoef = (c.focal + c.altitude) / c.focal;
            this.pvx = this.vx;
            this.pvy = this.vy;
            this.vx = (double)this.cx * ucoef + c.vx;
            this.vy = (double)this.cy * ucoef + c.vy;
            this.picker.setVSCoordinates(this.vx, this.vy);
        }
    }

    public Picker getPicker() {
        return this.picker;
    }

    public DynaPicker getDynaPicker() {
        return this.dynaPicker;
    }

    public Point2D.Double getVSCoordinates(Camera c) {
        double tcy;
        double tcx;
        ViewPanel v = this.owningView.getPanel();
        if (v.lens != null) {
            v.lens.gf(this.jpx, this.jpy, this.gain);
            tcx = this.gain[0] >= v.lens.getBufferThreshold() ? (double)((float)v.lens.lx + (float)(this.jpx + v.lens.getXfocusOffset() - v.size.width / 2 - v.lens.lx) / this.gain[0]) : (double)((float)v.lens.lx + (float)(this.jpx - v.size.width / 2 - v.lens.lx) / this.gain[0]);
            tcy = this.gain[1] >= v.lens.getBufferThreshold() ? (double)((float)(v.lens.ly + v.size.height / 2 - this.jpy - v.lens.getYfocusOffset()) / this.gain[1] - (float)v.lens.ly) : (double)((float)(v.lens.ly + v.size.height / 2 - this.jpy) / this.gain[1] - (float)v.lens.ly);
        } else {
            tcx = this.jpx - v.size.width / 2;
            tcy = v.size.height / 2 - this.jpy;
        }
        double ucoef = (c.focal + c.altitude) / c.focal;
        return new Point2D.Double(tcx * ucoef + c.vx, tcy * ucoef + c.vy);
    }

    public int getPanelXCoordinate() {
        return this.jpx;
    }

    public int getPanelYCoordinate() {
        return this.jpy;
    }

    public double getVSXCoordinate() {
        return this.vx;
    }

    public double getVSYCoordinate() {
        return this.vy;
    }

    void draw(Graphics2D g) {
        if (this.isVisible) {
            g.setColor(this.color);
            g.drawLine(this.jpx - this.size, this.jpy, this.jpx + this.size, this.jpy);
            g.drawLine(this.jpx, this.jpy - this.size, this.jpx, this.jpy + this.size);
        }
        if (this.dynaPicker.dynaSpotActivated && this.dynaPicker.showDynarea) {
            g.setColor(this.dynaPicker.DYNASPOT_COLOR);
            switch (this.dynaPicker.dynaSpotVisibility) {
                case 1: {
                    g.setComposite(this.dynaPicker.dsST);
                    break;
                }
                case 2: {
                    g.setComposite(Translucency.acs[(int)Math.round((1.0 - this.dynaPicker.opacity) * (double)this.dynaPicker.DYNASPOT_MAX_TRANSLUCENCY * 20.0)]);
                    break;
                }
                case 3: {
                    g.setComposite(Translucency.acs[(int)Math.round(this.dynaPicker.opacity * (double)this.dynaPicker.DYNASPOT_MAX_TRANSLUCENCY * 20.0)]);
                }
            }
            g.fillOval(this.jpx - this.dynaPicker.dynaSpotRadius, this.jpy - this.dynaPicker.dynaSpotRadius, 2 * this.dynaPicker.dynaSpotRadius, 2 * this.dynaPicker.dynaSpotRadius);
            g.setComposite(Translucent.acO);
        }
    }
}

