/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors.jni;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.cfg.ConfigFileHandler;
import org.eclipse.titan.executor.Activator;
import org.eclipse.titan.executor.TITANConsole;
import org.eclipse.titan.executor.designerconnection.EnvironmentHelper;
import org.eclipse.titan.executor.executors.BaseExecutor;
import org.eclipse.titan.executor.executors.ExecuteDialog;
import org.eclipse.titan.executor.executors.SeverityResolver;
import org.eclipse.titan.executor.jni.ComponentStruct;
import org.eclipse.titan.executor.jni.HostStruct;
import org.eclipse.titan.executor.jni.IJNICallback;
import org.eclipse.titan.executor.jni.JNIMiddleWare;
import org.eclipse.titan.executor.jni.McStateEnum;
import org.eclipse.titan.executor.jni.QualifiedName;
import org.eclipse.titan.executor.jni.Timeval;
import org.eclipse.titan.executor.jni.VerdictTypeEnum;
import org.eclipse.titan.executor.views.executormonitor.ComponentElement;
import org.eclipse.titan.executor.views.executormonitor.ExecutorStorage;
import org.eclipse.titan.executor.views.executormonitor.HostControllerElement;
import org.eclipse.titan.executor.views.executormonitor.InformationElement;
import org.eclipse.titan.executor.views.executormonitor.LaunchElement;
import org.eclipse.titan.executor.views.executormonitor.LaunchStorage;
import org.eclipse.titan.executor.views.executormonitor.MainControllerElement;
import org.eclipse.titan.executor.views.notification.Notification;
import org.eclipse.titan.executor.views.testexecution.ExecutedTestcase;
import org.eclipse.titan.executor.views.testexecution.TestExecutionView;
import org.eclipse.ui.console.MessageConsoleStream;

public final class JniExecutor
extends BaseExecutor
implements IJNICallback {
    public static final int MC_INACTIVE = 0;
    public static final int MC_LISTENING = 1;
    public static final int MC_LISTENING_CONFIGURED = 2;
    public static final int MC_HC_CONNECTED = 3;
    public static final int MC_CONFIGURING = 4;
    public static final int MC_ACTIVE = 5;
    public static final int MC_SHUTDOWN = 6;
    public static final int MC_CREATING_MTC = 7;
    public static final int MC_READY = 8;
    public static final int MC_TERMINATING_MTC = 9;
    public static final int MC_EXECUTING_CONTROL = 10;
    public static final int MC_EXECUTING_TESTCASE = 11;
    public static final int MC_TERMINATING_TESTCASE = 12;
    public static final int MC_PAUSED = 13;
    private boolean startHCRequested = false;
    private boolean configureRequested = false;
    private int configFileExecutionRequestCounter = -1;
    private boolean createMTCRequested = false;
    private boolean executeRequested = false;
    private List<String> executeList = new ArrayList<String>();
    private boolean shutdownRequested = false;
    private JNIMiddleWare jnimw;
    private boolean simpleExecutionRunning = false;
    private boolean isTerminated = false;
    private static boolean isRunning = false;
    private boolean loggingIsEnabled = true;
    private static final String EXECUTION_FINISHED = "^Test case (.*) finished\\. Verdict: (.*)$";
    private static final Pattern EXECUTION_FINISHED_PATTERN = Pattern.compile("^Test case (.*) finished\\. Verdict: (.*)$");
    private final Matcher executionFinishedMatcher = EXECUTION_FINISHED_PATTERN.matcher("");
    private static final String REASON = "^(.*) reason: (.*)$";
    private static final Pattern REASON_PATTERN = Pattern.compile("^(.*) reason: (.*)$");
    private final Matcher reasonMatcher = REASON_PATTERN.matcher("");
    private static final String EMPTY_STRING = "";
    private Action automaticExecution;
    private Action startSession;
    private Action configure;
    private Action startHCs;
    private Action cmtc;
    private Action smtc;
    private Action generalPause;
    private Action cont;
    private Action stop;
    private Action emtc;
    private Action generalLogging;
    private Action shutdownSession;
    private Action info;
    private MessageConsoleStream consoleStream;
    private ConfigFileHandler configHandler = null;

    public JniExecutor(ILaunchConfiguration configuration) throws CoreException {
        super(configuration);
        if (null == this.configFilePath) {
            Status status = new Status(4, "org.eclipse.titan.executor", 0, "Could not launch beacuse the configuration file's path is null", null);
            throw new CoreException((IStatus)status);
        }
        this.automaticExecution = new Action("automatic execution"){

            public void run() {
                JniExecutor.this.simpleExecutionRunning = true;
                JniExecutor.this.startTest(false);
            }
        };
        this.automaticExecution.setToolTipText("automatic execution");
        this.startSession = new Action("Start session"){

            public void run() {
                JniExecutor.this.initialization();
            }
        };
        this.startSession.setToolTipText("Start session");
        this.startHCs = new Action("Start HCs"){

            public void run() {
                JniExecutor.this.startHostControllers();
            }
        };
        this.startHCs.setToolTipText("Start HCs");
        this.configure = new Action("Set parameters"){

            public void run() {
                JniExecutor.this.configure();
            }
        };
        this.configure.setToolTipText("Set parameters");
        this.cmtc = new Action("create MTC"){

            public void run() {
                JniExecutor.this.createMTC();
            }
        };
        this.cmtc.setToolTipText("create MTC");
        this.smtc = new Action("Execute.."){

            public void run() {
                JniExecutor.this.startTest(false);
            }
        };
        this.smtc.setToolTipText("Execute..");
        this.generalPause = new Action("Pause execution", 2){

            public void run() {
                JniExecutor.this.jnimw.stop_after_testcase(JniExecutor.this.generalPause.isChecked());
            }
        };
        this.generalPause.setToolTipText("Pause execution");
        this.generalPause.setChecked(false);
        this.cont = new Action("Continue execution"){

            public void run() {
                JniExecutor.this.jnimw.continue_testcase();
            }
        };
        this.cont.setToolTipText("Continue execution");
        this.stop = new Action("Stop execution"){

            public void run() {
                JniExecutor.this.stop();
            }
        };
        this.stop.setToolTipText("Stop execution");
        this.emtc = new Action("Exit MTC"){

            public void run() {
                JniExecutor.this.exitMTC();
            }
        };
        this.emtc.setToolTipText("Exit MTC");
        this.generalLogging = new Action("Generate console log"){

            public void run() {
                if (JniExecutor.this.generalLogging.isChecked()) {
                    JniExecutor.this.loggingIsEnabled = true;
                } else {
                    JniExecutor.this.loggingIsEnabled = false;
                }
            }
        };
        this.generalLogging.setToolTipText("Console logging");
        this.generalLogging.setChecked(true);
        this.shutdownSession = new Action("Shutdown session"){

            public void run() {
                JniExecutor.this.shutdownSession();
            }
        };
        this.shutdownSession.setToolTipText("Shutdown session");
        this.info = new Action("Update status information"){

            public void run() {
                JniExecutor.this.updateInfoDisplay();
            }
        };
        this.info.setToolTipText("Updates the status displaying hierarchy");
        this.consoleStream = TITANConsole.getConsole().newMessageStream();
        this.jnimw = new JNIMiddleWare(this);
        this.jnimw.initialize(1500);
        JniExecutor.setRunning(true);
        this.isTerminated = false;
        this.loggingIsEnabled = true;
        this.updateGUI();
    }

    public static boolean isRunning() {
        return isRunning;
    }

    private static void setRunning(boolean newValue) {
        isRunning = newValue;
    }

    @Override
    public void startSession(ILaunch launch) {
        super.startSession(launch);
        if (this.automaticExecuteSectionExecution) {
            if (!LaunchStorage.getLaunchElementMap().containsKey(launch)) {
                ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
                LaunchElement launchElement = new LaunchElement(launchConfiguration.getName(), launch);
                LaunchStorage.registerLaunchElement(launchElement);
                ExecutorStorage.registerExecutorStorage(launchElement);
            }
            this.simpleExecutionRunning = true;
            this.startTest(true);
        }
    }

    @Override
    public MenuManager createMenu(MenuManager manager) {
        if (!this.isTerminated) {
            manager.add((IAction)this.automaticExecution);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.startSession);
            manager.add((IAction)this.configure);
            manager.add((IAction)this.startHCs);
            manager.add((IAction)this.cmtc);
            manager.add((IAction)this.smtc);
            manager.add((IAction)this.generalPause);
            manager.add((IAction)this.cont);
            manager.add((IAction)this.stop);
            manager.add((IAction)this.emtc);
            manager.add((IAction)this.shutdownSession);
            manager.add((IAction)this.generalLogging);
            manager.add((IAction)this.info);
        }
        return super.createMenu(manager);
    }

    @Override
    public void insertError(int severity, String msg) {
        this.consoleStream.println("Error: " + msg);
        if (this.severityLevelExtraction) {
            this.addNotification(new Notification(new Formatter().format("%1$tF %1$tH:%1$tM:%1$tS.%1$tL000", new Date()).toString(), SeverityResolver.getSeverityString(severity), EMPTY_STRING, msg));
        } else {
            this.addNotification(new Notification(new Formatter().format("%1$tF %1$tH:%1$tM:%1$tS.%1$tL000", new Date()).toString(), EMPTY_STRING, EMPTY_STRING, msg));
        }
        if (this.simpleExecutionRunning) {
            this.shutdownRequested = true;
        }
    }

    @Override
    public void errorCallback(int severity, String msg) {
        this.insertError(severity, msg);
        if (null != Activator.getMainView()) {
            Activator.getMainView().refreshIfSelected(this.mainControllerRoot);
        }
    }

    @Override
    public void batchedInsertNotify(ArrayList<String[]> s) {
        if (this.loggingIsEnabled && this.consoleLogging) {
            for (String[] sv : s) {
                this.consoleStream.println(sv[2] + ": " + sv[4]);
            }
        }
        ArrayList<String> times = new ArrayList<String>(s.size());
        ArrayList<Notification> tempNotifications = new ArrayList<Notification>(s.size());
        if (this.severityLevelExtraction) {
            for (String[] value : s) {
                int severity = Integer.parseInt(value[3]);
                Formatter formatter = new Formatter();
                formatter.format("%1$tF %1$tH:%1$tM:%1$tS.%2$06d", new Date(Long.parseLong(value[0]) * 1000L), Long.valueOf(value[1]));
                times.add(formatter.toString());
                tempNotifications.add(new Notification(formatter.toString(), SeverityResolver.getSeverityString(severity), value[2], value[4]));
                formatter.close();
            }
        } else {
            for (String[] value : s) {
                Formatter formatter = new Formatter();
                formatter.format("%1$tF %1$tH:%1$tM:%1$tS.%2$06d", new Date(Long.parseLong(value[0]) * 1000L), Long.valueOf(value[1]));
                times.add(formatter.toString());
                tempNotifications.add(new Notification(formatter.toString(), EMPTY_STRING, value[2], value[4]));
                formatter.close();
            }
        }
        this.addNotifications(tempNotifications);
        if (this.verdictExtraction) {
            for (int i = 0; i < s.size(); ++i) {
                if (!this.executionFinishedMatcher.reset(s.get(i)[4]).matches()) continue;
                String reason = this.executionFinishedMatcher.group(2);
                if (this.reasonMatcher.reset(reason).matches()) {
                    this.executedTests.add(new ExecutedTestcase((String)times.get(i), this.executionFinishedMatcher.group(1), this.reasonMatcher.group(1), this.reasonMatcher.group(2)));
                    continue;
                }
                this.executedTests.add(new ExecutedTestcase((String)times.get(i), this.executionFinishedMatcher.group(1), this.executionFinishedMatcher.group(2), EMPTY_STRING));
            }
        }
    }

    @Override
    public void insertNotify(Timeval time, String source, int severity, String msg) {
        if (this.loggingIsEnabled && this.consoleLogging) {
            this.consoleStream.println(source + ": " + msg);
        }
        Formatter formatter = new Formatter();
        formatter.format("%1$tF %1$tH:%1$tM:%1$tS.%2$06d", new Date(time.tv_sec * 1000L), time.tv_usec);
        if (this.severityLevelExtraction) {
            this.addNotification(new Notification(formatter.toString(), SeverityResolver.getSeverityString(severity), source, msg));
        } else {
            this.addNotification(new Notification(formatter.toString(), EMPTY_STRING, source, msg));
        }
        if (this.verdictExtraction && this.executionFinishedMatcher.reset(msg).matches()) {
            String reason = this.executionFinishedMatcher.group(2);
            if (this.reasonMatcher.reset(reason).matches()) {
                this.executedTests.add(new ExecutedTestcase(formatter.toString(), this.executionFinishedMatcher.group(1), this.reasonMatcher.group(1), this.reasonMatcher.group(2)));
            } else {
                this.executedTests.add(new ExecutedTestcase(formatter.toString(), this.executionFinishedMatcher.group(1), this.executionFinishedMatcher.group(2), EMPTY_STRING));
            }
        }
    }

    @Override
    public void notifyCallback(Timeval time, String source, int severity, String msg) {
        this.insertNotify(time, source, severity, msg);
        if (Activator.getMainView() != null) {
            Activator.getMainView().refreshIfSelected(this.mainControllerRoot);
        } else {
            TestExecutionView.refreshInput(this);
        }
    }

    @Override
    public void statusChangeCallback() {
        McStateEnum state = this.jnimw.get_state();
        switch (state.getValue()) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                if (this.shutdownRequested) {
                    this.shutdownSession();
                    break;
                }
                if (!this.configureRequested) break;
                this.configure();
                break;
            }
            case 5: {
                if (this.createMTCRequested) {
                    this.createMTC();
                    break;
                }
                if (!this.shutdownRequested) break;
                this.shutdownSession();
                break;
            }
            case 8: {
                if (this.executeList.isEmpty()) {
                    this.executeRequested = false;
                }
                if (this.executeRequested) {
                    this.executeNextTest();
                    break;
                }
                if (!this.simpleExecutionRunning && !this.shutdownRequested) break;
                this.shutdownSession();
                break;
            }
            case 0: {
                if (!this.shutdownRequested) break;
                this.shutdownRequested = false;
                this.jnimw.terminate_internal();
                this.executeList.clear();
                this.disposeHostControllers();
                break;
            }
            case 6: {
                break;
            }
        }
        this.updateGUI();
    }

    private void initialization() {
        this.configHandler = null;
        int tcpport = 0;
        String localAddress = null;
        if (new File(this.configFilePath).exists()) {
            this.configHandler = this.readConfigFile();
            HashMap<String, String> env = new HashMap<String, String>(System.getenv());
            if (!this.appendEnvironmentalVariables) {
                env.clear();
            }
            if (this.environmentalVariables != null) {
                try {
                    EnvironmentHelper.resolveVariables(env, this.environmentalVariables);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
            EnvironmentHelper.setTitanPath(env);
            EnvironmentHelper.set_LICENSE_FILE_PATH(env);
            if (this.configHandler == null) {
                ErrorReporter.parallelErrorDisplayInMessageDialog((String)"An error was found while processing the configuration file", (String)"Please refer to the Error Log view for further information.");
                return;
            }
            if (this.configHandler.isErroneous()) {
                if (this.configHandler.parseExceptions().isEmpty()) {
                    ErrorReporter.parallelErrorDisplayInMessageDialog((String)"An error was found while processing the configuration file", (String)"Please refer to the Error Log view for further information.");
                } else {
                    Throwable exception = (Throwable)this.configHandler.parseExceptions().get(this.configHandler.parseExceptions().size() - 1);
                    ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Error while processing the configuration file", (String)(exception.getMessage() + "\n Please refer to the Error Log view for further information."));
                }
                return;
            }
            tcpport = this.configHandler.getTcpPort();
            double killTimer = this.configHandler.getKillTimer();
            localAddress = this.configHandler.getLocalAddress();
            this.jnimw.set_kill_timer(killTimer);
            this.jnimw.destroy_host_groups();
            Map groups = this.configHandler.getGroups();
            Map components = this.configHandler.getComponents();
            for (Map.Entry group : groups.entrySet()) {
                for (String hostName : (String[])group.getValue()) {
                    this.jnimw.add_host((String)group.getKey(), hostName);
                }
            }
            for (Map.Entry component : components.entrySet()) {
                this.jnimw.assign_component((String)component.getValue(), (String)component.getKey());
            }
        }
        if (localAddress != null && !EMPTY_STRING.equals(localAddress) && 0 == tcpport) {
            this.addNotification(new Notification(new Formatter().format("%1$tF %1$tH:%1$tM:%1$tS.%1$tL000", new Date()).toString(), EMPTY_STRING, EMPTY_STRING, "If LocalAddress is specified you must also set the TCPPort in the configuration file: " + this.configFilePath));
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Error in the configuration", (String)("If LocalAddress is specified you must also set the TCPPort in the configuration file: " + this.configFilePath));
            this.shutdownSession();
            return;
        }
        if (localAddress == null) {
            localAddress = "NULL";
        }
        this.mcHost = localAddress;
        int port = this.jnimw.start_session(localAddress, tcpport, this.configHandler != null && this.configHandler.unixDomainSocketEnabled());
        if (port == 0) {
            this.shutdownSession();
            return;
        }
        this.mcPort = EMPTY_STRING + port;
        if (this.configFileExecutionRequestCounter != -1 && this.configHandler != null) {
            for (int i = 0; i < this.configFileExecutionRequestCounter; ++i) {
                this.executeList.addAll(this.configHandler.getExecuteElements());
            }
            this.configFileExecutionRequestCounter = -1;
        }
        if (this.startHCRequested) {
            this.startHC();
        }
    }

    private void startHC() {
        this.startHCRequested = true;
        int stateValue = this.jnimw.get_state().getValue();
        if (1 != stateValue && 2 != stateValue) {
            this.initialization();
            return;
        }
        this.startHostControllers();
        this.startHCRequested = false;
    }

    private void configure() {
        this.configureRequested = true;
        int stateValue = this.jnimw.get_state().getValue();
        if (3 != stateValue && 5 != stateValue) {
            this.startHC();
            return;
        }
        this.jnimw.configure(this.generateCfgString());
        this.configureRequested = false;
    }

    private void createMTC() {
        this.createMTCRequested = true;
        int stateValue = this.jnimw.get_state().getValue();
        if (5 != stateValue) {
            this.configure();
            return;
        }
        this.jnimw.create_mtc(0);
        this.createMTCRequested = false;
    }

    private void startTest(boolean automaticExecution) {
        boolean invalidSelection = false;
        block6: do {
            if (automaticExecution && this.configFilePath != null && this.configFilePath.length() != 0 && !invalidSelection) {
                this.lastTimeSelection = "configuration file";
                this.lastTimeSelectionTime = 1;
                this.lastTimeSelectionType = ExecuteDialog.ExecutableType.CONFIGURATIONFILE;
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ExecuteDialog dialog = new ExecuteDialog(null);
                        dialog.setControlparts(JniExecutor.this.availableControlParts);
                        dialog.setTestcases(JniExecutor.this.availableTestcases);
                        dialog.setTestsets(JniExecutor.this.availableTestSetNames);
                        if (JniExecutor.this.configFilePath != null) {
                            dialog.setConfigurationFile(JniExecutor.this.configFilePath);
                        }
                        dialog.setSelection(JniExecutor.this.lastTimeSelection, JniExecutor.this.lastTimeSelectionTime, JniExecutor.this.lastTimeSelectionType);
                        if (dialog.open() != 0) {
                            JniExecutor.this.executionStarted = false;
                            JniExecutor.this.shutdownSession();
                            return;
                        }
                        JniExecutor.this.lastTimeSelection = dialog.getSelectedElement();
                        JniExecutor.this.lastTimeSelectionTime = dialog.getSelectionTimes();
                        JniExecutor.this.lastTimeSelectionType = dialog.getSelectionType();
                    }
                });
            }
            switch (this.lastTimeSelectionType) {
                case TESTCASE: {
                    invalidSelection = false;
                    for (int i = 0; i < this.lastTimeSelectionTime; ++i) {
                        this.executeList.add(this.lastTimeSelection);
                    }
                    this.executedTests.ensureCapacity(this.executedTests.size() + this.lastTimeSelectionTime);
                    break;
                }
                case TESTSET: {
                    invalidSelection = false;
                    int size = this.availableTestSetNames.size();
                    for (int i = 0; i < size; ++i) {
                        if (!((String)this.availableTestSetNames.get(i)).equals(this.lastTimeSelection)) continue;
                        for (int j = 0; j < this.lastTimeSelectionTime; ++j) {
                            this.executeList.addAll((Collection)this.availableTestSetContents.get(i));
                        }
                        this.executedTests.ensureCapacity(this.executedTests.size() + this.lastTimeSelectionTime * ((List)this.availableTestSetContents.get(i)).size());
                    }
                    continue block6;
                }
                case CONTROLPART: {
                    invalidSelection = false;
                    for (int i = 0; i < this.lastTimeSelectionTime; ++i) {
                        this.executeList.add(this.lastTimeSelection);
                    }
                    this.executedTests.ensureCapacity(this.executedTests.size() + this.lastTimeSelectionTime * 5);
                    break;
                }
                case CONFIGURATIONFILE: {
                    if (this.configHandler == null) {
                        this.configFileExecutionRequestCounter = this.lastTimeSelectionTime;
                        invalidSelection = false;
                    } else {
                        List configurationFileElements = this.configHandler.getExecuteElements();
                        if (configurationFileElements.isEmpty()) {
                            invalidSelection = true;
                            Display.getDefault().syncExec((Runnable)new BaseExecutor.EmptyExecutionRunnable());
                        } else {
                            invalidSelection = false;
                            for (int i = 0; i < this.lastTimeSelectionTime; ++i) {
                                this.executeList.addAll(configurationFileElements);
                            }
                        }
                    }
                    this.executedTests.ensureCapacity(this.executedTests.size() + this.lastTimeSelectionTime);
                    break;
                }
            }
        } while (invalidSelection);
        this.executionStarted = true;
        this.executeRequested = true;
        if (8 == this.jnimw.get_state().getValue()) {
            this.executeNextTest();
        } else {
            this.createMTC();
        }
        this.saveLastTimeUsageInfo();
    }

    private void executeNextTest() {
        if (8 != this.jnimw.get_state().getValue()) {
            this.createMTC();
            return;
        }
        String testElement = this.executeList.remove(0);
        int i = testElement.indexOf(46);
        if (i != -1) {
            if ("control".equals(testElement.substring(i + 1))) {
                this.jnimw.execute_control(testElement.substring(0, i));
            } else {
                this.jnimw.execute_testcase(testElement.substring(0, i), testElement.substring(i + 1));
            }
        } else {
            this.jnimw.execute_control(testElement);
        }
    }

    private void stop() {
        this.executeList.clear();
        this.executeRequested = false;
        this.jnimw.stop_execution();
    }

    private void exitMTC() {
        int stateValue = this.jnimw.get_state().getValue();
        if (10 == stateValue || 11 == stateValue || 13 == stateValue) {
            this.stop();
            return;
        }
        if (8 != stateValue) {
            return;
        }
        this.jnimw.exit_mtc();
    }

    @Override
    protected void shutdownSession() {
        this.shutdownRequested = true;
        this.simpleExecutionRunning = false;
        int stateValue = this.jnimw.get_state().getValue();
        if (1 == stateValue || 2 == stateValue || 3 == stateValue || 5 == stateValue) {
            this.jnimw.shutdown_session();
            this.startHCRequested = false;
            this.configureRequested = false;
            this.createMTCRequested = false;
            this.executeRequested = false;
        } else {
            this.exitMTC();
        }
        super.shutdownSession();
    }

    private void updateInfoDisplay() {
        JNIMiddleWare middleware = this.jnimw;
        McStateEnum mcState = middleware.get_state();
        MainControllerElement tempRoot = new MainControllerElement("Temporal root", this);
        String mcStateName = middleware.get_mc_state_name(mcState);
        tempRoot.setStateInfo(new InformationElement("state: " + mcStateName));
        int nofHosts = middleware.get_nof_hosts();
        for (int i = 0; i < nofHosts; ++i) {
            HostStruct host = middleware.get_host_data(i);
            HostControllerElement tempHost = new HostControllerElement("Host Controller: ");
            tempRoot.addHostController(tempHost);
            tempHost.setIPAddressInfo(new InformationElement("IP address: " + host.hostname));
            tempHost.setIPNumberInfo(new InformationElement("IP number: " + host.ip_addr));
            tempHost.setHostNameInfo(new InformationElement("Local host name:" + host.hostname_local));
            tempHost.setOperatingSystemInfo(new InformationElement(host.system_name + " " + host.system_release + " " + host.system_version));
            tempHost.setStateInfo(new InformationElement("State: " + middleware.get_hc_state_name(host.hc_state)));
            int activeComponents = host.n_active_components;
            int[] components = (int[])host.components.clone();
            middleware.release_data();
            for (int component_index = 0; component_index < activeComponents; ++component_index) {
                VerdictTypeEnum localVerdict;
                StringBuilder builder;
                ComponentStruct comp = middleware.get_component_data(components[component_index]);
                ComponentElement tempComponent = new ComponentElement("Component: " + comp.comp_name, new InformationElement("Component reference: " + comp.comp_ref));
                tempHost.addComponent(tempComponent);
                QualifiedName qualifiedName = comp.comp_type;
                if (qualifiedName != null && qualifiedName.definition_name != null) {
                    builder = new StringBuilder("Component type: ");
                    if (qualifiedName.module_name != null) {
                        builder.append(qualifiedName.module_name).append('.');
                    }
                    builder.append(qualifiedName.definition_name);
                    tempComponent.setTypeInfo(new InformationElement(builder.toString()));
                }
                tempComponent.setStateInfo(new InformationElement(middleware.get_tc_state_name(comp.tc_state)));
                qualifiedName = comp.tc_fn_name;
                if (qualifiedName.definition_name != null) {
                    builder = new StringBuilder(comp.comp_ref == 1 ? "test case" : "function");
                    if (qualifiedName.module_name != null) {
                        builder.append(qualifiedName.module_name).append('.');
                    }
                    builder.append(qualifiedName.definition_name);
                    tempComponent.setExecutedInfo(new InformationElement(builder.toString()));
                }
                if ((localVerdict = comp.local_verdict) == null) continue;
                builder = new StringBuilder("local verdict: ");
                builder.append(localVerdict.getName());
            }
        }
        middleware.release_data();
        if (this.mainControllerRoot != null) {
            this.mainControllerRoot.children().clear();
            this.mainControllerRoot.transferData(tempRoot);
        }
        if (Activator.getMainView() != null) {
            Activator.getMainView().refreshAll();
        }
    }

    private void updateGUI() {
        int stateValue = this.jnimw.get_state().getValue();
        this.automaticExecution.setEnabled(!this.isTerminated && this.executeList.isEmpty());
        this.startSession.setEnabled(!this.isTerminated && 0 == stateValue);
        this.configure.setEnabled(1 == stateValue || 2 == stateValue || 3 == stateValue || 5 == stateValue);
        this.startHCs.setEnabled(1 == stateValue || 2 == stateValue);
        this.cmtc.setEnabled(1 == stateValue || 2 == stateValue || 3 == stateValue || 5 == stateValue);
        this.smtc.setEnabled(8 == stateValue);
        this.cont.setEnabled(13 == stateValue);
        this.stop.setEnabled(10 == stateValue || 11 == stateValue || 13 == stateValue || 12 == stateValue);
        this.emtc.setEnabled(8 == stateValue);
        this.shutdownSession.setEnabled(8 == stateValue || 1 == stateValue || 2 == stateValue || 3 == stateValue || 5 == stateValue);
        this.generalPause.setEnabled(5 == stateValue || 8 == stateValue || 10 == stateValue || 11 == stateValue || 13 == stateValue);
        this.generalPause.setChecked(this.jnimw.get_stop_after_testcase());
        this.generalLogging.setEnabled(5 == stateValue || 8 == stateValue || 10 == stateValue || 11 == stateValue || 13 == stateValue);
        this.info.setEnabled(5 == stateValue || 8 == stateValue || 10 == stateValue || 11 == stateValue || 13 == stateValue);
        if (Activator.getMainView() != null) {
            Activator.getMainView().refreshIfSelected(this.mainControllerRoot);
        }
    }

    @Override
    public boolean isTerminated() {
        return this.isTerminated;
    }

    @Override
    public IProcess getProcess() {
        return null;
    }

    @Override
    public void terminate(boolean external) {
        McStateEnum state = this.jnimw.get_state();
        if (0 == state.getValue()) {
            JniExecutor.setRunning(false);
            this.isTerminated = true;
            if (this.mainControllerRoot != null) {
                this.mainControllerRoot.setTerminated();
                LaunchElement launchElement = null;
                for (Map.Entry<ILaunch, BaseExecutor> entry : ExecutorStorage.getExecutorMap().entrySet()) {
                    if (!entry.getValue().equals(this.mainControllerRoot.executor()) || !LaunchStorage.getLaunchElementMap().containsKey(entry.getKey())) continue;
                    launchElement = LaunchStorage.getLaunchElementMap().get(entry.getKey());
                }
                if (launchElement != null) {
                    launchElement.setTerminated();
                }
                if (Activator.getMainView() != null) {
                    Activator.getMainView().refreshAll();
                }
            }
        } else {
            this.shutdownSession();
        }
        this.updateGUI();
    }

    @Override
    protected String getDefaultLogFileName() {
        return "%e.%h-part%i-%r.%s";
    }

    @Override
    protected String generateCfgString() {
        String result = super.generateCfgString();
        if (this.configHandler != null) {
            ArrayList<Integer> disallowedNodes = new ArrayList<Integer>();
            disallowedNodes.add(4);
            disallowedNodes.add(8);
            disallowedNodes.add(5);
            disallowedNodes.add(13);
            disallowedNodes.add(11);
            disallowedNodes.add(7);
            result = result + this.configHandler.toStringResolved(disallowedNodes);
        }
        return result;
    }
}

