/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.workbench.search;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.commons.workbench.TableTreePatternFilter;
import org.eclipse.mylyn.commons.workbench.search.TextSearchControl;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SearchHistoryPopupDialog
extends PopupDialog {
    private static final int MAX_HISTORY_NO_FILTER = 3;
    private static final int MAX_HISTORY_FILTER = 10;
    private final int side;
    private Rectangle trimBounds;
    private TextSearchControl textSearchControl;
    private Text textControl;
    private TableViewer historyTable;
    private TableTreePatternFilter patternFilter;
    private Composite additionalControlsComposite;
    private boolean isOpen = false;

    public SearchHistoryPopupDialog(Shell parent, int side) {
        super(parent, 540676, false, false, false, false, false, null, null);
        this.side = side;
        this.updateBounds();
    }

    protected void initializeBounds() {
        Rectangle monitorBounds = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getMonitor().getClientArea();
        Rectangle bounds = this.getShell().getBounds();
        int x = 0;
        int y = 0;
        switch (this.side) {
            case 128: {
                x = this.trimBounds.x;
                y = this.trimBounds.y + this.trimBounds.height;
                if (x + bounds.width <= monitorBounds.x + monitorBounds.width) break;
                x = this.trimBounds.x + this.trimBounds.width - bounds.width;
                break;
            }
            case 1024: {
                x = this.trimBounds.x;
                y = this.trimBounds.y - bounds.height;
                if (x + bounds.width <= monitorBounds.x + monitorBounds.width) break;
                x = this.trimBounds.x + this.trimBounds.width - bounds.width;
                break;
            }
            case 131072: {
                x = this.trimBounds.x + this.trimBounds.width - bounds.width;
                y = this.trimBounds.y + this.trimBounds.height;
                break;
            }
            case 16384: {
                x = this.trimBounds.x;
                y = this.trimBounds.y + this.trimBounds.height;
            }
        }
        this.getShell().setBounds(x, y, Math.max(this.trimBounds.width, bounds.width), bounds.height);
    }

    protected Control createContents(Composite parent) {
        this.getShell().setBackground(this.getShell().getDisplay().getSystemColor(16));
        Control createDialogArea = this.createDialogArea(parent);
        return createDialogArea;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.numColumns = 1;
        composite.setLayout((Layout)gl);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        this.createTable(composite);
        this.additionalControlsComposite = new Composite(composite, 0);
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.numColumns = 1;
        this.additionalControlsComposite.setLayout((Layout)gl);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.additionalControlsComposite);
        this.createAdditionalSearchRegion(this.additionalControlsComposite);
        if (this.additionalControlsComposite.getChildren().length == 0) {
            this.additionalControlsComposite.dispose();
            this.additionalControlsComposite = null;
        }
        parent.pack();
        return parent;
    }

    private void createTable(Composite composite) {
        this.historyTable = new TableViewer(composite, 65556);
        TableColumn bindingNameColumn = new TableColumn(this.historyTable.getTable(), 16384);
        bindingNameColumn.setWidth(2000);
        this.historyTable.setUseHashlookup(true);
        this.historyTable.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    Object[] elements = ((Collection)inputElement).toArray();
                    return this.reverseArray(elements);
                }
                return new Object[0];
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            private Object[] reverseArray(Object[] originalArray) {
                int i = 0;
                int j = originalArray.length - 1;
                while (i < j) {
                    Object firstElement = originalArray[i];
                    originalArray[i] = originalArray[j];
                    originalArray[j] = firstElement;
                    ++i;
                    --j;
                }
                return originalArray;
            }
        });
        if (this.textSearchControl != null) {
            this.historyTable.setInput(this.textSearchControl.getSearchHistory());
        } else {
            this.historyTable.setInput(Collections.emptyList());
        }
        this.historyTable.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                String text = SearchHistoryPopupDialog.this.getTextFromSelection(event.getSelection());
                if (text != null) {
                    SearchHistoryPopupDialog.this.textSearchControl.getTextControl().setText(text);
                    SearchHistoryPopupDialog.this.textControl.setSelection(text.length());
                    SearchHistoryPopupDialog.this.textSearchControl.addToSearchHistory(text);
                }
                SearchHistoryPopupDialog.this.close();
            }
        });
        this.historyTable.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                String text = SearchHistoryPopupDialog.this.getTextFromSelection(SearchHistoryPopupDialog.this.historyTable.getSelection());
                if (text != null) {
                    SearchHistoryPopupDialog.this.textSearchControl.getTextControl().setText(text);
                    SearchHistoryPopupDialog.this.textSearchControl.addToSearchHistory(text);
                }
                SearchHistoryPopupDialog.this.textSearchControl.getTextControl().setFocus();
                SearchHistoryPopupDialog.this.close();
            }
        });
        this.patternFilter = new TableTreePatternFilter();
        this.patternFilter.setIncludeLeadingWildcard(true);
        this.patternFilter.setPattern(this.textSearchControl.getTextControl().getText());
        this.historyTable.addFilter((ViewerFilter)this.patternFilter);
        if (this.textControl.getText().length() > 0) {
            this.historyTable.setSorter(new ViewerSorter());
            this.historyTable.setItemCount(Math.min(this.historyTable.getTable().getItemCount(), 10));
        } else {
            this.historyTable.setSorter(null);
            this.historyTable.setItemCount(Math.min(this.historyTable.getTable().getItemCount(), 3));
        }
        GridDataFactory.fillDefaults().grab(true, false).hint(this.trimBounds.width, -1).applyTo((Control)this.historyTable.getTable());
        this.setHistoryTableVisible(this.historyTable.getTable().getItemCount() > 0);
    }

    private void setHistoryTableVisible(boolean isVisible) {
        GridData layoutData = (GridData)this.historyTable.getTable().getLayoutData();
        this.historyTable.getTable().setVisible(isVisible);
        boolean wasVisible = !layoutData.exclude;
        boolean bl = layoutData.exclude = !isVisible;
        if (wasVisible != isVisible || isVisible) {
            this.getShell().pack();
        }
        this.initializeBounds();
    }

    private boolean shouldOpen() {
        return this.historyTable != null && this.historyTable.getTable() != null && this.historyTable.getTable().isVisible() || this.additionalControlsComposite != null;
    }

    private String getTextFromSelection(ISelection selection) {
        Object firstElement;
        if (selection instanceof StructuredSelection && (firstElement = ((StructuredSelection)selection).getFirstElement()) instanceof String) {
            return (String)firstElement;
        }
        return null;
    }

    public int open() {
        if (!this.isOpen) {
            this.isOpen = true;
            int rc = super.open();
            if (!this.shouldOpen()) {
                this.close();
            }
            return rc;
        }
        return 0;
    }

    public void asyncClose() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SearchHistoryPopupDialog.this.textControl != null && !SearchHistoryPopupDialog.this.textControl.isDisposed() && SearchHistoryPopupDialog.this.textControl.isFocusControl() || !SearchHistoryPopupDialog.this.hasFocus((Control)SearchHistoryPopupDialog.this.getShell())) {
                    SearchHistoryPopupDialog.this.close();
                }
            }
        });
    }

    public boolean close() {
        boolean b;
        if (this.patternFilter != null) {
            this.patternFilter.setPattern(null);
        }
        this.isOpen = !(b = super.close());
        return b;
    }

    private boolean updateBounds() {
        Rectangle bounds;
        if (this.textSearchControl == null || this.textSearchControl.getTextControl() == null || this.textSearchControl.getTextControl().isDisposed()) {
            bounds = new Rectangle(0, 0, 0, 0);
        } else {
            bounds = this.textSearchControl.getBounds();
            Point absPosition = this.textSearchControl.toDisplay(this.textSearchControl.getLocation());
            bounds.x = absPosition.x - bounds.x;
            bounds.y = absPosition.y - bounds.y;
        }
        if (this.trimBounds == null || !this.trimBounds.equals((Object)bounds)) {
            this.trimBounds = bounds;
            return true;
        }
        return false;
    }

    public void attach(TextSearchControl textSearchControl) {
        Assert.isNotNull((Object)((Object)textSearchControl));
        Assert.isNotNull((Object)textSearchControl.getTextControl());
        this.textSearchControl = textSearchControl;
        this.textControl = textSearchControl.getTextControl();
        textSearchControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!SearchHistoryPopupDialog.this.hasFocus((Control)SearchHistoryPopupDialog.this.textControl)) {
                    return;
                }
                if (!SearchHistoryPopupDialog.this.isOpen && SearchHistoryPopupDialog.this.textControl != null && !SearchHistoryPopupDialog.this.textControl.isDisposed() && SearchHistoryPopupDialog.this.textControl.getText().length() > 0) {
                    SearchHistoryPopupDialog.this.updateBounds();
                    SearchHistoryPopupDialog.this.open();
                }
                if (SearchHistoryPopupDialog.this.isOpen && SearchHistoryPopupDialog.this.historyTable != null && !SearchHistoryPopupDialog.this.historyTable.getTable().isDisposed() && SearchHistoryPopupDialog.this.patternFilter != null) {
                    SearchHistoryPopupDialog.this.patternFilter.setPattern(SearchHistoryPopupDialog.this.textControl.getText());
                    SearchHistoryPopupDialog.this.historyTable.setSelection(null);
                    SearchHistoryPopupDialog.this.historyTable.refresh();
                    if (SearchHistoryPopupDialog.this.textControl.getText().length() > 0) {
                        SearchHistoryPopupDialog.this.historyTable.setSorter(new ViewerSorter());
                        SearchHistoryPopupDialog.this.historyTable.setItemCount(Math.min(SearchHistoryPopupDialog.this.historyTable.getTable().getItemCount(), 10));
                    } else {
                        SearchHistoryPopupDialog.this.historyTable.setSorter(null);
                        SearchHistoryPopupDialog.this.historyTable.setItemCount(Math.min(SearchHistoryPopupDialog.this.historyTable.getTable().getItemCount(), 3));
                    }
                    SearchHistoryPopupDialog.this.setHistoryTableVisible(SearchHistoryPopupDialog.this.historyTable.getTable().getItemCount() > 0);
                    if (!SearchHistoryPopupDialog.this.shouldOpen()) {
                        SearchHistoryPopupDialog.this.asyncClose();
                    }
                }
            }
        });
        this.textControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SearchHistoryPopupDialog.this.close();
            }
        });
        this.textControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b' && SearchHistoryPopupDialog.this.isOpen) {
                    SearchHistoryPopupDialog.this.close();
                    e.doit = false;
                } else if (e.stateMask == 0 && e.keyCode == 0x1000002 && SearchHistoryPopupDialog.this.isOpen && SearchHistoryPopupDialog.this.historyTable.getTable() != null && !SearchHistoryPopupDialog.this.historyTable.getTable().isDisposed() && SearchHistoryPopupDialog.this.historyTable.getTable().getItemCount() > 0) {
                    SearchHistoryPopupDialog.this.historyTable.getTable().select(0);
                    SearchHistoryPopupDialog.this.historyTable.getTable().setFocus();
                    e.doit = false;
                } else if ((e.stateMask & SWT.MOD1) != 0 && e.keyCode == 0x1000002 && !SearchHistoryPopupDialog.this.isOpen) {
                    SearchHistoryPopupDialog.this.updateBounds();
                    SearchHistoryPopupDialog.this.open();
                    e.doit = false;
                }
            }
        });
        Listener moveResizeListener = new Listener(){

            public void handleEvent(Event event) {
                if (SearchHistoryPopupDialog.this.isOpen && SearchHistoryPopupDialog.this.updateBounds()) {
                    SearchHistoryPopupDialog.this.initializeBounds();
                }
            }
        };
        textSearchControl.addListener(10, moveResizeListener);
        textSearchControl.addListener(11, moveResizeListener);
        this.textControl.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                SearchHistoryPopupDialog.this.asyncClose();
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    private boolean hasFocus(Control control) {
        if (control != null && !control.isDisposed() && control.isFocusControl()) {
            return true;
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (this.hasFocus(child)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected void createAdditionalSearchRegion(Composite composite) {
    }
}

