/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.TeamOperation;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.ui.IWorkbenchPart;

public abstract class SynchronizeModelOperation
extends TeamOperation {
    private IDiffElement[] elements;

    private static IWorkbenchPart getPart(ISynchronizePageConfiguration configuration) {
        ISynchronizePageSite site;
        if (configuration != null && (site = configuration.getSite()) != null) {
            return site.getPart();
        }
        return null;
    }

    private static IRunnableContext getRunnableContext(ISynchronizePageConfiguration configuration) {
        if (configuration != null) {
            return configuration.getRunnableContext();
        }
        return null;
    }

    protected SynchronizeModelOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(SynchronizeModelOperation.getPart(configuration), SynchronizeModelOperation.getRunnableContext(configuration));
        this.elements = elements;
    }

    protected SyncInfoSet getSyncInfoSet() {
        return this.makeSyncInfoSetFromSelection(this.getSyncInfos());
    }

    public void scheduled(IJobChangeEvent event) {
        super.scheduled(event);
        this.markBusy(this.elements, true);
    }

    public void done(IJobChangeEvent event) {
        this.markBusy(this.elements, false);
        super.done(event);
    }

    private void markBusy(IDiffElement[] elements, boolean isBusy) {
        int i = 0;
        while (i < elements.length) {
            IDiffElement element = elements[i];
            if (element instanceof ISynchronizeModelElement) {
                ((ISynchronizeModelElement)element).setPropertyToRoot("org.eclipse.team.ui.busy", isBusy);
            }
            ++i;
        }
    }

    private SyncInfo[] getSyncInfos() {
        ArrayList<SyncInfo> filtered = new ArrayList<SyncInfo>();
        int i = 0;
        while (i < this.elements.length) {
            IDiffElement e = this.elements[i];
            if (e instanceof SyncInfoModelElement) {
                filtered.add(((SyncInfoModelElement)e).getSyncInfo());
            }
            ++i;
        }
        return filtered.toArray(new SyncInfo[filtered.size()]);
    }

    private SyncInfoSet makeSyncInfoSetFromSelection(SyncInfo[] infos) {
        return new SyncInfoSet(infos);
    }
}

