/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.decorators;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.util.SelfLoopEdgePredicate;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.transform.BidirectionalTransformer;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradientEdgePaintTransformer<V, E>
implements Transformer<E, Paint> {
    protected Color c1;
    protected Color c2;
    protected VisualizationViewer<V, E> vv;
    protected BidirectionalTransformer transformer;
    protected Predicate<Context<Graph<V, E>, E>> selfLoop = new SelfLoopEdgePredicate();

    public GradientEdgePaintTransformer(Color c1, Color c2, VisualizationViewer<V, E> vv) {
        this.c1 = c1;
        this.c2 = c2;
        this.vv = vv;
        this.transformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
    }

    public Paint transform(E e) {
        Layout layout = this.vv.getGraphLayout();
        Pair p = layout.getGraph().getEndpoints(e);
        Object b = p.getFirst();
        Object f = p.getSecond();
        Point2D pb = this.transformer.transform((Point2D)layout.transform(b));
        Point2D pf = this.transformer.transform((Point2D)layout.transform(f));
        float xB = (float)pb.getX();
        float yB = (float)pb.getY();
        float xF = (float)pf.getX();
        float yF = (float)pf.getY();
        if (layout.getGraph().getEdgeType(e) == EdgeType.UNDIRECTED) {
            xF = (xF + xB) / 2.0f;
            yF = (yF + yB) / 2.0f;
        }
        if (this.selfLoop.evaluate(Context.getInstance(layout.getGraph(), e))) {
            yF += 50.0f;
            xF += 50.0f;
        }
        return new GradientPaint(xB, yB, this.getColor1(e), xF, yF, this.getColor2(e), true);
    }

    protected Color getColor1(E e) {
        return this.c1;
    }

    protected Color getColor2(E e) {
        return this.c2;
    }
}

