/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.progress.IProgressService;

public abstract class FindAction
extends SelectionDispatchAction {
    private static final IJavaElement RETURN_WITHOUT_BEEP = JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot());
    private Class<?>[] fValidTypes = this.getValidTypes();
    private JavaEditor fEditor;
    private int numberOfElements;
    private int processedElementIndex;

    FindAction(IWorkbenchSite site) {
        super(site);
        this.init();
    }

    FindAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    abstract void init();

    abstract Class<?>[] getValidTypes();

    boolean canOperateOn(IStructuredSelection sel) {
        IJavaElement[] elements;
        if (sel == null || sel.isEmpty()) {
            return false;
        }
        IJavaElement[] iJavaElementArray = elements = this.getJavaElements(sel, true);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement iJavaElement = iJavaElementArray[n2];
            if (!this.canOperateOn(iJavaElement)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    boolean canOperateOn(IJavaElement element) {
        if (element == null || this.fValidTypes == null || this.fValidTypes.length == 0 || !ActionUtil.isOnBuildPath(element)) {
            return false;
        }
        int i = 0;
        while (i < this.fValidTypes.length) {
            if (this.fValidTypes[i].isInstance(element)) {
                if (element.getElementType() == 4) {
                    return this.hasChildren((IPackageFragment)element);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasChildren(IPackageFragment packageFragment) {
        try {
            return packageFragment.hasChildren();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private IJavaElement getTypeIfPossible(IJavaElement o, boolean silent) {
        switch (o.getElementType()) {
            case 5: {
                if (silent) {
                    return o;
                }
                return this.findType((ICompilationUnit)o, silent);
            }
            case 6: {
                return ((IClassFile)o).getType();
            }
        }
        return o;
    }

    IJavaElement[] getJavaElements(IStructuredSelection selection, boolean silent) {
        IJavaElement[] javaElements = new IJavaElement[selection.size()];
        int index = 0;
        for (Object firstElement : selection) {
            IJavaElement elem = null;
            if (firstElement instanceof IJavaElement) {
                elem = (IJavaElement)firstElement;
            } else if (firstElement instanceof IAdaptable) {
                elem = (IJavaElement)((IAdaptable)firstElement).getAdapter(IJavaElement.class);
            }
            if (elem == null) continue;
            elem = this.getTypeIfPossible(elem, silent);
            javaElements[index++] = elem;
            if (elem == RETURN_WITHOUT_BEEP) break;
        }
        return javaElements;
    }

    private void showOperationUnavailableDialog() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)SearchMessages.JavaElementAction_operationUnavailable_title, (String)this.getOperationUnavailableMessage());
    }

    String getOperationUnavailableMessage() {
        return SearchMessages.JavaElementAction_operationUnavailable_generic;
    }

    private IJavaElement findType(ICompilationUnit cu, boolean silent) {
        Object[] types = null;
        try {
            types = cu.getAllTypes();
        }
        catch (JavaModelException ex) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)ex))) {
                ExceptionHandler.log(ex, SearchMessages.JavaElementAction_error_open_message);
            }
            if (silent) {
                return RETURN_WITHOUT_BEEP;
            }
            return null;
        }
        if (types.length == 1 || silent && types.length > 0) {
            return types[0];
        }
        if (silent) {
            return RETURN_WITHOUT_BEEP;
        }
        if (types.length == 0) {
            return null;
        }
        String title = SearchMessages.JavaElementAction_typeSelectionDialog_title;
        String message = SearchMessages.JavaElementAction_typeSelectionDialog_message;
        int flags = JavaElementLabelProvider.SHOW_DEFAULT;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements(types);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return RETURN_WITHOUT_BEEP;
    }

    @Override
    public void run(IStructuredSelection selection) {
        IJavaElement[] elements = this.getJavaElements(selection, false);
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            if (element == null || !element.exists()) {
                this.showOperationUnavailableDialog();
                return;
            }
            if (element == RETURN_WITHOUT_BEEP) {
                return;
            }
            if (!ActionUtil.isProcessable(this.getShell(), element)) {
                return;
            }
            ++i;
        }
        this.run(elements);
    }

    @Override
    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.fEditor)) {
            return;
        }
        try {
            String title = SearchMessages.SearchElementSelectionDialog_title;
            String message = SearchMessages.SearchElementSelectionDialog_message;
            IJavaElement[] elements = SelectionConverter.codeResolveForked(this.fEditor, true);
            if (elements.length > 0 && this.canOperateOn(elements[0])) {
                IJavaElement element = elements[0];
                if (elements.length > 1) {
                    element = SelectionConverter.selectJavaElement(elements, this.getShell(), title, message);
                }
                if (element != null) {
                    this.run(element);
                }
            } else {
                this.showOperationUnavailableDialog();
            }
        }
        catch (InvocationTargetException ex) {
            String title = SearchMessages.Search_Error_search_title;
            String message = SearchMessages.Search_Error_codeResolve;
            ExceptionHandler.handle(ex, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canOperateOn(selection));
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    public void run(IJavaElement element) {
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        this.run(new IJavaElement[]{element});
    }

    public void run(IJavaElement[] elements) {
        try {
            this.numberOfElements = elements.length;
            ArrayList<QuerySpecification> queryList = new ArrayList<QuerySpecification>(this.numberOfElements);
            this.processedElementIndex = 0;
            IJavaElement[] iJavaElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element = iJavaElementArray[n2];
                ++this.processedElementIndex;
                queryList.add(this.createQuery(element));
                ++n2;
            }
            this.performNewSearch(new JavaSearchQuery(queryList));
        }
        catch (JavaModelException ex) {
            ExceptionHandler.handle((CoreException)((Object)ex), this.getShell(), SearchMessages.Search_Error_search_notsuccessful_title, SearchMessages.Search_Error_search_notsuccessful_message);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private void performNewSearch(JavaSearchQuery query) {
        if (query.canRunInBackground()) {
            SearchUtil.runQueryInBackground(query);
        } else {
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            IStatus status = SearchUtil.runQueryInForeground((IRunnableContext)progressService, query);
            if (status.matches(7)) {
                ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.Search_Error_search_title, (String)SearchMessages.Search_Error_search_message, (IStatus)status);
            }
        }
    }

    QuerySpecification createQuery(IJavaElement element) throws JavaModelException, InterruptedException {
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        IJavaSearchScope scope = factory.createWorkspaceScope(true);
        String description = factory.getWorkspaceScopeDescription(true);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }

    abstract int getLimitTo();

    IType getType(IJavaElement element) {
        if (element == null) {
            return null;
        }
        IType type = null;
        if (element.getElementType() == 7) {
            type = (IType)element;
        } else if (element instanceof IMember) {
            type = ((IMember)element).getDeclaringType();
        } else if (element instanceof ILocalVariable) {
            type = (IType)element.getAncestor(7);
        }
        return type;
    }

    JavaEditor getEditor() {
        return this.fEditor;
    }

    boolean isMultiSelect() {
        return this.numberOfElements > 1;
    }

    boolean isLastElement() {
        return this.numberOfElements == this.processedElementIndex;
    }

    boolean isFirstElement() {
        return this.processedElementIndex == 1;
    }
}

