/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSRefactoring;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.nls.ExternalizeWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.nls.NLSUIMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ExternalizeWizard
extends RefactoringWizard {
    public ExternalizeWizard(NLSRefactoring refactoring) {
        super((Refactoring)refactoring, 3);
        this.setDefaultPageTitle(Messages.format(NLSUIMessages.ExternalizeWizardPage_title, BasicElementLabels.getFileName((ITypeRoot)refactoring.getCu())));
        this.setWindowTitle(NLSUIMessages.ExternalizeWizard_name);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_EXTERNALIZE_STRINGS);
    }

    protected void addUserInputPages() {
        NLSRefactoring nlsRefac = (NLSRefactoring)this.getRefactoring();
        ExternalizeWizardPage page = new ExternalizeWizardPage(nlsRefac);
        page.setMessage(NLSUIMessages.ExternalizeWizard_select);
        this.addPage((IWizardPage)page);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return super.canFinish() && !(page instanceof ExternalizeWizardPage);
    }

    public static void open(final ICompilationUnit unit, final Shell shell) {
        if (unit == null || !unit.exists()) {
            return;
        }
        Display display = shell != null ? shell.getDisplay() : Display.getCurrent();
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                NLSRefactoring refactoring = null;
                try {
                    refactoring = NLSRefactoring.create(unit);
                }
                catch (IllegalArgumentException e) {
                    Status status = new Status(4, JavaPlugin.getPluginId(), e.getLocalizedMessage());
                    ExceptionHandler.handle((IStatus)status, NLSUIMessages.ExternalizeWizard_name, NLSUIMessages.ExternalizeWizard_error_message);
                }
                if (refactoring != null) {
                    new RefactoringStarter().activate(new ExternalizeWizard(refactoring), shell, ActionMessages.ExternalizeStringsAction_dialog_title, 4);
                }
            }
        });
    }
}

