/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.OutOfMemoryCheck;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class OnTheFlyCheckerPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Preferences of the on-the-fly checker";
    private static final String CHECK_MEMORY = "Warn and disable parsing before the system runs out of memory";
    private static final String ENABLE_PARSING = "Enable parsing of TTCN-3, ASN.1 and Runtime Configuration files";
    private static final String ENABLE_INCREMENTAL_PARSING = "Enable the incremental parsing of TTCN-3 files (EXPERIMENTAL)";
    private static final String MINIMISE_MEMORY_USAGE = "Minimise memory usage";
    private static final String DELAY_SEMANTIC_CHECKING = "Delay the on-the-fly semantic check till the file is saved";
    private static final String RECONCILER_TIMEOUT = "Timeout in seconds before on-the-fly check starts";
    private Composite composite;
    private BooleanFieldEditor checkForLowMemory;
    private BooleanFieldEditor useOnTheFlyParsing;
    private BooleanFieldEditor useIncrementalParsing;
    private BooleanFieldEditor delaySemanticCheckTillSave;
    private IntegerFieldEditor reconcilerTimeout;

    public OnTheFlyCheckerPreferencePage() {
        super(1);
    }

    protected void createFieldEditors() {
        Composite tempParent = this.getFieldEditorParent();
        this.checkForLowMemory = new BooleanFieldEditor("org.eclipse.titan.designer.checkForLowMemory", CHECK_MEMORY, tempParent);
        this.addField((FieldEditor)this.checkForLowMemory);
        this.useOnTheFlyParsing = new BooleanFieldEditor("org.eclipse.titan.designer.useOnTheFlyParsing", ENABLE_PARSING, tempParent);
        this.addField((FieldEditor)this.useOnTheFlyParsing);
        this.useIncrementalParsing = new BooleanFieldEditor("org.eclipse.titan.designer.useIncrementalParsing", ENABLE_INCREMENTAL_PARSING, tempParent);
        this.addField((FieldEditor)this.useIncrementalParsing);
        this.composite = new Composite(tempParent, 0);
        this.reconcilerTimeout = new IntegerFieldEditor("org.eclipse.titan.designer.reconcilerTimeout", RECONCILER_TIMEOUT, this.composite);
        this.reconcilerTimeout.setValidRange(0, 10);
        this.reconcilerTimeout.setTextLimit(2);
        this.addField((FieldEditor)this.reconcilerTimeout);
        this.delaySemanticCheckTillSave = new BooleanFieldEditor("org.eclipse.titan.designer.delaySemantiCheckingTillSave", DELAY_SEMANTIC_CHECKING, tempParent);
        this.addField((FieldEditor)this.delaySemanticCheckTillSave);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void dispose() {
        if (this.getPreferenceStore().getBoolean("org.eclipse.titan.designer.useOnTheFlyParsing")) {
            OutOfMemoryCheck.resetOutOfMemoryflag();
        }
        this.useOnTheFlyParsing.dispose();
        this.useIncrementalParsing.dispose();
        this.delaySemanticCheckTillSave.dispose();
        this.reconcilerTimeout.dispose();
        this.composite.dispose();
        super.dispose();
    }

    private boolean isImportantChanged() {
        return false;
    }

    public void performApply() {
        if (this.isImportantChanged() && this.getPreferenceStore().getBoolean("org.eclipse.titan.designer.useOnTheFlyParsing")) {
            ErrorReporter.parallelWarningDisplayInMessageDialog((String)"On-the-fly analyzer", (String)"Settings of the on-the-fly analyzer have changed, the known projects have to be re-analyzed completly.\nThis might take some time.");
            GlobalParser.clearSemanticInformation();
            GlobalParser.reAnalyzeSemantically();
        }
        if (this.getPreferenceStore().getBoolean("org.eclipse.titan.designer.useOnTheFlyParsing")) {
            OutOfMemoryCheck.resetOutOfMemoryflag();
        }
        super.performApply();
    }
}

