/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.testportpar;

import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.TestportParameterSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.testportpar.TestportParameterTransfer;

public final class TestportParameterSectionDropTargetListener
implements DropTargetListener {
    private TableViewer viewer;
    private ConfigEditor editor;

    public TestportParameterSectionDropTargetListener(TableViewer viewer, ConfigEditor editor) {
        this.viewer = viewer;
        this.editor = editor;
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16 && (event.operations & 3) == 0) {
            event.detail = 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (event.detail == 16 && (event.operations & 3) == 0) {
            event.detail = 0;
        }
    }

    public void dragOver(DropTargetEvent event) {
        if (event.item == null) {
            event.feedback = 8;
            event.detail = 0;
        } else {
            event.feedback = event.item.getData() instanceof TestportParameterSectionHandler.TestportParameter ? 25 : 10;
            if (event.detail == 0) {
                if ((event.operations & 2) != 0) {
                    event.detail = 2;
                } else if ((event.operations & 1) != 0) {
                    event.detail = 1;
                }
            }
        }
    }

    public void drop(DropTargetEvent event) {
        if (TestportParameterTransfer.getInstance().isSupportedType(event.currentDataType) && event.item != null && this.viewer.getInput() != null) {
            TestportParameterSectionHandler testportParameterSectionHandler = (TestportParameterSectionHandler)this.viewer.getInput();
            TestportParameterSectionHandler.TestportParameter element = (TestportParameterSectionHandler.TestportParameter)event.item.getData();
            TestportParameterSectionHandler.TestportParameter[] items = (TestportParameterSectionHandler.TestportParameter[])event.data;
            int baseindex = testportParameterSectionHandler.getTestportParameters().indexOf(element);
            ParseTree parent = testportParameterSectionHandler.getLastSectionRoot();
            ConfigTreeNodeUtilities.removeChild((ParseTree)parent, (ParseTree)element.getRoot());
            ConfigTreeNodeUtilities.addChild((ParseTree)parent, (ParseTree)element.getRoot(), (int)baseindex);
            if (items.length > 0) {
                for (int i = 0; i < items.length - 1; ++i) {
                    testportParameterSectionHandler.getTestportParameters().add(++baseindex, items[i]);
                }
                testportParameterSectionHandler.getTestportParameters().add(++baseindex, items[items.length - 1]);
            }
            this.viewer.refresh(true);
            this.editor.setDirty();
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }
}

